package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyStorageBundle invokes the sgw.ModifyStorageBundle API synchronously
func (client *Client) ModifyStorageBundle(request *ModifyStorageBundleRequest) (response *ModifyStorageBundleResponse, err error) {
	response = CreateModifyStorageBundleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyStorageBundleWithChan invokes the sgw.ModifyStorageBundle API asynchronously
func (client *Client) ModifyStorageBundleWithChan(request *ModifyStorageBundleRequest) (<-chan *ModifyStorageBundleResponse, <-chan error) {
	responseChan := make(chan *ModifyStorageBundleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyStorageBundle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyStorageBundleWithCallback invokes the sgw.ModifyStorageBundle API asynchronously
func (client *Client) ModifyStorageBundleWithCallback(request *ModifyStorageBundleRequest, callback func(response *ModifyStorageBundleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyStorageBundleResponse
		var err error
		defer close(result)
		response, err = client.ModifyStorageBundle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyStorageBundleRequest is the request struct for api ModifyStorageBundle
type ModifyStorageBundleRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	SecurityToken   string `position:"Query" name:"SecurityToken"`
	Name            string `position:"Query" name:"Name"`
	StorageBundleId string `position:"Query" name:"StorageBundleId"`
}

// ModifyStorageBundleResponse is the response struct for api ModifyStorageBundle
type ModifyStorageBundleResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         bool   `json:"Success" xml:"Success"`
	Code            string `json:"Code" xml:"Code"`
	Message         string `json:"Message" xml:"Message"`
	StorageBundleId string `json:"StorageBundleId" xml:"StorageBundleId"`
}

// CreateModifyStorageBundleRequest creates a request to invoke ModifyStorageBundle API
func CreateModifyStorageBundleRequest() (request *ModifyStorageBundleRequest) {
	request = &ModifyStorageBundleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ModifyStorageBundle", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyStorageBundleResponse creates a response to parse from ModifyStorageBundle response
func CreateModifyStorageBundleResponse() (response *ModifyStorageBundleResponse) {
	response = &ModifyStorageBundleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
