package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpnGateway invokes the vpc.DeleteVpnGateway API synchronously
func (client *Client) DeleteVpnGateway(request *DeleteVpnGatewayRequest) (response *DeleteVpnGatewayResponse, err error) {
	response = CreateDeleteVpnGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpnGatewayWithChan invokes the vpc.DeleteVpnGateway API asynchronously
func (client *Client) DeleteVpnGatewayWithChan(request *DeleteVpnGatewayRequest) (<-chan *DeleteVpnGatewayResponse, <-chan error) {
	responseChan := make(chan *DeleteVpnGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpnGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpnGatewayWithCallback invokes the vpc.DeleteVpnGateway API asynchronously
func (client *Client) DeleteVpnGatewayWithCallback(request *DeleteVpnGatewayRequest, callback func(response *DeleteVpnGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpnGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpnGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpnGatewayRequest is the request struct for api DeleteVpnGateway
type DeleteVpnGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteVpnGatewayResponse is the response struct for api DeleteVpnGateway
type DeleteVpnGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpnGatewayRequest creates a request to invoke DeleteVpnGateway API
func CreateDeleteVpnGatewayRequest() (request *DeleteVpnGatewayRequest) {
	request = &DeleteVpnGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteVpnGateway", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpnGatewayResponse creates a response to parse from DeleteVpnGateway response
func CreateDeleteVpnGatewayResponse() (response *DeleteVpnGatewayResponse) {
	response = &DeleteVpnGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
