// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCompleteAttachmentUpload = "CompleteAttachmentUpload"

// CompleteAttachmentUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteAttachmentUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteAttachmentUpload for more information on using the CompleteAttachmentUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CompleteAttachmentUploadRequest method.
//	req, resp := client.CompleteAttachmentUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CompleteAttachmentUpload
func (c *ConnectParticipant) CompleteAttachmentUploadRequest(input *CompleteAttachmentUploadInput) (req *request.Request, output *CompleteAttachmentUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteAttachmentUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/complete-attachment-upload",
	}

	if input == nil {
		input = &CompleteAttachmentUploadInput{}
	}

	output = &CompleteAttachmentUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CompleteAttachmentUpload API operation for Amazon Connect Participant Service.
//
// Allows you to confirm that the attachment has been uploaded using the pre-signed
// URL provided in StartAttachmentUpload API.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation CompleteAttachmentUpload for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
//   - ServiceQuotaExceededException
//     The number of attachments per contact exceeds the quota.
//
//   - ConflictException
//     An attachment with that identifier is already being uploaded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CompleteAttachmentUpload
func (c *ConnectParticipant) CompleteAttachmentUpload(input *CompleteAttachmentUploadInput) (*CompleteAttachmentUploadOutput, error) {
	req, out := c.CompleteAttachmentUploadRequest(input)
	return out, req.Send()
}

// CompleteAttachmentUploadWithContext is the same as CompleteAttachmentUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteAttachmentUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) CompleteAttachmentUploadWithContext(ctx aws.Context, input *CompleteAttachmentUploadInput, opts ...request.Option) (*CompleteAttachmentUploadOutput, error) {
	req, out := c.CompleteAttachmentUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParticipantConnection = "CreateParticipantConnection"

// CreateParticipantConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipantConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipantConnection for more information on using the CreateParticipantConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParticipantConnectionRequest method.
//	req, resp := client.CreateParticipantConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CreateParticipantConnection
func (c *ConnectParticipant) CreateParticipantConnectionRequest(input *CreateParticipantConnectionInput) (req *request.Request, output *CreateParticipantConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateParticipantConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/connection",
	}

	if input == nil {
		input = &CreateParticipantConnectionInput{}
	}

	output = &CreateParticipantConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipantConnection API operation for Amazon Connect Participant Service.
//
// Creates the participant's connection.
//
// ParticipantToken is used for invoking this API instead of ConnectionToken.
//
// The participant token is valid for the lifetime of the participant – until
// they are part of a contact.
//
// The response URL for WEBSOCKET Type has a connect expiry timeout of 100s.
// Clients must manually connect to the returned websocket URL and subscribe
// to the desired topic.
//
// For chat, you need to publish the following on the established websocket
// connection:
//
// {"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}
//
// Upon websocket URL expiry, as specified in the response ConnectionExpiry
// parameter, clients need to call this API again to obtain a new websocket
// URL and perform the same steps as before.
//
// Message streaming support: This API can also be used together with the StartContactStreaming
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html)
// API to create a participant connection for chat contacts that are not using
// a websocket. For more information about message streaming, Enable real-time
// chat message streaming (https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html)
// in the Amazon Connect Administrator Guide.
//
// Feature specifications: For information about feature specifications, such
// as the allowed number of open websocket connections per participant, see
// Feature specifications (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits)
// in the Amazon Connect Administrator Guide.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation CreateParticipantConnection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CreateParticipantConnection
func (c *ConnectParticipant) CreateParticipantConnection(input *CreateParticipantConnectionInput) (*CreateParticipantConnectionOutput, error) {
	req, out := c.CreateParticipantConnectionRequest(input)
	return out, req.Send()
}

// CreateParticipantConnectionWithContext is the same as CreateParticipantConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipantConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) CreateParticipantConnectionWithContext(ctx aws.Context, input *CreateParticipantConnectionInput, opts ...request.Option) (*CreateParticipantConnectionOutput, error) {
	req, out := c.CreateParticipantConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeView = "DescribeView"

// DescribeViewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeView for more information on using the DescribeView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeViewRequest method.
//	req, resp := client.DescribeViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DescribeView
func (c *ConnectParticipant) DescribeViewRequest(input *DescribeViewInput) (req *request.Request, output *DescribeViewOutput) {
	op := &request.Operation{
		Name:       opDescribeView,
		HTTPMethod: "GET",
		HTTPPath:   "/participant/views/{ViewToken}",
	}

	if input == nil {
		input = &DescribeViewInput{}
	}

	output = &DescribeViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeView API operation for Amazon Connect Participant Service.
//
// Retrieves the view for the specified view token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation DescribeView for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DescribeView
func (c *ConnectParticipant) DescribeView(input *DescribeViewInput) (*DescribeViewOutput, error) {
	req, out := c.DescribeViewRequest(input)
	return out, req.Send()
}

// DescribeViewWithContext is the same as DescribeView with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) DescribeViewWithContext(ctx aws.Context, input *DescribeViewInput, opts ...request.Option) (*DescribeViewOutput, error) {
	req, out := c.DescribeViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectParticipant for more information on using the DisconnectParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectParticipantRequest method.
//	req, resp := client.DisconnectParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DisconnectParticipant
func (c *ConnectParticipant) DisconnectParticipantRequest(input *DisconnectParticipantInput) (req *request.Request, output *DisconnectParticipantOutput) {
	op := &request.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/disconnect",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	output = &DisconnectParticipantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectParticipant API operation for Amazon Connect Participant Service.
//
// Disconnects a participant.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation DisconnectParticipant for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DisconnectParticipant
func (c *ConnectParticipant) DisconnectParticipant(input *DisconnectParticipantInput) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	return out, req.Send()
}

// DisconnectParticipantWithContext is the same as DisconnectParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) DisconnectParticipantWithContext(ctx aws.Context, input *DisconnectParticipantInput, opts ...request.Option) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttachment = "GetAttachment"

// GetAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the GetAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttachment for more information on using the GetAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAttachmentRequest method.
//	req, resp := client.GetAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetAttachment
func (c *ConnectParticipant) GetAttachmentRequest(input *GetAttachmentInput) (req *request.Request, output *GetAttachmentOutput) {
	op := &request.Operation{
		Name:       opGetAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/attachment",
	}

	if input == nil {
		input = &GetAttachmentInput{}
	}

	output = &GetAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttachment API operation for Amazon Connect Participant Service.
//
// Provides a pre-signed URL for download of a completed attachment. This is
// an asynchronous API for use with active contacts.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation GetAttachment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetAttachment
func (c *ConnectParticipant) GetAttachment(input *GetAttachmentInput) (*GetAttachmentOutput, error) {
	req, out := c.GetAttachmentRequest(input)
	return out, req.Send()
}

// GetAttachmentWithContext is the same as GetAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) GetAttachmentWithContext(ctx aws.Context, input *GetAttachmentInput, opts ...request.Option) (*GetAttachmentOutput, error) {
	req, out := c.GetAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscript = "GetTranscript"

// GetTranscriptRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscript for more information on using the GetTranscript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTranscriptRequest method.
//	req, resp := client.GetTranscriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetTranscript
func (c *ConnectParticipant) GetTranscriptRequest(input *GetTranscriptInput) (req *request.Request, output *GetTranscriptOutput) {
	op := &request.Operation{
		Name:       opGetTranscript,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/transcript",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTranscriptInput{}
	}

	output = &GetTranscriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscript API operation for Amazon Connect Participant Service.
//
// Retrieves a transcript of the session, including details about any attachments.
// For information about accessing past chat contact transcripts for a persistent
// chat, see Enable persistent chat (https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation GetTranscript for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetTranscript
func (c *ConnectParticipant) GetTranscript(input *GetTranscriptInput) (*GetTranscriptOutput, error) {
	req, out := c.GetTranscriptRequest(input)
	return out, req.Send()
}

// GetTranscriptWithContext is the same as GetTranscript with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) GetTranscriptWithContext(ctx aws.Context, input *GetTranscriptInput, opts ...request.Option) (*GetTranscriptOutput, error) {
	req, out := c.GetTranscriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTranscriptPages iterates over the pages of a GetTranscript operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTranscript method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetTranscript operation.
//	pageNum := 0
//	err := client.GetTranscriptPages(params,
//	    func(page *connectparticipant.GetTranscriptOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ConnectParticipant) GetTranscriptPages(input *GetTranscriptInput, fn func(*GetTranscriptOutput, bool) bool) error {
	return c.GetTranscriptPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTranscriptPagesWithContext same as GetTranscriptPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) GetTranscriptPagesWithContext(ctx aws.Context, input *GetTranscriptInput, fn func(*GetTranscriptOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTranscriptInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTranscriptRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTranscriptOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendEvent = "SendEvent"

// SendEventRequest generates a "aws/request.Request" representing the
// client's request for the SendEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEvent for more information on using the SendEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendEventRequest method.
//	req, resp := client.SendEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendEvent
func (c *ConnectParticipant) SendEventRequest(input *SendEventInput) (req *request.Request, output *SendEventOutput) {
	op := &request.Operation{
		Name:       opSendEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/event",
	}

	if input == nil {
		input = &SendEventInput{}
	}

	output = &SendEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEvent API operation for Amazon Connect Participant Service.
//
// Sends an event.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation SendEvent for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendEvent
func (c *ConnectParticipant) SendEvent(input *SendEventInput) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	return out, req.Send()
}

// SendEventWithContext is the same as SendEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SendEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) SendEventWithContext(ctx aws.Context, input *SendEventInput, opts ...request.Option) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessage = "SendMessage"

// SendMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendMessage for more information on using the SendMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendMessageRequest method.
//	req, resp := client.SendMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendMessage
func (c *ConnectParticipant) SendMessageRequest(input *SendMessageInput) (req *request.Request, output *SendMessageOutput) {
	op := &request.Operation{
		Name:       opSendMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/message",
	}

	if input == nil {
		input = &SendMessageInput{}
	}

	output = &SendMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendMessage API operation for Amazon Connect Participant Service.
//
// Sends a message.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation SendMessage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendMessage
func (c *ConnectParticipant) SendMessage(input *SendMessageInput) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	return out, req.Send()
}

// SendMessageWithContext is the same as SendMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) SendMessageWithContext(ctx aws.Context, input *SendMessageInput, opts ...request.Option) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAttachmentUpload = "StartAttachmentUpload"

// StartAttachmentUploadRequest generates a "aws/request.Request" representing the
// client's request for the StartAttachmentUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAttachmentUpload for more information on using the StartAttachmentUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAttachmentUploadRequest method.
//	req, resp := client.StartAttachmentUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/StartAttachmentUpload
func (c *ConnectParticipant) StartAttachmentUploadRequest(input *StartAttachmentUploadInput) (req *request.Request, output *StartAttachmentUploadOutput) {
	op := &request.Operation{
		Name:       opStartAttachmentUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/start-attachment-upload",
	}

	if input == nil {
		input = &StartAttachmentUploadInput{}
	}

	output = &StartAttachmentUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAttachmentUpload API operation for Amazon Connect Participant Service.
//
// Provides a pre-signed Amazon S3 URL in response for uploading the file directly
// to S3.
//
// ConnectionToken is used for invoking this API instead of ParticipantToken.
//
// The Amazon Connect Participant Service APIs do not use Signature Version
// 4 authentication (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation StartAttachmentUpload for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Amazon Connect
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Amazon Connect.
//
//   - ServiceQuotaExceededException
//     The number of attachments per contact exceeds the quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/StartAttachmentUpload
func (c *ConnectParticipant) StartAttachmentUpload(input *StartAttachmentUploadInput) (*StartAttachmentUploadOutput, error) {
	req, out := c.StartAttachmentUploadRequest(input)
	return out, req.Send()
}

// StartAttachmentUploadWithContext is the same as StartAttachmentUpload with the addition of
// the ability to pass a context and additional request options.
//
// See StartAttachmentUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) StartAttachmentUploadWithContext(ctx aws.Context, input *StartAttachmentUploadInput, opts ...request.Option) (*StartAttachmentUploadOutput, error) {
	req, out := c.StartAttachmentUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The case-insensitive input to indicate standard MIME type that describes
// the format of the file that will be uploaded.
type AttachmentItem struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the attachment.
	AttachmentId *string `min:"1" type:"string"`

	// A case-sensitive name of the attachment being uploaded.
	AttachmentName *string `min:"1" type:"string"`

	// Describes the MIME file type of the attachment. For a list of supported file
	// types, see Feature specifications (https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html)
	// in the Amazon Connect Administrator Guide.
	ContentType *string `min:"1" type:"string"`

	// Status of the attachment.
	Status *string `type:"string" enum:"ArtifactStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentItem) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AttachmentItem) SetAttachmentId(v string) *AttachmentItem {
	s.AttachmentId = &v
	return s
}

// SetAttachmentName sets the AttachmentName field's value.
func (s *AttachmentItem) SetAttachmentName(v string) *AttachmentItem {
	s.AttachmentName = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *AttachmentItem) SetContentType(v string) *AttachmentItem {
	s.ContentType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AttachmentItem) SetStatus(v string) *AttachmentItem {
	s.Status = &v
	return s
}

type CompleteAttachmentUploadInput struct {
	_ struct{} `type:"structure"`

	// A list of unique identifiers for the attachments.
	//
	// AttachmentIds is a required field
	AttachmentIds []*string `min:"1" type:"list" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteAttachmentUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteAttachmentUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteAttachmentUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteAttachmentUploadInput"}
	if s.AttachmentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentIds"))
	}
	if s.AttachmentIds != nil && len(s.AttachmentIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttachmentIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentIds sets the AttachmentIds field's value.
func (s *CompleteAttachmentUploadInput) SetAttachmentIds(v []*string) *CompleteAttachmentUploadInput {
	s.AttachmentIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CompleteAttachmentUploadInput) SetClientToken(v string) *CompleteAttachmentUploadInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *CompleteAttachmentUploadInput) SetConnectionToken(v string) *CompleteAttachmentUploadInput {
	s.ConnectionToken = &v
	return s
}

type CompleteAttachmentUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteAttachmentUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteAttachmentUploadOutput) GoString() string {
	return s.String()
}

// An attachment with that identifier is already being uploaded.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Connection credentials.
type ConnectionCredentials struct {
	_ struct{} `type:"structure"`

	// The connection token.
	ConnectionToken *string `min:"1" type:"string"`

	// The expiration of the token.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	Expiry *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionCredentials) GoString() string {
	return s.String()
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *ConnectionCredentials) SetConnectionToken(v string) *ConnectionCredentials {
	s.ConnectionToken = &v
	return s
}

// SetExpiry sets the Expiry field's value.
func (s *ConnectionCredentials) SetExpiry(v string) *ConnectionCredentials {
	s.Expiry = &v
	return s
}

type CreateParticipantConnectionInput struct {
	_ struct{} `type:"structure"`

	// Amazon Connect Participant is used to mark the participant as connected for
	// customer participant in message streaming, as well as for agent or manager
	// participant in non-streaming chats.
	ConnectParticipant *bool `type:"boolean"`

	// This is a header parameter.
	//
	// The ParticipantToken as obtained from StartChatContact (https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html)
	// API response.
	//
	// ParticipantToken is a required field
	ParticipantToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// Type of connection information required. If you need CONNECTION_CREDENTIALS
	// along with marking participant as connected, pass CONNECTION_CREDENTIALS
	// in Type.
	Type []*string `min:"1" type:"list" enum:"ConnectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantConnectionInput"}
	if s.ParticipantToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantToken"))
	}
	if s.ParticipantToken != nil && len(*s.ParticipantToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParticipantToken", 1))
	}
	if s.Type != nil && len(s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectParticipant sets the ConnectParticipant field's value.
func (s *CreateParticipantConnectionInput) SetConnectParticipant(v bool) *CreateParticipantConnectionInput {
	s.ConnectParticipant = &v
	return s
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *CreateParticipantConnectionInput) SetParticipantToken(v string) *CreateParticipantConnectionInput {
	s.ParticipantToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateParticipantConnectionInput) SetType(v []*string) *CreateParticipantConnectionInput {
	s.Type = v
	return s
}

type CreateParticipantConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Creates the participant's connection credentials. The authentication token
	// associated with the participant's connection.
	ConnectionCredentials *ConnectionCredentials `type:"structure"`

	// Creates the participant's websocket connection.
	Websocket *Websocket `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionCredentials sets the ConnectionCredentials field's value.
func (s *CreateParticipantConnectionOutput) SetConnectionCredentials(v *ConnectionCredentials) *CreateParticipantConnectionOutput {
	s.ConnectionCredentials = v
	return s
}

// SetWebsocket sets the Websocket field's value.
func (s *CreateParticipantConnectionOutput) SetWebsocket(v *Websocket) *CreateParticipantConnectionOutput {
	s.Websocket = v
	return s
}

type DescribeViewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The connection token.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// An encrypted token originating from the interactive message of a ShowView
	// block operation. Represents the desired view.
	//
	// ViewToken is a required field
	ViewToken *string `location:"uri" locationName:"ViewToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeViewInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.ViewToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewToken"))
	}
	if s.ViewToken != nil && len(*s.ViewToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *DescribeViewInput) SetConnectionToken(v string) *DescribeViewInput {
	s.ConnectionToken = &v
	return s
}

// SetViewToken sets the ViewToken field's value.
func (s *DescribeViewInput) SetViewToken(v string) *DescribeViewInput {
	s.ViewToken = &v
	return s
}

type DescribeViewOutput struct {
	_ struct{} `type:"structure"`

	// A view resource object. Contains metadata and content necessary to render
	// the view.
	View *View `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeViewOutput) GoString() string {
	return s.String()
}

// SetView sets the View field's value.
func (s *DescribeViewOutput) SetView(v *View) *DescribeViewOutput {
	s.View = v
	return s
}

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectParticipantInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisconnectParticipantInput) SetClientToken(v string) *DisconnectParticipantInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *DisconnectParticipantInput) SetConnectionToken(v string) *DisconnectParticipantInput {
	s.ConnectionToken = &v
	return s
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) GoString() string {
	return s.String()
}

type GetAttachmentInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the attachment.
	//
	// AttachmentId is a required field
	AttachmentId *string `min:"1" type:"string" required:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttachmentInput"}
	if s.AttachmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentId"))
	}
	if s.AttachmentId != nil && len(*s.AttachmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttachmentId", 1))
	}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *GetAttachmentInput) SetAttachmentId(v string) *GetAttachmentInput {
	s.AttachmentId = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *GetAttachmentInput) SetConnectionToken(v string) *GetAttachmentInput {
	s.ConnectionToken = &v
	return s
}

type GetAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// This is the pre-signed URL that can be used for uploading the file to Amazon
	// S3 when used in response to StartAttachmentUpload (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html).
	Url *string `min:"1" type:"string"`

	// The expiration time of the URL in ISO timestamp. It's specified in ISO 8601
	// format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
	UrlExpiry *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttachmentOutput) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *GetAttachmentOutput) SetUrl(v string) *GetAttachmentOutput {
	s.Url = &v
	return s
}

// SetUrlExpiry sets the UrlExpiry field's value.
func (s *GetAttachmentOutput) SetUrlExpiry(v string) *GetAttachmentOutput {
	s.UrlExpiry = &v
	return s
}

type GetTranscriptInput struct {
	_ struct{} `type:"structure"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The contactId from the current contact chain for which transcript is needed.
	ContactId *string `min:"1" type:"string"`

	// The maximum number of results to return in the page. Default: 10.
	MaxResults *int64 `type:"integer"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The direction from StartPosition from which to retrieve message. Default:
	// BACKWARD when no StartPosition is provided, FORWARD with StartPosition.
	ScanDirection *string `type:"string" enum:"ScanDirection"`

	// The sort order for the records. Default: DESCENDING.
	SortOrder *string `type:"string" enum:"SortKey"`

	// A filtering option for where to start.
	StartPosition *StartPosition `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StartPosition != nil {
		if err := s.StartPosition.Validate(); err != nil {
			invalidParams.AddNested("StartPosition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *GetTranscriptInput) SetConnectionToken(v string) *GetTranscriptInput {
	s.ConnectionToken = &v
	return s
}

// SetContactId sets the ContactId field's value.
func (s *GetTranscriptInput) SetContactId(v string) *GetTranscriptInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTranscriptInput) SetMaxResults(v int64) *GetTranscriptInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTranscriptInput) SetNextToken(v string) *GetTranscriptInput {
	s.NextToken = &v
	return s
}

// SetScanDirection sets the ScanDirection field's value.
func (s *GetTranscriptInput) SetScanDirection(v string) *GetTranscriptInput {
	s.ScanDirection = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *GetTranscriptInput) SetSortOrder(v string) *GetTranscriptInput {
	s.SortOrder = &v
	return s
}

// SetStartPosition sets the StartPosition field's value.
func (s *GetTranscriptInput) SetStartPosition(v *StartPosition) *GetTranscriptInput {
	s.StartPosition = v
	return s
}

type GetTranscriptOutput struct {
	_ struct{} `type:"structure"`

	// The initial contact ID for the contact.
	InitialContactId *string `min:"1" type:"string"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The list of messages in the session.
	Transcript []*Item `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptOutput) GoString() string {
	return s.String()
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *GetTranscriptOutput) SetInitialContactId(v string) *GetTranscriptOutput {
	s.InitialContactId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTranscriptOutput) SetNextToken(v string) *GetTranscriptOutput {
	s.NextToken = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *GetTranscriptOutput) SetTranscript(v []*Item) *GetTranscriptOutput {
	s.Transcript = v
	return s
}

// This exception occurs when there is an internal failure in the Amazon Connect
// service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An item - message or event - that has been sent.
type Item struct {
	_ struct{} `type:"structure"`

	// The time when the message or event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// Provides information about the attachments.
	Attachments []*AttachmentItem `type:"list"`

	// The contactId on which the transcript item was originally sent. This field
	// is populated only when the transcript item is from the current chat session.
	ContactId *string `min:"1" type:"string"`

	// The content of the message or event.
	Content *string `min:"1" type:"string"`

	// The type of content of the item.
	ContentType *string `min:"1" type:"string"`

	// The chat display name of the sender.
	DisplayName *string `min:"1" type:"string"`

	// The ID of the item.
	Id *string `min:"1" type:"string"`

	// The metadata related to the message. Currently this supports only information
	// related to message receipts.
	MessageMetadata *MessageMetadata `type:"structure"`

	// The ID of the sender in the session.
	ParticipantId *string `min:"1" type:"string"`

	// The role of the sender. For example, is it a customer, agent, or system.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// The contactId on which the transcript item was originally sent. This field
	// is only populated for persistent chats when the transcript item is from the
	// past chat session. For more information, see Enable persistent chat (https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
	RelatedContactId *string `min:"1" type:"string"`

	// Type of the item: message or event.
	Type *string `type:"string" enum:"ChatItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Item) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Item) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *Item) SetAbsoluteTime(v string) *Item {
	s.AbsoluteTime = &v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *Item) SetAttachments(v []*AttachmentItem) *Item {
	s.Attachments = v
	return s
}

// SetContactId sets the ContactId field's value.
func (s *Item) SetContactId(v string) *Item {
	s.ContactId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *Item) SetContent(v string) *Item {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Item) SetContentType(v string) *Item {
	s.ContentType = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Item) SetDisplayName(v string) *Item {
	s.DisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Item) SetId(v string) *Item {
	s.Id = &v
	return s
}

// SetMessageMetadata sets the MessageMetadata field's value.
func (s *Item) SetMessageMetadata(v *MessageMetadata) *Item {
	s.MessageMetadata = v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Item) SetParticipantId(v string) *Item {
	s.ParticipantId = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *Item) SetParticipantRole(v string) *Item {
	s.ParticipantRole = &v
	return s
}

// SetRelatedContactId sets the RelatedContactId field's value.
func (s *Item) SetRelatedContactId(v string) *Item {
	s.RelatedContactId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Item) SetType(v string) *Item {
	s.Type = &v
	return s
}

// Contains metadata related to a message.
type MessageMetadata struct {
	_ struct{} `type:"structure"`

	// The identifier of the message that contains the metadata information.
	MessageId *string `min:"1" type:"string"`

	// The list of receipt information for a message for different recipients.
	Receipts []*Receipt `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageMetadata) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *MessageMetadata) SetMessageId(v string) *MessageMetadata {
	s.MessageId = &v
	return s
}

// SetReceipts sets the Receipts field's value.
func (s *MessageMetadata) SetReceipts(v []*Receipt) *MessageMetadata {
	s.Receipts = v
	return s
}

// The receipt for the message delivered to the recipient.
type Receipt struct {
	_ struct{} `type:"structure"`

	// The time when the message was delivered to the recipient.
	DeliveredTimestamp *string `min:"1" type:"string"`

	// The time when the message was read by the recipient.
	ReadTimestamp *string `min:"1" type:"string"`

	// The identifier of the recipient of the message.
	RecipientParticipantId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) GoString() string {
	return s.String()
}

// SetDeliveredTimestamp sets the DeliveredTimestamp field's value.
func (s *Receipt) SetDeliveredTimestamp(v string) *Receipt {
	s.DeliveredTimestamp = &v
	return s
}

// SetReadTimestamp sets the ReadTimestamp field's value.
func (s *Receipt) SetReadTimestamp(v string) *Receipt {
	s.ReadTimestamp = &v
	return s
}

// SetRecipientParticipantId sets the RecipientParticipantId field's value.
func (s *Receipt) SetRecipientParticipantId(v string) *Receipt {
	s.RecipientParticipantId = &v
	return s
}

// The resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the resource.
	ResourceId *string `type:"string"`

	// The type of Amazon Connect resource.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendEventInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The content of the event to be sent (for example, message text). For content
	// related to message receipts, this is supported in the form of a JSON string.
	//
	// Sample Content: "{\"messageId\":\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\"}"
	Content *string `min:"1" type:"string"`

	// The content type of the request. Supported types are:
	//
	//    * application/vnd.amazonaws.connect.event.typing
	//
	//    * application/vnd.amazonaws.connect.event.connection.acknowledged
	//
	//    * application/vnd.amazonaws.connect.event.message.delivered
	//
	//    * application/vnd.amazonaws.connect.event.message.read
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEventInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SendEventInput) SetClientToken(v string) *SendEventInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *SendEventInput) SetConnectionToken(v string) *SendEventInput {
	s.ConnectionToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendEventInput) SetContent(v string) *SendEventInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SendEventInput) SetContentType(v string) *SendEventInput {
	s.ContentType = &v
	return s
}

type SendEventOutput struct {
	_ struct{} `type:"structure"`

	// The time when the event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the response.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *SendEventOutput) SetAbsoluteTime(v string) *SendEventOutput {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *SendEventOutput) SetId(v string) *SendEventOutput {
	s.Id = &v
	return s
}

type SendMessageInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The content of the message.
	//
	//    * For text/plain and text/markdown, the Length Constraints are Minimum
	//    of 1, Maximum of 1024.
	//
	//    * For application/json, the Length Constraints are Minimum of 1, Maximum
	//    of 12000.
	//
	//    * For application/vnd.amazonaws.connect.message.interactive.response,
	//    the Length Constraints are Minimum of 1, Maximum of 12288.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of the content. Supported types are text/plain, text/markdown, application/json,
	// and application/vnd.amazonaws.connect.message.interactive.response.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendMessageInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SendMessageInput) SetClientToken(v string) *SendMessageInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *SendMessageInput) SetConnectionToken(v string) *SendMessageInput {
	s.ConnectionToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendMessageInput) SetContent(v string) *SendMessageInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SendMessageInput) SetContentType(v string) *SendMessageInput {
	s.ContentType = &v
	return s
}

type SendMessageOutput struct {
	_ struct{} `type:"structure"`

	// The time when the message was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the message.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendMessageOutput) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *SendMessageOutput) SetAbsoluteTime(v string) *SendMessageOutput {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *SendMessageOutput) SetId(v string) *SendMessageOutput {
	s.Id = &v
	return s
}

// The number of attachments per contact exceeds the quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartAttachmentUploadInput struct {
	_ struct{} `type:"structure"`

	// A case-sensitive name of the attachment being uploaded.
	//
	// AttachmentName is a required field
	AttachmentName *string `min:"1" type:"string" required:"true"`

	// The size of the attachment in bytes.
	//
	// AttachmentSizeInBytes is a required field
	AttachmentSizeInBytes *int64 `min:"1" type:"long" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// Describes the MIME file type of the attachment. For a list of supported file
	// types, see Feature specifications (https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html)
	// in the Amazon Connect Administrator Guide.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAttachmentUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAttachmentUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAttachmentUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAttachmentUploadInput"}
	if s.AttachmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentName"))
	}
	if s.AttachmentName != nil && len(*s.AttachmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttachmentName", 1))
	}
	if s.AttachmentSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentSizeInBytes"))
	}
	if s.AttachmentSizeInBytes != nil && *s.AttachmentSizeInBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AttachmentSizeInBytes", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentName sets the AttachmentName field's value.
func (s *StartAttachmentUploadInput) SetAttachmentName(v string) *StartAttachmentUploadInput {
	s.AttachmentName = &v
	return s
}

// SetAttachmentSizeInBytes sets the AttachmentSizeInBytes field's value.
func (s *StartAttachmentUploadInput) SetAttachmentSizeInBytes(v int64) *StartAttachmentUploadInput {
	s.AttachmentSizeInBytes = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartAttachmentUploadInput) SetClientToken(v string) *StartAttachmentUploadInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *StartAttachmentUploadInput) SetConnectionToken(v string) *StartAttachmentUploadInput {
	s.ConnectionToken = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *StartAttachmentUploadInput) SetContentType(v string) *StartAttachmentUploadInput {
	s.ContentType = &v
	return s
}

type StartAttachmentUploadOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the attachment.
	AttachmentId *string `min:"1" type:"string"`

	// Fields to be used while uploading the attachment.
	UploadMetadata *UploadMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAttachmentUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAttachmentUploadOutput) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *StartAttachmentUploadOutput) SetAttachmentId(v string) *StartAttachmentUploadOutput {
	s.AttachmentId = &v
	return s
}

// SetUploadMetadata sets the UploadMetadata field's value.
func (s *StartAttachmentUploadOutput) SetUploadMetadata(v *UploadMetadata) *StartAttachmentUploadOutput {
	s.UploadMetadata = v
	return s
}

// A filtering option for where to start. For example, if you sent 100 messages,
// start with message 50.
type StartPosition struct {
	_ struct{} `type:"structure"`

	// The time in ISO format where to start.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the message or event where to start.
	Id *string `min:"1" type:"string"`

	// The start position of the most recent message where you want to start.
	MostRecent *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPosition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPosition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPosition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPosition"}
	if s.AbsoluteTime != nil && len(*s.AbsoluteTime) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AbsoluteTime", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *StartPosition) SetAbsoluteTime(v string) *StartPosition {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartPosition) SetId(v string) *StartPosition {
	s.Id = &v
	return s
}

// SetMostRecent sets the MostRecent field's value.
func (s *StartPosition) SetMostRecent(v int64) *StartPosition {
	s.MostRecent = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Fields to be used while uploading the attachment.
type UploadMetadata struct {
	_ struct{} `type:"structure"`

	// The headers to be provided while uploading the file to the URL.
	HeadersToInclude map[string]*string `type:"map"`

	// This is the pre-signed URL that can be used for uploading the file to Amazon
	// S3 when used in response to StartAttachmentUpload (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html).
	Url *string `min:"1" type:"string"`

	// The expiration time of the URL in ISO timestamp. It's specified in ISO 8601
	// format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
	UrlExpiry *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadMetadata) GoString() string {
	return s.String()
}

// SetHeadersToInclude sets the HeadersToInclude field's value.
func (s *UploadMetadata) SetHeadersToInclude(v map[string]*string) *UploadMetadata {
	s.HeadersToInclude = v
	return s
}

// SetUrl sets the Url field's value.
func (s *UploadMetadata) SetUrl(v string) *UploadMetadata {
	s.Url = &v
	return s
}

// SetUrlExpiry sets the UrlExpiry field's value.
func (s *UploadMetadata) SetUrlExpiry(v string) *UploadMetadata {
	s.UrlExpiry = &v
	return s
}

// The input fails to satisfy the constraints specified by Amazon Connect.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A view resource object. Contains metadata and content necessary to render
// the view.
type View struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the view.
	Arn *string `type:"string"`

	// View content containing all content necessary to render a view except for
	// runtime input data.
	Content *ViewContent `type:"structure"`

	// The identifier of the view.
	Id *string `min:"1" type:"string"`

	// The name of the view.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by View's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The current version of the view.
	Version *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s View) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s View) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *View) SetArn(v string) *View {
	s.Arn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *View) SetContent(v *ViewContent) *View {
	s.Content = v
	return s
}

// SetId sets the Id field's value.
func (s *View) SetId(v string) *View {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *View) SetName(v string) *View {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *View) SetVersion(v int64) *View {
	s.Version = &v
	return s
}

// View content containing all content necessary to render a view except for
// runtime input data.
type ViewContent struct {
	_ struct{} `type:"structure"`

	// A list of actions possible from the view
	Actions []*string `type:"list"`

	// The schema representing the input data that the view template must be supplied
	// to render.
	//
	// InputSchema is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ViewContent's
	// String and GoString methods.
	InputSchema *string `type:"string" sensitive:"true"`

	// The view template representing the structure of the view.
	//
	// Template is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ViewContent's
	// String and GoString methods.
	Template *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewContent) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ViewContent) SetActions(v []*string) *ViewContent {
	s.Actions = v
	return s
}

// SetInputSchema sets the InputSchema field's value.
func (s *ViewContent) SetInputSchema(v string) *ViewContent {
	s.InputSchema = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *ViewContent) SetTemplate(v string) *ViewContent {
	s.Template = &v
	return s
}

// The websocket for the participant's connection.
type Websocket struct {
	_ struct{} `type:"structure"`

	// The URL expiration timestamp in ISO date format.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	ConnectionExpiry *string `type:"string"`

	// The URL of the websocket.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Websocket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Websocket) GoString() string {
	return s.String()
}

// SetConnectionExpiry sets the ConnectionExpiry field's value.
func (s *Websocket) SetConnectionExpiry(v string) *Websocket {
	s.ConnectionExpiry = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Websocket) SetUrl(v string) *Websocket {
	s.Url = &v
	return s
}

const (
	// ArtifactStatusApproved is a ArtifactStatus enum value
	ArtifactStatusApproved = "APPROVED"

	// ArtifactStatusRejected is a ArtifactStatus enum value
	ArtifactStatusRejected = "REJECTED"

	// ArtifactStatusInProgress is a ArtifactStatus enum value
	ArtifactStatusInProgress = "IN_PROGRESS"
)

// ArtifactStatus_Values returns all elements of the ArtifactStatus enum
func ArtifactStatus_Values() []string {
	return []string{
		ArtifactStatusApproved,
		ArtifactStatusRejected,
		ArtifactStatusInProgress,
	}
}

const (
	// ChatItemTypeTyping is a ChatItemType enum value
	ChatItemTypeTyping = "TYPING"

	// ChatItemTypeParticipantJoined is a ChatItemType enum value
	ChatItemTypeParticipantJoined = "PARTICIPANT_JOINED"

	// ChatItemTypeParticipantLeft is a ChatItemType enum value
	ChatItemTypeParticipantLeft = "PARTICIPANT_LEFT"

	// ChatItemTypeChatEnded is a ChatItemType enum value
	ChatItemTypeChatEnded = "CHAT_ENDED"

	// ChatItemTypeTransferSucceeded is a ChatItemType enum value
	ChatItemTypeTransferSucceeded = "TRANSFER_SUCCEEDED"

	// ChatItemTypeTransferFailed is a ChatItemType enum value
	ChatItemTypeTransferFailed = "TRANSFER_FAILED"

	// ChatItemTypeMessage is a ChatItemType enum value
	ChatItemTypeMessage = "MESSAGE"

	// ChatItemTypeEvent is a ChatItemType enum value
	ChatItemTypeEvent = "EVENT"

	// ChatItemTypeAttachment is a ChatItemType enum value
	ChatItemTypeAttachment = "ATTACHMENT"

	// ChatItemTypeConnectionAck is a ChatItemType enum value
	ChatItemTypeConnectionAck = "CONNECTION_ACK"

	// ChatItemTypeMessageDelivered is a ChatItemType enum value
	ChatItemTypeMessageDelivered = "MESSAGE_DELIVERED"

	// ChatItemTypeMessageRead is a ChatItemType enum value
	ChatItemTypeMessageRead = "MESSAGE_READ"
)

// ChatItemType_Values returns all elements of the ChatItemType enum
func ChatItemType_Values() []string {
	return []string{
		ChatItemTypeTyping,
		ChatItemTypeParticipantJoined,
		ChatItemTypeParticipantLeft,
		ChatItemTypeChatEnded,
		ChatItemTypeTransferSucceeded,
		ChatItemTypeTransferFailed,
		ChatItemTypeMessage,
		ChatItemTypeEvent,
		ChatItemTypeAttachment,
		ChatItemTypeConnectionAck,
		ChatItemTypeMessageDelivered,
		ChatItemTypeMessageRead,
	}
}

const (
	// ConnectionTypeWebsocket is a ConnectionType enum value
	ConnectionTypeWebsocket = "WEBSOCKET"

	// ConnectionTypeConnectionCredentials is a ConnectionType enum value
	ConnectionTypeConnectionCredentials = "CONNECTION_CREDENTIALS"
)

// ConnectionType_Values returns all elements of the ConnectionType enum
func ConnectionType_Values() []string {
	return []string{
		ConnectionTypeWebsocket,
		ConnectionTypeConnectionCredentials,
	}
}

const (
	// ParticipantRoleAgent is a ParticipantRole enum value
	ParticipantRoleAgent = "AGENT"

	// ParticipantRoleCustomer is a ParticipantRole enum value
	ParticipantRoleCustomer = "CUSTOMER"

	// ParticipantRoleSystem is a ParticipantRole enum value
	ParticipantRoleSystem = "SYSTEM"

	// ParticipantRoleCustomBot is a ParticipantRole enum value
	ParticipantRoleCustomBot = "CUSTOM_BOT"
)

// ParticipantRole_Values returns all elements of the ParticipantRole enum
func ParticipantRole_Values() []string {
	return []string{
		ParticipantRoleAgent,
		ParticipantRoleCustomer,
		ParticipantRoleSystem,
		ParticipantRoleCustomBot,
	}
}

const (
	// ResourceTypeContact is a ResourceType enum value
	ResourceTypeContact = "CONTACT"

	// ResourceTypeContactFlow is a ResourceType enum value
	ResourceTypeContactFlow = "CONTACT_FLOW"

	// ResourceTypeInstance is a ResourceType enum value
	ResourceTypeInstance = "INSTANCE"

	// ResourceTypeParticipant is a ResourceType enum value
	ResourceTypeParticipant = "PARTICIPANT"

	// ResourceTypeHierarchyLevel is a ResourceType enum value
	ResourceTypeHierarchyLevel = "HIERARCHY_LEVEL"

	// ResourceTypeHierarchyGroup is a ResourceType enum value
	ResourceTypeHierarchyGroup = "HIERARCHY_GROUP"

	// ResourceTypeUser is a ResourceType enum value
	ResourceTypeUser = "USER"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeContact,
		ResourceTypeContactFlow,
		ResourceTypeInstance,
		ResourceTypeParticipant,
		ResourceTypeHierarchyLevel,
		ResourceTypeHierarchyGroup,
		ResourceTypeUser,
	}
}

const (
	// ScanDirectionForward is a ScanDirection enum value
	ScanDirectionForward = "FORWARD"

	// ScanDirectionBackward is a ScanDirection enum value
	ScanDirectionBackward = "BACKWARD"
)

// ScanDirection_Values returns all elements of the ScanDirection enum
func ScanDirection_Values() []string {
	return []string{
		ScanDirectionForward,
		ScanDirectionBackward,
	}
}

const (
	// SortKeyDescending is a SortKey enum value
	SortKeyDescending = "DESCENDING"

	// SortKeyAscending is a SortKey enum value
	SortKeyAscending = "ASCENDING"
)

// SortKey_Values returns all elements of the SortKey enum
func SortKey_Values() []string {
	return []string{
		SortKeyDescending,
		SortKeyAscending,
	}
}
