// Package parameters provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version (devel) DO NOT EDIT.
package parameters

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ComplexObject defines model for ComplexObject.
type ComplexObject struct {
	Id      int    `json:"Id"`
	IsAdmin bool   `json:"IsAdmin"`
	Object  Object `json:"Object"`
}

// Object defines model for Object.
type Object struct {
	FirstName string `json:"firstName"`
	Role      string `json:"role"`
}

// GetCookieParams defines parameters for GetCookie.
type GetCookieParams struct {
	// primitive
	P *int32 `json:"p,omitempty"`

	// primitive
	Ep *int32 `json:"ep,omitempty"`

	// exploded array
	Ea *[]int32 `json:"ea,omitempty"`

	// array
	A *[]int32 `json:"a,omitempty"`

	// exploded object
	Eo *Object `json:"eo,omitempty"`

	// object
	O *Object `json:"o,omitempty"`

	// complex object
	Co *ComplexObject `json:"co,omitempty"`

	// name starting with number
	N1s *string `json:"1s,omitempty"`
}

// GetHeaderParams defines parameters for GetHeader.
type GetHeaderParams struct {
	// primitive
	XPrimitive *int32 `json:"X-Primitive,omitempty"`

	// primitive
	XPrimitiveExploded *int32 `json:"X-Primitive-Exploded,omitempty"`

	// exploded array
	XArrayExploded *[]int32 `json:"X-Array-Exploded,omitempty"`

	// array
	XArray *[]int32 `json:"X-Array,omitempty"`

	// exploded object
	XObjectExploded *Object `json:"X-Object-Exploded,omitempty"`

	// object
	XObject *Object `json:"X-Object,omitempty"`

	// complex object
	XComplexObject *ComplexObject `json:"X-Complex-Object,omitempty"`

	// name starting with number
	N1StartingWithNumber *string `json:"1-Starting-With-Number,omitempty"`
}

// GetDeepObjectParams defines parameters for GetDeepObject.
type GetDeepObjectParams struct {
	// deep object
	DeepObj ComplexObject `json:"deepObj"`
}

// GetQueryFormParams defines parameters for GetQueryForm.
type GetQueryFormParams struct {
	// exploded array
	Ea *[]int32 `json:"ea,omitempty"`

	// array
	A *[]int32 `json:"a,omitempty"`

	// exploded object
	Eo *Object `json:"eo,omitempty"`

	// object
	O *Object `json:"o,omitempty"`

	// exploded primitive
	Ep *int32 `json:"ep,omitempty"`

	// primitive
	P *int32 `json:"p,omitempty"`

	// primitive string
	Ps *string `json:"ps,omitempty"`

	// complex object
	Co *ComplexObject `json:"co,omitempty"`

	// name starting with number
	N1s *string `json:"1s,omitempty"`
}

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A list of callbacks for modifying requests which are generated before sending over
	// the network.
	RequestEditors []RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditors = append(c.RequestEditors, fn)
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// GetContentObject request
	GetContentObject(ctx context.Context, param ComplexObject, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetCookie request
	GetCookie(ctx context.Context, params *GetCookieParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetHeader request
	GetHeader(ctx context.Context, params *GetHeaderParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLabelExplodeArray request
	GetLabelExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLabelExplodeObject request
	GetLabelExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLabelNoExplodeArray request
	GetLabelNoExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLabelNoExplodeObject request
	GetLabelNoExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMatrixExplodeArray request
	GetMatrixExplodeArray(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMatrixExplodeObject request
	GetMatrixExplodeObject(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMatrixNoExplodeArray request
	GetMatrixNoExplodeArray(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMatrixNoExplodeObject request
	GetMatrixNoExplodeObject(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetPassThrough request
	GetPassThrough(ctx context.Context, param string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDeepObject request
	GetDeepObject(ctx context.Context, params *GetDeepObjectParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetQueryForm request
	GetQueryForm(ctx context.Context, params *GetQueryFormParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSimpleExplodeArray request
	GetSimpleExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSimpleExplodeObject request
	GetSimpleExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSimpleNoExplodeArray request
	GetSimpleNoExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSimpleNoExplodeObject request
	GetSimpleNoExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSimplePrimitive request
	GetSimplePrimitive(ctx context.Context, param int32, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetStartingWithNumber request
	GetStartingWithNumber(ctx context.Context, n1param string, reqEditors ...RequestEditorFn) (*http.Response, error)
}

func (c *Client) GetContentObject(ctx context.Context, param ComplexObject, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetContentObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetCookie(ctx context.Context, params *GetCookieParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetCookieRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetHeader(ctx context.Context, params *GetHeaderParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetHeaderRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLabelExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLabelExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLabelExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLabelExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLabelNoExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLabelNoExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLabelNoExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLabelNoExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMatrixExplodeArray(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMatrixExplodeArrayRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMatrixExplodeObject(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMatrixExplodeObjectRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMatrixNoExplodeArray(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMatrixNoExplodeArrayRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMatrixNoExplodeObject(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMatrixNoExplodeObjectRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetPassThrough(ctx context.Context, param string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetPassThroughRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDeepObject(ctx context.Context, params *GetDeepObjectParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDeepObjectRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetQueryForm(ctx context.Context, params *GetQueryFormParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetQueryFormRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSimpleExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSimpleExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSimpleExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSimpleExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSimpleNoExplodeArray(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSimpleNoExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSimpleNoExplodeObject(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSimpleNoExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSimplePrimitive(ctx context.Context, param int32, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSimplePrimitiveRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetStartingWithNumber(ctx context.Context, n1param string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetStartingWithNumberRequest(c.Server, n1param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

// NewGetContentObjectRequest generates requests for GetContentObject
func NewGetContentObjectRequest(server string, param ComplexObject) (*http.Request, error) {
	var err error

	var pathParam0 string

	var pathParamBuf0 []byte
	pathParamBuf0, err = json.Marshal(param)
	if err != nil {
		return nil, err
	}
	pathParam0 = string(pathParamBuf0)

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/contentObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetCookieRequest generates requests for GetCookie
func NewGetCookieRequest(server string, params *GetCookieParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/cookie")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.P != nil {
		var cookieParam0 string

		cookieParam0, err = runtime.StyleParamWithLocation("simple", false, "p", runtime.ParamLocationCookie, *params.P)
		if err != nil {
			return nil, err
		}

		cookie0 := &http.Cookie{
			Name:  "p",
			Value: cookieParam0,
		}
		req.AddCookie(cookie0)
	}

	if params.Ep != nil {
		var cookieParam1 string

		cookieParam1, err = runtime.StyleParamWithLocation("simple", true, "ep", runtime.ParamLocationCookie, *params.Ep)
		if err != nil {
			return nil, err
		}

		cookie1 := &http.Cookie{
			Name:  "ep",
			Value: cookieParam1,
		}
		req.AddCookie(cookie1)
	}

	if params.Ea != nil {
		var cookieParam2 string

		cookieParam2, err = runtime.StyleParamWithLocation("simple", true, "ea", runtime.ParamLocationCookie, *params.Ea)
		if err != nil {
			return nil, err
		}

		cookie2 := &http.Cookie{
			Name:  "ea",
			Value: cookieParam2,
		}
		req.AddCookie(cookie2)
	}

	if params.A != nil {
		var cookieParam3 string

		cookieParam3, err = runtime.StyleParamWithLocation("simple", false, "a", runtime.ParamLocationCookie, *params.A)
		if err != nil {
			return nil, err
		}

		cookie3 := &http.Cookie{
			Name:  "a",
			Value: cookieParam3,
		}
		req.AddCookie(cookie3)
	}

	if params.Eo != nil {
		var cookieParam4 string

		cookieParam4, err = runtime.StyleParamWithLocation("simple", true, "eo", runtime.ParamLocationCookie, *params.Eo)
		if err != nil {
			return nil, err
		}

		cookie4 := &http.Cookie{
			Name:  "eo",
			Value: cookieParam4,
		}
		req.AddCookie(cookie4)
	}

	if params.O != nil {
		var cookieParam5 string

		cookieParam5, err = runtime.StyleParamWithLocation("simple", false, "o", runtime.ParamLocationCookie, *params.O)
		if err != nil {
			return nil, err
		}

		cookie5 := &http.Cookie{
			Name:  "o",
			Value: cookieParam5,
		}
		req.AddCookie(cookie5)
	}

	if params.Co != nil {
		var cookieParam6 string

		var cookieParamBuf6 []byte
		cookieParamBuf6, err = json.Marshal(*params.Co)
		if err != nil {
			return nil, err
		}
		cookieParam6 = url.QueryEscape(string(cookieParamBuf6))

		cookie6 := &http.Cookie{
			Name:  "co",
			Value: cookieParam6,
		}
		req.AddCookie(cookie6)
	}

	if params.N1s != nil {
		var cookieParam7 string

		cookieParam7, err = runtime.StyleParamWithLocation("simple", true, "1s", runtime.ParamLocationCookie, *params.N1s)
		if err != nil {
			return nil, err
		}

		cookie7 := &http.Cookie{
			Name:  "1s",
			Value: cookieParam7,
		}
		req.AddCookie(cookie7)
	}

	return req, nil
}

// NewGetHeaderRequest generates requests for GetHeader
func NewGetHeaderRequest(server string, params *GetHeaderParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/header")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.XPrimitive != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "X-Primitive", runtime.ParamLocationHeader, *params.XPrimitive)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Primitive", headerParam0)
	}

	if params.XPrimitiveExploded != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParamWithLocation("simple", true, "X-Primitive-Exploded", runtime.ParamLocationHeader, *params.XPrimitiveExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Primitive-Exploded", headerParam1)
	}

	if params.XArrayExploded != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParamWithLocation("simple", true, "X-Array-Exploded", runtime.ParamLocationHeader, *params.XArrayExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Array-Exploded", headerParam2)
	}

	if params.XArray != nil {
		var headerParam3 string

		headerParam3, err = runtime.StyleParamWithLocation("simple", false, "X-Array", runtime.ParamLocationHeader, *params.XArray)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Array", headerParam3)
	}

	if params.XObjectExploded != nil {
		var headerParam4 string

		headerParam4, err = runtime.StyleParamWithLocation("simple", true, "X-Object-Exploded", runtime.ParamLocationHeader, *params.XObjectExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Object-Exploded", headerParam4)
	}

	if params.XObject != nil {
		var headerParam5 string

		headerParam5, err = runtime.StyleParamWithLocation("simple", false, "X-Object", runtime.ParamLocationHeader, *params.XObject)
		if err != nil {
			return nil, err
		}

		req.Header.Set("X-Object", headerParam5)
	}

	if params.XComplexObject != nil {
		var headerParam6 string

		var headerParamBuf6 []byte
		headerParamBuf6, err = json.Marshal(*params.XComplexObject)
		if err != nil {
			return nil, err
		}
		headerParam6 = string(headerParamBuf6)

		req.Header.Set("X-Complex-Object", headerParam6)
	}

	if params.N1StartingWithNumber != nil {
		var headerParam7 string

		headerParam7, err = runtime.StyleParamWithLocation("simple", false, "1-Starting-With-Number", runtime.ParamLocationHeader, *params.N1StartingWithNumber)
		if err != nil {
			return nil, err
		}

		req.Header.Set("1-Starting-With-Number", headerParam7)
	}

	return req, nil
}

// NewGetLabelExplodeArrayRequest generates requests for GetLabelExplodeArray
func NewGetLabelExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("label", true, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/labelExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelExplodeObjectRequest generates requests for GetLabelExplodeObject
func NewGetLabelExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("label", true, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/labelExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelNoExplodeArrayRequest generates requests for GetLabelNoExplodeArray
func NewGetLabelNoExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("label", false, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/labelNoExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelNoExplodeObjectRequest generates requests for GetLabelNoExplodeObject
func NewGetLabelNoExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("label", false, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/labelNoExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixExplodeArrayRequest generates requests for GetMatrixExplodeArray
func NewGetMatrixExplodeArrayRequest(server string, id []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("matrix", true, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/matrixExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixExplodeObjectRequest generates requests for GetMatrixExplodeObject
func NewGetMatrixExplodeObjectRequest(server string, id Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("matrix", true, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/matrixExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixNoExplodeArrayRequest generates requests for GetMatrixNoExplodeArray
func NewGetMatrixNoExplodeArrayRequest(server string, id []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("matrix", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/matrixNoExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixNoExplodeObjectRequest generates requests for GetMatrixNoExplodeObject
func NewGetMatrixNoExplodeObjectRequest(server string, id Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("matrix", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/matrixNoExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetPassThroughRequest generates requests for GetPassThrough
func NewGetPassThroughRequest(server string, param string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0 = param

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/passThrough/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDeepObjectRequest generates requests for GetDeepObject
func NewGetDeepObjectRequest(server string, params *GetDeepObjectParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/queryDeepObject")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParamWithLocation("deepObject", true, "deepObj", runtime.ParamLocationQuery, params.DeepObj); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetQueryFormRequest generates requests for GetQueryForm
func NewGetQueryFormRequest(server string, params *GetQueryFormParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/queryForm")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Ea != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "ea", runtime.ParamLocationQuery, *params.Ea); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.A != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", false, "a", runtime.ParamLocationQuery, *params.A); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Eo != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "eo", runtime.ParamLocationQuery, *params.Eo); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.O != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", false, "o", runtime.ParamLocationQuery, *params.O); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Ep != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "ep", runtime.ParamLocationQuery, *params.Ep); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.P != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", false, "p", runtime.ParamLocationQuery, *params.P); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Ps != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "ps", runtime.ParamLocationQuery, *params.Ps); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Co != nil {

		if queryParamBuf, err := json.Marshal(*params.Co); err != nil {
			return nil, err
		} else {
			queryValues.Add("co", string(queryParamBuf))
		}

	}

	if params.N1s != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "1s", runtime.ParamLocationQuery, *params.N1s); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleExplodeArrayRequest generates requests for GetSimpleExplodeArray
func NewGetSimpleExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", true, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/simpleExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleExplodeObjectRequest generates requests for GetSimpleExplodeObject
func NewGetSimpleExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", true, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/simpleExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleNoExplodeArrayRequest generates requests for GetSimpleNoExplodeArray
func NewGetSimpleNoExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/simpleNoExplodeArray/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleNoExplodeObjectRequest generates requests for GetSimpleNoExplodeObject
func NewGetSimpleNoExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/simpleNoExplodeObject/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimplePrimitiveRequest generates requests for GetSimplePrimitive
func NewGetSimplePrimitiveRequest(server string, param int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "param", runtime.ParamLocationPath, param)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/simplePrimitive/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetStartingWithNumberRequest generates requests for GetStartingWithNumber
func NewGetStartingWithNumberRequest(server string, n1param string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0 = n1param

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/startingWithNumber/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

func (c *Client) applyEditors(ctx context.Context, req *http.Request, additionalEditors []RequestEditorFn) error {
	for _, r := range c.RequestEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	for _, r := range additionalEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	return nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// GetContentObject request
	GetContentObjectWithResponse(ctx context.Context, param ComplexObject, reqEditors ...RequestEditorFn) (*GetContentObjectResponse, error)

	// GetCookie request
	GetCookieWithResponse(ctx context.Context, params *GetCookieParams, reqEditors ...RequestEditorFn) (*GetCookieResponse, error)

	// GetHeader request
	GetHeaderWithResponse(ctx context.Context, params *GetHeaderParams, reqEditors ...RequestEditorFn) (*GetHeaderResponse, error)

	// GetLabelExplodeArray request
	GetLabelExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetLabelExplodeArrayResponse, error)

	// GetLabelExplodeObject request
	GetLabelExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetLabelExplodeObjectResponse, error)

	// GetLabelNoExplodeArray request
	GetLabelNoExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetLabelNoExplodeArrayResponse, error)

	// GetLabelNoExplodeObject request
	GetLabelNoExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetLabelNoExplodeObjectResponse, error)

	// GetMatrixExplodeArray request
	GetMatrixExplodeArrayWithResponse(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*GetMatrixExplodeArrayResponse, error)

	// GetMatrixExplodeObject request
	GetMatrixExplodeObjectWithResponse(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*GetMatrixExplodeObjectResponse, error)

	// GetMatrixNoExplodeArray request
	GetMatrixNoExplodeArrayWithResponse(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*GetMatrixNoExplodeArrayResponse, error)

	// GetMatrixNoExplodeObject request
	GetMatrixNoExplodeObjectWithResponse(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*GetMatrixNoExplodeObjectResponse, error)

	// GetPassThrough request
	GetPassThroughWithResponse(ctx context.Context, param string, reqEditors ...RequestEditorFn) (*GetPassThroughResponse, error)

	// GetDeepObject request
	GetDeepObjectWithResponse(ctx context.Context, params *GetDeepObjectParams, reqEditors ...RequestEditorFn) (*GetDeepObjectResponse, error)

	// GetQueryForm request
	GetQueryFormWithResponse(ctx context.Context, params *GetQueryFormParams, reqEditors ...RequestEditorFn) (*GetQueryFormResponse, error)

	// GetSimpleExplodeArray request
	GetSimpleExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetSimpleExplodeArrayResponse, error)

	// GetSimpleExplodeObject request
	GetSimpleExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetSimpleExplodeObjectResponse, error)

	// GetSimpleNoExplodeArray request
	GetSimpleNoExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetSimpleNoExplodeArrayResponse, error)

	// GetSimpleNoExplodeObject request
	GetSimpleNoExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetSimpleNoExplodeObjectResponse, error)

	// GetSimplePrimitive request
	GetSimplePrimitiveWithResponse(ctx context.Context, param int32, reqEditors ...RequestEditorFn) (*GetSimplePrimitiveResponse, error)

	// GetStartingWithNumber request
	GetStartingWithNumberWithResponse(ctx context.Context, n1param string, reqEditors ...RequestEditorFn) (*GetStartingWithNumberResponse, error)
}

type GetContentObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetContentObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetContentObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetCookieResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetCookieResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetCookieResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetHeaderResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetHeaderResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetHeaderResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetLabelExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetLabelExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetLabelNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetLabelNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMatrixExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetMatrixExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMatrixExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMatrixExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetMatrixExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMatrixExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMatrixNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetMatrixNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMatrixNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMatrixNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetMatrixNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMatrixNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetPassThroughResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetPassThroughResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetPassThroughResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDeepObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetDeepObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDeepObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetQueryFormResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetQueryFormResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetQueryFormResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSimpleExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetSimpleExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSimpleExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSimpleExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetSimpleExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSimpleExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSimpleNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetSimpleNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSimpleNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSimpleNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetSimpleNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSimpleNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSimplePrimitiveResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetSimplePrimitiveResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSimplePrimitiveResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetStartingWithNumberResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetStartingWithNumberResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetStartingWithNumberResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// GetContentObjectWithResponse request returning *GetContentObjectResponse
func (c *ClientWithResponses) GetContentObjectWithResponse(ctx context.Context, param ComplexObject, reqEditors ...RequestEditorFn) (*GetContentObjectResponse, error) {
	rsp, err := c.GetContentObject(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetContentObjectResponse(rsp)
}

// GetCookieWithResponse request returning *GetCookieResponse
func (c *ClientWithResponses) GetCookieWithResponse(ctx context.Context, params *GetCookieParams, reqEditors ...RequestEditorFn) (*GetCookieResponse, error) {
	rsp, err := c.GetCookie(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetCookieResponse(rsp)
}

// GetHeaderWithResponse request returning *GetHeaderResponse
func (c *ClientWithResponses) GetHeaderWithResponse(ctx context.Context, params *GetHeaderParams, reqEditors ...RequestEditorFn) (*GetHeaderResponse, error) {
	rsp, err := c.GetHeader(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetHeaderResponse(rsp)
}

// GetLabelExplodeArrayWithResponse request returning *GetLabelExplodeArrayResponse
func (c *ClientWithResponses) GetLabelExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetLabelExplodeArrayResponse, error) {
	rsp, err := c.GetLabelExplodeArray(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelExplodeArrayResponse(rsp)
}

// GetLabelExplodeObjectWithResponse request returning *GetLabelExplodeObjectResponse
func (c *ClientWithResponses) GetLabelExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetLabelExplodeObjectResponse, error) {
	rsp, err := c.GetLabelExplodeObject(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelExplodeObjectResponse(rsp)
}

// GetLabelNoExplodeArrayWithResponse request returning *GetLabelNoExplodeArrayResponse
func (c *ClientWithResponses) GetLabelNoExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetLabelNoExplodeArrayResponse, error) {
	rsp, err := c.GetLabelNoExplodeArray(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelNoExplodeArrayResponse(rsp)
}

// GetLabelNoExplodeObjectWithResponse request returning *GetLabelNoExplodeObjectResponse
func (c *ClientWithResponses) GetLabelNoExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetLabelNoExplodeObjectResponse, error) {
	rsp, err := c.GetLabelNoExplodeObject(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelNoExplodeObjectResponse(rsp)
}

// GetMatrixExplodeArrayWithResponse request returning *GetMatrixExplodeArrayResponse
func (c *ClientWithResponses) GetMatrixExplodeArrayWithResponse(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*GetMatrixExplodeArrayResponse, error) {
	rsp, err := c.GetMatrixExplodeArray(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMatrixExplodeArrayResponse(rsp)
}

// GetMatrixExplodeObjectWithResponse request returning *GetMatrixExplodeObjectResponse
func (c *ClientWithResponses) GetMatrixExplodeObjectWithResponse(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*GetMatrixExplodeObjectResponse, error) {
	rsp, err := c.GetMatrixExplodeObject(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMatrixExplodeObjectResponse(rsp)
}

// GetMatrixNoExplodeArrayWithResponse request returning *GetMatrixNoExplodeArrayResponse
func (c *ClientWithResponses) GetMatrixNoExplodeArrayWithResponse(ctx context.Context, id []int32, reqEditors ...RequestEditorFn) (*GetMatrixNoExplodeArrayResponse, error) {
	rsp, err := c.GetMatrixNoExplodeArray(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMatrixNoExplodeArrayResponse(rsp)
}

// GetMatrixNoExplodeObjectWithResponse request returning *GetMatrixNoExplodeObjectResponse
func (c *ClientWithResponses) GetMatrixNoExplodeObjectWithResponse(ctx context.Context, id Object, reqEditors ...RequestEditorFn) (*GetMatrixNoExplodeObjectResponse, error) {
	rsp, err := c.GetMatrixNoExplodeObject(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMatrixNoExplodeObjectResponse(rsp)
}

// GetPassThroughWithResponse request returning *GetPassThroughResponse
func (c *ClientWithResponses) GetPassThroughWithResponse(ctx context.Context, param string, reqEditors ...RequestEditorFn) (*GetPassThroughResponse, error) {
	rsp, err := c.GetPassThrough(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetPassThroughResponse(rsp)
}

// GetDeepObjectWithResponse request returning *GetDeepObjectResponse
func (c *ClientWithResponses) GetDeepObjectWithResponse(ctx context.Context, params *GetDeepObjectParams, reqEditors ...RequestEditorFn) (*GetDeepObjectResponse, error) {
	rsp, err := c.GetDeepObject(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDeepObjectResponse(rsp)
}

// GetQueryFormWithResponse request returning *GetQueryFormResponse
func (c *ClientWithResponses) GetQueryFormWithResponse(ctx context.Context, params *GetQueryFormParams, reqEditors ...RequestEditorFn) (*GetQueryFormResponse, error) {
	rsp, err := c.GetQueryForm(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetQueryFormResponse(rsp)
}

// GetSimpleExplodeArrayWithResponse request returning *GetSimpleExplodeArrayResponse
func (c *ClientWithResponses) GetSimpleExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetSimpleExplodeArrayResponse, error) {
	rsp, err := c.GetSimpleExplodeArray(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSimpleExplodeArrayResponse(rsp)
}

// GetSimpleExplodeObjectWithResponse request returning *GetSimpleExplodeObjectResponse
func (c *ClientWithResponses) GetSimpleExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetSimpleExplodeObjectResponse, error) {
	rsp, err := c.GetSimpleExplodeObject(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSimpleExplodeObjectResponse(rsp)
}

// GetSimpleNoExplodeArrayWithResponse request returning *GetSimpleNoExplodeArrayResponse
func (c *ClientWithResponses) GetSimpleNoExplodeArrayWithResponse(ctx context.Context, param []int32, reqEditors ...RequestEditorFn) (*GetSimpleNoExplodeArrayResponse, error) {
	rsp, err := c.GetSimpleNoExplodeArray(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSimpleNoExplodeArrayResponse(rsp)
}

// GetSimpleNoExplodeObjectWithResponse request returning *GetSimpleNoExplodeObjectResponse
func (c *ClientWithResponses) GetSimpleNoExplodeObjectWithResponse(ctx context.Context, param Object, reqEditors ...RequestEditorFn) (*GetSimpleNoExplodeObjectResponse, error) {
	rsp, err := c.GetSimpleNoExplodeObject(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSimpleNoExplodeObjectResponse(rsp)
}

// GetSimplePrimitiveWithResponse request returning *GetSimplePrimitiveResponse
func (c *ClientWithResponses) GetSimplePrimitiveWithResponse(ctx context.Context, param int32, reqEditors ...RequestEditorFn) (*GetSimplePrimitiveResponse, error) {
	rsp, err := c.GetSimplePrimitive(ctx, param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSimplePrimitiveResponse(rsp)
}

// GetStartingWithNumberWithResponse request returning *GetStartingWithNumberResponse
func (c *ClientWithResponses) GetStartingWithNumberWithResponse(ctx context.Context, n1param string, reqEditors ...RequestEditorFn) (*GetStartingWithNumberResponse, error) {
	rsp, err := c.GetStartingWithNumber(ctx, n1param, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetStartingWithNumberResponse(rsp)
}

// ParseGetContentObjectResponse parses an HTTP response from a GetContentObjectWithResponse call
func ParseGetContentObjectResponse(rsp *http.Response) (*GetContentObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetContentObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetCookieResponse parses an HTTP response from a GetCookieWithResponse call
func ParseGetCookieResponse(rsp *http.Response) (*GetCookieResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetCookieResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetHeaderResponse parses an HTTP response from a GetHeaderWithResponse call
func ParseGetHeaderResponse(rsp *http.Response) (*GetHeaderResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetHeaderResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetLabelExplodeArrayResponse parses an HTTP response from a GetLabelExplodeArrayWithResponse call
func ParseGetLabelExplodeArrayResponse(rsp *http.Response) (*GetLabelExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLabelExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetLabelExplodeObjectResponse parses an HTTP response from a GetLabelExplodeObjectWithResponse call
func ParseGetLabelExplodeObjectResponse(rsp *http.Response) (*GetLabelExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLabelExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetLabelNoExplodeArrayResponse parses an HTTP response from a GetLabelNoExplodeArrayWithResponse call
func ParseGetLabelNoExplodeArrayResponse(rsp *http.Response) (*GetLabelNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLabelNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetLabelNoExplodeObjectResponse parses an HTTP response from a GetLabelNoExplodeObjectWithResponse call
func ParseGetLabelNoExplodeObjectResponse(rsp *http.Response) (*GetLabelNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLabelNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetMatrixExplodeArrayResponse parses an HTTP response from a GetMatrixExplodeArrayWithResponse call
func ParseGetMatrixExplodeArrayResponse(rsp *http.Response) (*GetMatrixExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMatrixExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetMatrixExplodeObjectResponse parses an HTTP response from a GetMatrixExplodeObjectWithResponse call
func ParseGetMatrixExplodeObjectResponse(rsp *http.Response) (*GetMatrixExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMatrixExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetMatrixNoExplodeArrayResponse parses an HTTP response from a GetMatrixNoExplodeArrayWithResponse call
func ParseGetMatrixNoExplodeArrayResponse(rsp *http.Response) (*GetMatrixNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMatrixNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetMatrixNoExplodeObjectResponse parses an HTTP response from a GetMatrixNoExplodeObjectWithResponse call
func ParseGetMatrixNoExplodeObjectResponse(rsp *http.Response) (*GetMatrixNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMatrixNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetPassThroughResponse parses an HTTP response from a GetPassThroughWithResponse call
func ParseGetPassThroughResponse(rsp *http.Response) (*GetPassThroughResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetPassThroughResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetDeepObjectResponse parses an HTTP response from a GetDeepObjectWithResponse call
func ParseGetDeepObjectResponse(rsp *http.Response) (*GetDeepObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDeepObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetQueryFormResponse parses an HTTP response from a GetQueryFormWithResponse call
func ParseGetQueryFormResponse(rsp *http.Response) (*GetQueryFormResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetQueryFormResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetSimpleExplodeArrayResponse parses an HTTP response from a GetSimpleExplodeArrayWithResponse call
func ParseGetSimpleExplodeArrayResponse(rsp *http.Response) (*GetSimpleExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSimpleExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetSimpleExplodeObjectResponse parses an HTTP response from a GetSimpleExplodeObjectWithResponse call
func ParseGetSimpleExplodeObjectResponse(rsp *http.Response) (*GetSimpleExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSimpleExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetSimpleNoExplodeArrayResponse parses an HTTP response from a GetSimpleNoExplodeArrayWithResponse call
func ParseGetSimpleNoExplodeArrayResponse(rsp *http.Response) (*GetSimpleNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSimpleNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetSimpleNoExplodeObjectResponse parses an HTTP response from a GetSimpleNoExplodeObjectWithResponse call
func ParseGetSimpleNoExplodeObjectResponse(rsp *http.Response) (*GetSimpleNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSimpleNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetSimplePrimitiveResponse parses an HTTP response from a GetSimplePrimitiveWithResponse call
func ParseGetSimplePrimitiveResponse(rsp *http.Response) (*GetSimplePrimitiveResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSimplePrimitiveResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetStartingWithNumberResponse parses an HTTP response from a GetStartingWithNumberWithResponse call
func ParseGetStartingWithNumberResponse(rsp *http.Response) (*GetStartingWithNumberResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetStartingWithNumberResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ServerInterface represents all server handlers.
type ServerInterface interface {

	// (GET /contentObject/{param})
	GetContentObject(ctx echo.Context, param ComplexObject) error

	// (GET /cookie)
	GetCookie(ctx echo.Context, params GetCookieParams) error

	// (GET /header)
	GetHeader(ctx echo.Context, params GetHeaderParams) error

	// (GET /labelExplodeArray/{.param*})
	GetLabelExplodeArray(ctx echo.Context, param []int32) error

	// (GET /labelExplodeObject/{.param*})
	GetLabelExplodeObject(ctx echo.Context, param Object) error

	// (GET /labelNoExplodeArray/{.param})
	GetLabelNoExplodeArray(ctx echo.Context, param []int32) error

	// (GET /labelNoExplodeObject/{.param})
	GetLabelNoExplodeObject(ctx echo.Context, param Object) error

	// (GET /matrixExplodeArray/{.id*})
	GetMatrixExplodeArray(ctx echo.Context, id []int32) error

	// (GET /matrixExplodeObject/{.id*})
	GetMatrixExplodeObject(ctx echo.Context, id Object) error

	// (GET /matrixNoExplodeArray/{.id})
	GetMatrixNoExplodeArray(ctx echo.Context, id []int32) error

	// (GET /matrixNoExplodeObject/{.id})
	GetMatrixNoExplodeObject(ctx echo.Context, id Object) error

	// (GET /passThrough/{param})
	GetPassThrough(ctx echo.Context, param string) error

	// (GET /queryDeepObject)
	GetDeepObject(ctx echo.Context, params GetDeepObjectParams) error

	// (GET /queryForm)
	GetQueryForm(ctx echo.Context, params GetQueryFormParams) error

	// (GET /simpleExplodeArray/{param*})
	GetSimpleExplodeArray(ctx echo.Context, param []int32) error

	// (GET /simpleExplodeObject/{param*})
	GetSimpleExplodeObject(ctx echo.Context, param Object) error

	// (GET /simpleNoExplodeArray/{param})
	GetSimpleNoExplodeArray(ctx echo.Context, param []int32) error

	// (GET /simpleNoExplodeObject/{param})
	GetSimpleNoExplodeObject(ctx echo.Context, param Object) error

	// (GET /simplePrimitive/{param})
	GetSimplePrimitive(ctx echo.Context, param int32) error

	// (GET /startingWithNumber/{1param})
	GetStartingWithNumber(ctx echo.Context, n1param string) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetContentObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetContentObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param ComplexObject

	err = json.Unmarshal([]byte(ctx.Param("param")), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'param' as JSON")
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetContentObject(ctx, param)
	return err
}

// GetCookie converts echo context to params.
func (w *ServerInterfaceWrapper) GetCookie(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetCookieParams

	if cookie, err := ctx.Cookie("p"); err == nil {

		var value int32
		err = runtime.BindStyledParameterWithLocation("simple", false, "p", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter p: %s", err))
		}
		params.P = &value

	}

	if cookie, err := ctx.Cookie("ep"); err == nil {

		var value int32
		err = runtime.BindStyledParameterWithLocation("simple", true, "ep", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ep: %s", err))
		}
		params.Ep = &value

	}

	if cookie, err := ctx.Cookie("ea"); err == nil {

		var value []int32
		err = runtime.BindStyledParameterWithLocation("simple", true, "ea", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ea: %s", err))
		}
		params.Ea = &value

	}

	if cookie, err := ctx.Cookie("a"); err == nil {

		var value []int32
		err = runtime.BindStyledParameterWithLocation("simple", false, "a", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter a: %s", err))
		}
		params.A = &value

	}

	if cookie, err := ctx.Cookie("eo"); err == nil {

		var value Object
		err = runtime.BindStyledParameterWithLocation("simple", true, "eo", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter eo: %s", err))
		}
		params.Eo = &value

	}

	if cookie, err := ctx.Cookie("o"); err == nil {

		var value Object
		err = runtime.BindStyledParameterWithLocation("simple", false, "o", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter o: %s", err))
		}
		params.O = &value

	}

	if cookie, err := ctx.Cookie("co"); err == nil {

		var value ComplexObject
		var decoded string
		decoded, err := url.QueryUnescape(cookie.Value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unescaping cookie parameter 'co'")
		}
		err = json.Unmarshal([]byte(decoded), &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'co' as JSON")
		}
		params.Co = &value

	}

	if cookie, err := ctx.Cookie("1s"); err == nil {

		var value string
		err = runtime.BindStyledParameterWithLocation("simple", true, "1s", runtime.ParamLocationCookie, cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter 1s: %s", err))
		}
		params.N1s = &value

	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCookie(ctx, params)
	return err
}

// GetHeader converts echo context to params.
func (w *ServerInterfaceWrapper) GetHeader(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetHeaderParams

	headers := ctx.Request().Header
	// ------------- Optional header parameter "X-Primitive" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Primitive")]; found {
		var XPrimitive int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Primitive, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", false, "X-Primitive", runtime.ParamLocationHeader, valueList[0], &XPrimitive)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Primitive: %s", err))
		}

		params.XPrimitive = &XPrimitive
	}
	// ------------- Optional header parameter "X-Primitive-Exploded" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Primitive-Exploded")]; found {
		var XPrimitiveExploded int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Primitive-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", true, "X-Primitive-Exploded", runtime.ParamLocationHeader, valueList[0], &XPrimitiveExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Primitive-Exploded: %s", err))
		}

		params.XPrimitiveExploded = &XPrimitiveExploded
	}
	// ------------- Optional header parameter "X-Array-Exploded" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Array-Exploded")]; found {
		var XArrayExploded []int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Array-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", true, "X-Array-Exploded", runtime.ParamLocationHeader, valueList[0], &XArrayExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Array-Exploded: %s", err))
		}

		params.XArrayExploded = &XArrayExploded
	}
	// ------------- Optional header parameter "X-Array" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Array")]; found {
		var XArray []int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Array, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", false, "X-Array", runtime.ParamLocationHeader, valueList[0], &XArray)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Array: %s", err))
		}

		params.XArray = &XArray
	}
	// ------------- Optional header parameter "X-Object-Exploded" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Object-Exploded")]; found {
		var XObjectExploded Object
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Object-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", true, "X-Object-Exploded", runtime.ParamLocationHeader, valueList[0], &XObjectExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Object-Exploded: %s", err))
		}

		params.XObjectExploded = &XObjectExploded
	}
	// ------------- Optional header parameter "X-Object" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Object")]; found {
		var XObject Object
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Object, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", false, "X-Object", runtime.ParamLocationHeader, valueList[0], &XObject)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Object: %s", err))
		}

		params.XObject = &XObject
	}
	// ------------- Optional header parameter "X-Complex-Object" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("X-Complex-Object")]; found {
		var XComplexObject ComplexObject
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Complex-Object, got %d", n))
		}

		err = json.Unmarshal([]byte(valueList[0]), &XComplexObject)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'X-Complex-Object' as JSON")
		}

		params.XComplexObject = &XComplexObject
	}
	// ------------- Optional header parameter "1-Starting-With-Number" -------------
	if valueList, found := headers[http.CanonicalHeaderKey("1-Starting-With-Number")]; found {
		var N1StartingWithNumber string
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for 1-Starting-With-Number, got %d", n))
		}

		err = runtime.BindStyledParameterWithLocation("simple", false, "1-Starting-With-Number", runtime.ParamLocationHeader, valueList[0], &N1StartingWithNumber)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter 1-Starting-With-Number: %s", err))
		}

		params.N1StartingWithNumber = &N1StartingWithNumber
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetHeader(ctx, params)
	return err
}

// GetLabelExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameterWithLocation("label", true, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelExplodeArray(ctx, param)
	return err
}

// GetLabelExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameterWithLocation("label", true, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelExplodeObject(ctx, param)
	return err
}

// GetLabelNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameterWithLocation("label", false, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelNoExplodeArray(ctx, param)
	return err
}

// GetLabelNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameterWithLocation("label", false, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelNoExplodeObject(ctx, param)
	return err
}

// GetMatrixExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id []int32

	err = runtime.BindStyledParameterWithLocation("matrix", true, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixExplodeArray(ctx, id)
	return err
}

// GetMatrixExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id Object

	err = runtime.BindStyledParameterWithLocation("matrix", true, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixExplodeObject(ctx, id)
	return err
}

// GetMatrixNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id []int32

	err = runtime.BindStyledParameterWithLocation("matrix", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixNoExplodeArray(ctx, id)
	return err
}

// GetMatrixNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id Object

	err = runtime.BindStyledParameterWithLocation("matrix", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixNoExplodeObject(ctx, id)
	return err
}

// GetPassThrough converts echo context to params.
func (w *ServerInterfaceWrapper) GetPassThrough(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param string

	param = ctx.Param("param")

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetPassThrough(ctx, param)
	return err
}

// GetDeepObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetDeepObject(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetDeepObjectParams
	// ------------- Required query parameter "deepObj" -------------

	err = runtime.BindQueryParameter("deepObject", true, true, "deepObj", ctx.QueryParams(), &params.DeepObj)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter deepObj: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetDeepObject(ctx, params)
	return err
}

// GetQueryForm converts echo context to params.
func (w *ServerInterfaceWrapper) GetQueryForm(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetQueryFormParams
	// ------------- Optional query parameter "ea" -------------

	err = runtime.BindQueryParameter("form", true, false, "ea", ctx.QueryParams(), &params.Ea)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ea: %s", err))
	}

	// ------------- Optional query parameter "a" -------------

	err = runtime.BindQueryParameter("form", false, false, "a", ctx.QueryParams(), &params.A)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter a: %s", err))
	}

	// ------------- Optional query parameter "eo" -------------

	err = runtime.BindQueryParameter("form", true, false, "eo", ctx.QueryParams(), &params.Eo)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter eo: %s", err))
	}

	// ------------- Optional query parameter "o" -------------

	err = runtime.BindQueryParameter("form", false, false, "o", ctx.QueryParams(), &params.O)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter o: %s", err))
	}

	// ------------- Optional query parameter "ep" -------------

	err = runtime.BindQueryParameter("form", true, false, "ep", ctx.QueryParams(), &params.Ep)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ep: %s", err))
	}

	// ------------- Optional query parameter "p" -------------

	err = runtime.BindQueryParameter("form", false, false, "p", ctx.QueryParams(), &params.P)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter p: %s", err))
	}

	// ------------- Optional query parameter "ps" -------------

	err = runtime.BindQueryParameter("form", true, false, "ps", ctx.QueryParams(), &params.Ps)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ps: %s", err))
	}

	// ------------- Optional query parameter "co" -------------

	if paramValue := ctx.QueryParam("co"); paramValue != "" {

		var value ComplexObject
		err = json.Unmarshal([]byte(paramValue), &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'co' as JSON")
		}
		params.Co = &value

	}

	// ------------- Optional query parameter "1s" -------------

	err = runtime.BindQueryParameter("form", true, false, "1s", ctx.QueryParams(), &params.N1s)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter 1s: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetQueryForm(ctx, params)
	return err
}

// GetSimpleExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameterWithLocation("simple", true, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleExplodeArray(ctx, param)
	return err
}

// GetSimpleExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameterWithLocation("simple", true, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleExplodeObject(ctx, param)
	return err
}

// GetSimpleNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameterWithLocation("simple", false, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleNoExplodeArray(ctx, param)
	return err
}

// GetSimpleNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameterWithLocation("simple", false, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleNoExplodeObject(ctx, param)
	return err
}

// GetSimplePrimitive converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimplePrimitive(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param int32

	err = runtime.BindStyledParameterWithLocation("simple", false, "param", runtime.ParamLocationPath, ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimplePrimitive(ctx, param)
	return err
}

// GetStartingWithNumber converts echo context to params.
func (w *ServerInterfaceWrapper) GetStartingWithNumber(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "1param" -------------
	var n1param string

	n1param = ctx.Param("1param")

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetStartingWithNumber(ctx, n1param)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/contentObject/:param", wrapper.GetContentObject)
	router.GET(baseURL+"/cookie", wrapper.GetCookie)
	router.GET(baseURL+"/header", wrapper.GetHeader)
	router.GET(baseURL+"/labelExplodeArray/:param", wrapper.GetLabelExplodeArray)
	router.GET(baseURL+"/labelExplodeObject/:param", wrapper.GetLabelExplodeObject)
	router.GET(baseURL+"/labelNoExplodeArray/:param", wrapper.GetLabelNoExplodeArray)
	router.GET(baseURL+"/labelNoExplodeObject/:param", wrapper.GetLabelNoExplodeObject)
	router.GET(baseURL+"/matrixExplodeArray/:id", wrapper.GetMatrixExplodeArray)
	router.GET(baseURL+"/matrixExplodeObject/:id", wrapper.GetMatrixExplodeObject)
	router.GET(baseURL+"/matrixNoExplodeArray/:id", wrapper.GetMatrixNoExplodeArray)
	router.GET(baseURL+"/matrixNoExplodeObject/:id", wrapper.GetMatrixNoExplodeObject)
	router.GET(baseURL+"/passThrough/:param", wrapper.GetPassThrough)
	router.GET(baseURL+"/queryDeepObject", wrapper.GetDeepObject)
	router.GET(baseURL+"/queryForm", wrapper.GetQueryForm)
	router.GET(baseURL+"/simpleExplodeArray/:param", wrapper.GetSimpleExplodeArray)
	router.GET(baseURL+"/simpleExplodeObject/:param", wrapper.GetSimpleExplodeObject)
	router.GET(baseURL+"/simpleNoExplodeArray/:param", wrapper.GetSimpleNoExplodeArray)
	router.GET(baseURL+"/simpleNoExplodeObject/:param", wrapper.GetSimpleNoExplodeObject)
	router.GET(baseURL+"/simplePrimitive/:param", wrapper.GetSimplePrimitive)
	router.GET(baseURL+"/startingWithNumber/:1param", wrapper.GetStartingWithNumber)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/9xa34+bOBD+V9DcPZ1ISNo33qrer5Wu295lpZ5U7YMXJsE9wK7t7O0q4n8/2UAAQwgk",
	"YTe9ty7MzDfzefzVHrKDgCWcpZgqCf4OBErOUonmjxVNeIx/FY/0k4ClClOl/6nwSXk8JjTVf8kgwoSY",
	"588cwQepBE03kGWZCyHKQFCuKEvBh3eONHGdEsthD18xUKBN8zgG/T3TVk8f85f+DrhgHIWieXI3YQ2N",
	"pgo3KCBz4Ua+C5M8qeLlA2MxklS/rIL9KHANPvzgVfV7Bbj3scpH4LctFRiC/6V0djV0hXPfCNvMcU2F",
	"VLckwQ5iXBAs7nphoRortxbq3nBK0zXTzjENsFic1ADBh5s7HV1RpcPDHUrlrFA8ogAXHlHIfBmW88V8",
	"oQ0Zx5RwCj68nS/mS3CBExWZ/L1ivfP6vB0ngiSZfrNBU64uluh11asBv6F6X3cwoQRJUKGQ4H9p9A/h",
	"PKaBcfa+SmZ1Ud/yNBujYAN8kza4JQ0GGepcKrHF7N5t9vibxeIQ3t7OszZCZjC9gLF/KPazYSxaNDQ3",
	"BBc0oYo+akN84jELEfw1iSUWhQVlmLI0cGtUrZlIiMo3wds34Lb2ROYOQtT0HADEsxELlNAhQpDnobCk",
	"AUsVJnIQ/v5JjtaRTyuNPr6nS2NPCys3zCBeWCOhYVJmQ7cR+yg4DXGq7d6sJMgNKg47KwgYtEnQ7xyp",
	"iFA03Tj/UhU56TZ5MFLZGWUpG0TY0t1Ul3Qbx0YpIiQhij6l+D23OFcpojJMke7fs081l0k1owd69kvR",
	"5i+iIu1E3mnr7iReTFMOZPXKytLOKt9m3WRNITSHMvju9KZdSBGoLOgE9bFjLmerwnr2mapodltaj1ak",
	"mDxgXCyyaURvNzfS81Pv8e4P262tWF1tNuRkdpmN4IJUz+bcayqES5736pyVJ+KxpB06GF+CtSG7ZHJ+",
	"bllXVx3np+nXQ1BdPP5HfbWvv9lZI4g72lrnMPfavZUQJeiT1Vo07N94H1pOp2w8Gk7eU3l10xG276lR",
	"jJ2uVUcoG9dMk5HTkioaDiDnAkL1PXdUW6fGsXaGSl17V3Ei5V0k2HYTDRmVfarMewdlIwatrzIG+7ZF",
	"8fwzIq+moIdKrlkduemGiLz/6mJgqzrDPPTJHWKd+qtGCaucDx2mTSq/MpH01f7n3uhI6YMuuVb1F5uU",
	"VXVrVxh5ybWyerGkhl12bc6mn6JZiJcA3Jd6bB5jVzvN0Lin2ssBOoXGHcDpH8m98ljASva0KaQVZNQQ",
	"8ixtz7/UNY9JA268q5bb9c4J8hJhMtYa385G0HY9k4LJGLIP4MfPTKsOvyueFUzP3PAvs6sux6uYFkzG",
	"0v4DxHB+6p9LLGZOYmJA80xJQ/F/ymeqonxW7O2WA6houU14QVlOfEPRDJtfP+R5b0UMPkRKcd/zip8+",
	"KJRqrs/5CeFzQiG7z/4LAAD//734if8YIwAA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
