// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListRolesReader is a Reader for the ListRoles structure.
type ListRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewListRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/roles] listRoles", response, response.Code())
	}
}

// NewListRolesOK creates a ListRolesOK with default headers values
func NewListRolesOK() *ListRolesOK {
	return &ListRolesOK{}
}

/*
ListRolesOK describes a response with status code 200, with default header values.

(empty)
*/
type ListRolesOK struct {
	Payload []*models.RoleDTO
}

// IsSuccess returns true when this list roles Ok response has a 2xx status code
func (o *ListRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list roles Ok response has a 3xx status code
func (o *ListRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list roles Ok response has a 4xx status code
func (o *ListRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list roles Ok response has a 5xx status code
func (o *ListRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list roles Ok response a status code equal to that given
func (o *ListRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list roles Ok response
func (o *ListRolesOK) Code() int {
	return 200
}

func (o *ListRolesOK) Error() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesOk  %+v", 200, o.Payload)
}

func (o *ListRolesOK) String() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesOk  %+v", 200, o.Payload)
}

func (o *ListRolesOK) GetPayload() []*models.RoleDTO {
	return o.Payload
}

func (o *ListRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListRolesForbidden creates a ListRolesForbidden with default headers values
func NewListRolesForbidden() *ListRolesForbidden {
	return &ListRolesForbidden{}
}

/*
ListRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list roles forbidden response has a 2xx status code
func (o *ListRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list roles forbidden response has a 3xx status code
func (o *ListRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list roles forbidden response has a 4xx status code
func (o *ListRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list roles forbidden response has a 5xx status code
func (o *ListRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list roles forbidden response a status code equal to that given
func (o *ListRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list roles forbidden response
func (o *ListRolesForbidden) Code() int {
	return 403
}

func (o *ListRolesForbidden) Error() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesForbidden  %+v", 403, o.Payload)
}

func (o *ListRolesForbidden) String() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesForbidden  %+v", 403, o.Payload)
}

func (o *ListRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListRolesInternalServerError creates a ListRolesInternalServerError with default headers values
func NewListRolesInternalServerError() *ListRolesInternalServerError {
	return &ListRolesInternalServerError{}
}

/*
ListRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list roles internal server error response has a 2xx status code
func (o *ListRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list roles internal server error response has a 3xx status code
func (o *ListRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list roles internal server error response has a 4xx status code
func (o *ListRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list roles internal server error response has a 5xx status code
func (o *ListRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list roles internal server error response a status code equal to that given
func (o *ListRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list roles internal server error response
func (o *ListRolesInternalServerError) Code() int {
	return 500
}

func (o *ListRolesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesInternalServerError  %+v", 500, o.Payload)
}

func (o *ListRolesInternalServerError) String() string {
	return fmt.Sprintf("[GET /access-control/roles][%d] listRolesInternalServerError  %+v", 500, o.Payload)
}

func (o *ListRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
