// Code generated by go-swagger; DO NOT EDIT.

package legacy_alerts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// TestAlertReader is a Reader for the TestAlert structure.
type TestAlertReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TestAlertReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTestAlertOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewTestAlertBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTestAlertForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewTestAlertUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTestAlertInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /alerts/test] testAlert", response, response.Code())
	}
}

// NewTestAlertOK creates a TestAlertOK with default headers values
func NewTestAlertOK() *TestAlertOK {
	return &TestAlertOK{}
}

/*
TestAlertOK describes a response with status code 200, with default header values.

(empty)
*/
type TestAlertOK struct {
	Payload *models.AlertTestResult
}

// IsSuccess returns true when this test alert Ok response has a 2xx status code
func (o *TestAlertOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this test alert Ok response has a 3xx status code
func (o *TestAlertOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this test alert Ok response has a 4xx status code
func (o *TestAlertOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this test alert Ok response has a 5xx status code
func (o *TestAlertOK) IsServerError() bool {
	return false
}

// IsCode returns true when this test alert Ok response a status code equal to that given
func (o *TestAlertOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the test alert Ok response
func (o *TestAlertOK) Code() int {
	return 200
}

func (o *TestAlertOK) Error() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertOk  %+v", 200, o.Payload)
}

func (o *TestAlertOK) String() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertOk  %+v", 200, o.Payload)
}

func (o *TestAlertOK) GetPayload() *models.AlertTestResult {
	return o.Payload
}

func (o *TestAlertOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AlertTestResult)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTestAlertBadRequest creates a TestAlertBadRequest with default headers values
func NewTestAlertBadRequest() *TestAlertBadRequest {
	return &TestAlertBadRequest{}
}

/*
TestAlertBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type TestAlertBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this test alert bad request response has a 2xx status code
func (o *TestAlertBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this test alert bad request response has a 3xx status code
func (o *TestAlertBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this test alert bad request response has a 4xx status code
func (o *TestAlertBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this test alert bad request response has a 5xx status code
func (o *TestAlertBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this test alert bad request response a status code equal to that given
func (o *TestAlertBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the test alert bad request response
func (o *TestAlertBadRequest) Code() int {
	return 400
}

func (o *TestAlertBadRequest) Error() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertBadRequest  %+v", 400, o.Payload)
}

func (o *TestAlertBadRequest) String() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertBadRequest  %+v", 400, o.Payload)
}

func (o *TestAlertBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TestAlertBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTestAlertForbidden creates a TestAlertForbidden with default headers values
func NewTestAlertForbidden() *TestAlertForbidden {
	return &TestAlertForbidden{}
}

/*
TestAlertForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type TestAlertForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this test alert forbidden response has a 2xx status code
func (o *TestAlertForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this test alert forbidden response has a 3xx status code
func (o *TestAlertForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this test alert forbidden response has a 4xx status code
func (o *TestAlertForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this test alert forbidden response has a 5xx status code
func (o *TestAlertForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this test alert forbidden response a status code equal to that given
func (o *TestAlertForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the test alert forbidden response
func (o *TestAlertForbidden) Code() int {
	return 403
}

func (o *TestAlertForbidden) Error() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertForbidden  %+v", 403, o.Payload)
}

func (o *TestAlertForbidden) String() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertForbidden  %+v", 403, o.Payload)
}

func (o *TestAlertForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TestAlertForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTestAlertUnprocessableEntity creates a TestAlertUnprocessableEntity with default headers values
func NewTestAlertUnprocessableEntity() *TestAlertUnprocessableEntity {
	return &TestAlertUnprocessableEntity{}
}

/*
TestAlertUnprocessableEntity describes a response with status code 422, with default header values.

UnprocessableEntityError
*/
type TestAlertUnprocessableEntity struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this test alert unprocessable entity response has a 2xx status code
func (o *TestAlertUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this test alert unprocessable entity response has a 3xx status code
func (o *TestAlertUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this test alert unprocessable entity response has a 4xx status code
func (o *TestAlertUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this test alert unprocessable entity response has a 5xx status code
func (o *TestAlertUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this test alert unprocessable entity response a status code equal to that given
func (o *TestAlertUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the test alert unprocessable entity response
func (o *TestAlertUnprocessableEntity) Code() int {
	return 422
}

func (o *TestAlertUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TestAlertUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TestAlertUnprocessableEntity) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TestAlertUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTestAlertInternalServerError creates a TestAlertInternalServerError with default headers values
func NewTestAlertInternalServerError() *TestAlertInternalServerError {
	return &TestAlertInternalServerError{}
}

/*
TestAlertInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type TestAlertInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this test alert internal server error response has a 2xx status code
func (o *TestAlertInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this test alert internal server error response has a 3xx status code
func (o *TestAlertInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this test alert internal server error response has a 4xx status code
func (o *TestAlertInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this test alert internal server error response has a 5xx status code
func (o *TestAlertInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this test alert internal server error response a status code equal to that given
func (o *TestAlertInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the test alert internal server error response
func (o *TestAlertInternalServerError) Code() int {
	return 500
}

func (o *TestAlertInternalServerError) Error() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertInternalServerError  %+v", 500, o.Payload)
}

func (o *TestAlertInternalServerError) String() string {
	return fmt.Sprintf("[POST /alerts/test][%d] testAlertInternalServerError  %+v", 500, o.Payload)
}

func (o *TestAlertInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TestAlertInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
