// Code generated by go-swagger; DO NOT EDIT.

package service_accounts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new service accounts API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for service accounts API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateServiceAccount(params *CreateServiceAccountParams, opts ...ClientOption) (*CreateServiceAccountCreated, error)

	CreateToken(params *CreateTokenParams, opts ...ClientOption) (*CreateTokenOK, error)

	DeleteServiceAccount(serviceAccountID int64, opts ...ClientOption) (*DeleteServiceAccountOK, error)
	DeleteServiceAccountWithParams(params *DeleteServiceAccountParams, opts ...ClientOption) (*DeleteServiceAccountOK, error)

	DeleteToken(tokenID int64, serviceAccountID int64, opts ...ClientOption) (*DeleteTokenOK, error)
	DeleteTokenWithParams(params *DeleteTokenParams, opts ...ClientOption) (*DeleteTokenOK, error)

	ListTokens(serviceAccountID int64, opts ...ClientOption) (*ListTokensOK, error)
	ListTokensWithParams(params *ListTokensParams, opts ...ClientOption) (*ListTokensOK, error)

	RetrieveServiceAccount(serviceAccountID int64, opts ...ClientOption) (*RetrieveServiceAccountOK, error)
	RetrieveServiceAccountWithParams(params *RetrieveServiceAccountParams, opts ...ClientOption) (*RetrieveServiceAccountOK, error)

	SearchOrgServiceAccountsWithPaging(params *SearchOrgServiceAccountsWithPagingParams, opts ...ClientOption) (*SearchOrgServiceAccountsWithPagingOK, error)

	UpdateServiceAccount(params *UpdateServiceAccountParams, opts ...ClientOption) (*UpdateServiceAccountOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateServiceAccount creates service account

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:write` scope: `serviceaccounts:*`

Requires basic authentication and that the authenticated user is a Grafana Admin.
*/

func (a *Client) CreateServiceAccount(params *CreateServiceAccountParams, opts ...ClientOption) (*CreateServiceAccountCreated, error) {
	if params == nil {
		params = NewCreateServiceAccountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createServiceAccount",
		Method:             "POST",
		PathPattern:        "/serviceaccounts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateServiceAccountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateServiceAccountCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createServiceAccount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateToken creates new token adds a token to a service account

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:write` scope: `serviceaccounts:id:1` (single service account)
*/

func (a *Client) CreateToken(params *CreateTokenParams, opts ...ClientOption) (*CreateTokenOK, error) {
	if params == nil {
		params = NewCreateTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createToken",
		Method:             "POST",
		PathPattern:        "/serviceaccounts/{serviceAccountId}/tokens",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteServiceAccount deletes service account

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:delete` scope: `serviceaccounts:id:1` (single service account)
*/
func (a *Client) DeleteServiceAccount(serviceAccountID int64, opts ...ClientOption) (*DeleteServiceAccountOK, error) {
	params := NewDeleteServiceAccountParams().WithServiceAccountID(serviceAccountID)
	return a.DeleteServiceAccountWithParams(params, opts...)
}

func (a *Client) DeleteServiceAccountWithParams(params *DeleteServiceAccountParams, opts ...ClientOption) (*DeleteServiceAccountOK, error) {
	if params == nil {
		params = NewDeleteServiceAccountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteServiceAccount",
		Method:             "DELETE",
		PathPattern:        "/serviceaccounts/{serviceAccountId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteServiceAccountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteServiceAccountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteServiceAccount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteToken deletes token deletes service account tokens

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:write` scope: `serviceaccounts:id:1` (single service account)

Requires basic authentication and that the authenticated user is a Grafana Admin.
*/
func (a *Client) DeleteToken(tokenID int64, serviceAccountID int64, opts ...ClientOption) (*DeleteTokenOK, error) {
	params := NewDeleteTokenParams().WithServiceAccountID(serviceAccountID).WithTokenID(tokenID)
	return a.DeleteTokenWithParams(params, opts...)
}

func (a *Client) DeleteTokenWithParams(params *DeleteTokenParams, opts ...ClientOption) (*DeleteTokenOK, error) {
	if params == nil {
		params = NewDeleteTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteToken",
		Method:             "DELETE",
		PathPattern:        "/serviceaccounts/{serviceAccountId}/tokens/{tokenId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListTokens gets service account tokens

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:read` scope: `global:serviceaccounts:id:1` (single service account)

Requires basic authentication and that the authenticated user is a Grafana Admin.
*/
func (a *Client) ListTokens(serviceAccountID int64, opts ...ClientOption) (*ListTokensOK, error) {
	params := NewListTokensParams().WithServiceAccountID(serviceAccountID)
	return a.ListTokensWithParams(params, opts...)
}

func (a *Client) ListTokensWithParams(params *ListTokensParams, opts ...ClientOption) (*ListTokensOK, error) {
	if params == nil {
		params = NewListTokensParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listTokens",
		Method:             "GET",
		PathPattern:        "/serviceaccounts/{serviceAccountId}/tokens",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListTokensReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListTokensOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listTokens: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RetrieveServiceAccount gets single serviceaccount by Id

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:read` scope: `serviceaccounts:id:1` (single service account)
*/
func (a *Client) RetrieveServiceAccount(serviceAccountID int64, opts ...ClientOption) (*RetrieveServiceAccountOK, error) {
	params := NewRetrieveServiceAccountParams().WithServiceAccountID(serviceAccountID)
	return a.RetrieveServiceAccountWithParams(params, opts...)
}

func (a *Client) RetrieveServiceAccountWithParams(params *RetrieveServiceAccountParams, opts ...ClientOption) (*RetrieveServiceAccountOK, error) {
	if params == nil {
		params = NewRetrieveServiceAccountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "retrieveServiceAccount",
		Method:             "GET",
		PathPattern:        "/serviceaccounts/{serviceAccountId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RetrieveServiceAccountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RetrieveServiceAccountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for retrieveServiceAccount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SearchOrgServiceAccountsWithPaging searches service accounts with paging

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:read` scope: `serviceaccounts:*`
*/

func (a *Client) SearchOrgServiceAccountsWithPaging(params *SearchOrgServiceAccountsWithPagingParams, opts ...ClientOption) (*SearchOrgServiceAccountsWithPagingOK, error) {
	if params == nil {
		params = NewSearchOrgServiceAccountsWithPagingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "searchOrgServiceAccountsWithPaging",
		Method:             "GET",
		PathPattern:        "/serviceaccounts/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchOrgServiceAccountsWithPagingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchOrgServiceAccountsWithPagingOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for searchOrgServiceAccountsWithPaging: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateServiceAccount updates service account

Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
action: `serviceaccounts:write` scope: `serviceaccounts:id:1` (single service account)
*/

func (a *Client) UpdateServiceAccount(params *UpdateServiceAccountParams, opts ...ClientOption) (*UpdateServiceAccountOK, error) {
	if params == nil {
		params = NewUpdateServiceAccountParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateServiceAccount",
		Method:             "PATCH",
		PathPattern:        "/serviceaccounts/{serviceAccountId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateServiceAccountReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateServiceAccountOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateServiceAccount: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
