// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PushoverConfig pushover config
//
// swagger:model PushoverConfig
type PushoverConfig struct {

	// device
	Device string `json:"device,omitempty"`

	// expire
	Expire string `json:"expire,omitempty"`

	// html
	HTML bool `json:"html,omitempty"`

	// http config
	HTTPConfig *HTTPClientConfig `json:"http_config,omitempty"`

	// message
	Message string `json:"message,omitempty"`

	// priority
	Priority string `json:"priority,omitempty"`

	// retry
	Retry string `json:"retry,omitempty"`

	// send resolved
	SendResolved bool `json:"send_resolved,omitempty"`

	// sound
	Sound string `json:"sound,omitempty"`

	// title
	Title string `json:"title,omitempty"`

	// token
	Token Secret `json:"token,omitempty"`

	// token file
	TokenFile string `json:"token_file,omitempty"`

	// url
	URL string `json:"url,omitempty"`

	// url title
	URLTitle string `json:"url_title,omitempty"`

	// user key
	UserKey Secret `json:"user_key,omitempty"`

	// user key file
	UserKeyFile string `json:"user_key_file,omitempty"`
}

// Validate validates this pushover config
func (m *PushoverConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHTTPConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PushoverConfig) validateHTTPConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConfig) { // not required
		return nil
	}

	if m.HTTPConfig != nil {
		if err := m.HTTPConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

func (m *PushoverConfig) validateToken(formats strfmt.Registry) error {
	if swag.IsZero(m.Token) { // not required
		return nil
	}

	if err := m.Token.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("token")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("token")
		}
		return err
	}

	return nil
}

func (m *PushoverConfig) validateUserKey(formats strfmt.Registry) error {
	if swag.IsZero(m.UserKey) { // not required
		return nil
	}

	if err := m.UserKey.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("user_key")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("user_key")
		}
		return err
	}

	return nil
}

// ContextValidate validate this pushover config based on the context it is used
func (m *PushoverConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHTTPConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateToken(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PushoverConfig) contextValidateHTTPConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTPConfig != nil {

		if swag.IsZero(m.HTTPConfig) { // not required
			return nil
		}

		if err := m.HTTPConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

func (m *PushoverConfig) contextValidateToken(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Token) { // not required
		return nil
	}

	if err := m.Token.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("token")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("token")
		}
		return err
	}

	return nil
}

func (m *PushoverConfig) contextValidateUserKey(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.UserKey) { // not required
		return nil
	}

	if err := m.UserKey.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("user_key")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("user_key")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PushoverConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PushoverConfig) UnmarshalBinary(b []byte) error {
	var res PushoverConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
