// Code generated by go-swagger; DO NOT EDIT.

package provider_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDownloadProviderParams creates a new DownloadProviderParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDownloadProviderParams() *DownloadProviderParams {
	return &DownloadProviderParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadProviderParamsWithTimeout creates a new DownloadProviderParams object
// with the ability to set a timeout on a request.
func NewDownloadProviderParamsWithTimeout(timeout time.Duration) *DownloadProviderParams {
	return &DownloadProviderParams{
		timeout: timeout,
	}
}

// NewDownloadProviderParamsWithContext creates a new DownloadProviderParams object
// with the ability to set a context for a request.
func NewDownloadProviderParamsWithContext(ctx context.Context) *DownloadProviderParams {
	return &DownloadProviderParams{
		Context: ctx,
	}
}

// NewDownloadProviderParamsWithHTTPClient creates a new DownloadProviderParams object
// with the ability to set a custom HTTPClient for a request.
func NewDownloadProviderParamsWithHTTPClient(client *http.Client) *DownloadProviderParams {
	return &DownloadProviderParams{
		HTTPClient: client,
	}
}

/*
DownloadProviderParams contains all the parameters to send to the API endpoint

	for the download provider operation.

	Typically these are written to a http.Request.
*/
type DownloadProviderParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the download provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadProviderParams) WithDefaults() *DownloadProviderParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the download provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DownloadProviderParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the download provider params
func (o *DownloadProviderParams) WithTimeout(timeout time.Duration) *DownloadProviderParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download provider params
func (o *DownloadProviderParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download provider params
func (o *DownloadProviderParams) WithContext(ctx context.Context) *DownloadProviderParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download provider params
func (o *DownloadProviderParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download provider params
func (o *DownloadProviderParams) WithHTTPClient(client *http.Client) *DownloadProviderParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download provider params
func (o *DownloadProviderParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the download provider params
func (o *DownloadProviderParams) WithBox(box string) *DownloadProviderParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the download provider params
func (o *DownloadProviderParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the download provider params
func (o *DownloadProviderParams) WithProvider(provider string) *DownloadProviderParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the download provider params
func (o *DownloadProviderParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the download provider params
func (o *DownloadProviderParams) WithRegistry(registry string) *DownloadProviderParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the download provider params
func (o *DownloadProviderParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the download provider params
func (o *DownloadProviderParams) WithVersion(version string) *DownloadProviderParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the download provider params
func (o *DownloadProviderParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadProviderParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
