// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make app-layers"
// DO NOT EDIT

package app

import (
	"archive/zip"
	"bytes"
	"context"
	"crypto/ecdsa"
	"io"
	"mime/multipart"
	"net/http"
	"net/url"
	"reflect"
	"time"

	"github.com/mattermost/mattermost-server/v6/app/request"
	"github.com/mattermost/mattermost-server/v6/audit"
	"github.com/mattermost/mattermost-server/v6/einterfaces"
	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/plugin"
	"github.com/mattermost/mattermost-server/v6/services/httpservice"
	"github.com/mattermost/mattermost-server/v6/services/imageproxy"
	"github.com/mattermost/mattermost-server/v6/services/remotecluster"
	"github.com/mattermost/mattermost-server/v6/services/searchengine"
	"github.com/mattermost/mattermost-server/v6/services/timezones"
	"github.com/mattermost/mattermost-server/v6/shared/filestore"
	"github.com/mattermost/mattermost-server/v6/shared/i18n"
	"github.com/mattermost/mattermost-server/v6/shared/mlog"
	"github.com/mattermost/mattermost-server/v6/store"
)

// AppIface is extracted from App struct and contains all it's exported methods. It's provided to allow partial interface passing and app layers creation.
type AppIface interface {
	// @openTracingParams args
	ExecuteCommand(c *request.Context, args *model.CommandArgs) (*model.CommandResponse, *model.AppError)
	// @openTracingParams teamID
	// previous ListCommands now ListAutocompleteCommands
	ListAutocompleteCommands(teamID string, T i18n.TranslateFunc) ([]*model.Command, *model.AppError)
	// @openTracingParams teamID, skipSlackParsing
	CreateCommandPost(c *request.Context, post *model.Post, teamID string, response *model.CommandResponse, skipSlackParsing bool) (*model.Post, *model.AppError)
	// AddChannelMember adds a user to a channel. It is a wrapper over AddUserToChannel.
	AddChannelMember(c *request.Context, userID string, channel *model.Channel, opts ChannelMemberOpts) (*model.ChannelMember, *model.AppError)
	// AddCursorIdsForPostList adds NextPostId and PrevPostId as cursor to the PostList.
	// The conditional blocks ensure that it sets those cursor IDs immediately as afterPost, beforePost or empty,
	// and only query to database whenever necessary.
	AddCursorIdsForPostList(originalList *model.PostList, afterPost, beforePost string, since int64, page, perPage int, collapsedThreads bool)
	// AddPublicKey will add plugin public key to the config. Overwrites the previous file
	AddPublicKey(name string, key io.Reader) *model.AppError
	// AddUserToChannel adds a user to a given channel.
	AddUserToChannel(user *model.User, channel *model.Channel, skipTeamMemberIntegrityCheck bool) (*model.ChannelMember, *model.AppError)
	// Caller must close the first return value
	FileReader(path string) (filestore.ReadCloseSeeker, *model.AppError)
	// ChannelMembersMinusGroupMembers returns the set of users in the given channel minus the set of users in the given
	// groups.
	//
	// The result can be used, for example, to determine the set of users who would be removed from a channel if the
	// channel were group-constrained with the given groups.
	ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page, perPage int) ([]*model.UserWithGroups, int64, *model.AppError)
	// ChannelMembersToAdd returns a slice of UserChannelIDPair that need newly created memberships
	// based on the groups configurations. The returned list can be optionally scoped to a single given channel.
	//
	// Typically since will be the last successful group sync time.
	// If includeRemovedMembers is true, then channel members who left or were removed from the channel will
	// be included; otherwise, they will be excluded.
	ChannelMembersToAdd(since int64, channelID *string, includeRemovedMembers bool) ([]*model.UserChannelIDPair, *model.AppError)
	// CheckProviderAttributes returns the empty string if the patch can be applied without
	// overriding attributes set by the user's login provider; otherwise, the name of the offending
	// field is returned.
	CheckProviderAttributes(user *model.User, patch *model.UserPatch) string
	// ClientConfigWithComputed gets the configuration in a format suitable for sending to the client.
	ClientConfigWithComputed() map[string]string
	// ConvertBotToUser converts a bot to user.
	ConvertBotToUser(bot *model.Bot, userPatch *model.UserPatch, sysadmin bool) (*model.User, *model.AppError)
	// ConvertUserToBot converts a user to bot.
	ConvertUserToBot(user *model.User) (*model.Bot, *model.AppError)
	// CreateBot creates the given bot and corresponding user.
	CreateBot(c *request.Context, bot *model.Bot) (*model.Bot, *model.AppError)
	// CreateChannelScheme creates a new Scheme of scope channel and assigns it to the channel.
	CreateChannelScheme(channel *model.Channel) (*model.Scheme, *model.AppError)
	// CreateDefaultMemberships adds users to teams and channels based on their group memberships and how those groups
	// are configured to sync with teams and channels for group members on or after the given timestamp.
	// If includeRemovedMembers is true, then members who left or were removed from a team/channel will
	// be re-added; otherwise, they will not be re-added.
	CreateDefaultMemberships(c *request.Context, since int64, includeRemovedMembers bool) error
	// CreateGuest creates a guest and sets several fields of the returned User struct to
	// their zero values.
	CreateGuest(c *request.Context, user *model.User) (*model.User, *model.AppError)
	// CreateUser creates a user and sets several fields of the returned User struct to
	// their zero values.
	CreateUser(c *request.Context, user *model.User) (*model.User, *model.AppError)
	// Creates and stores FileInfos for a post created before the FileInfos table existed.
	MigrateFilenamesToFileInfos(post *model.Post) []*model.FileInfo
	// DefaultChannelNames returns the list of system-wide default channel names.
	//
	// By default the list will be (not necessarily in this order):
	//	['town-square', 'off-topic']
	// However, if TeamSettings.ExperimentalDefaultChannels contains a list of channels then that list will replace
	// 'off-topic' and be included in the return results in addition to 'town-square'. For example:
	//	['town-square', 'game-of-thrones', 'wow']
	//
	DefaultChannelNames() []string
	// DeleteChannelScheme deletes a channels scheme and sets its SchemeId to nil.
	DeleteChannelScheme(channel *model.Channel) (*model.Channel, *model.AppError)
	// DeleteGroupConstrainedMemberships deletes team and channel memberships of users who aren't members of the allowed
	// groups of all group-constrained teams and channels.
	DeleteGroupConstrainedMemberships(c *request.Context) error
	// DeletePublicKey will delete plugin public key from the config.
	DeletePublicKey(name string) *model.AppError
	// DemoteUserToGuest Convert user's roles and all his membership's roles from
	// regular user roles to guest roles.
	DemoteUserToGuest(user *model.User) *model.AppError
	// DisablePlugin will set the config for an installed plugin to disabled, triggering deactivation if active.
	// Notifies cluster peers through config change.
	DisablePlugin(id string) *model.AppError
	// DoPermissionsMigrations execute all the permissions migrations need by the current version.
	DoPermissionsMigrations() error
	// EnablePlugin will set the config for an installed plugin to enabled, triggering asynchronous
	// activation if inactive anywhere in the cluster.
	// Notifies cluster peers through config change.
	EnablePlugin(id string) *model.AppError
	// Expand announcements in incoming webhooks from Slack. Those announcements
	// can be found in the text attribute, or in the pretext, text, title and value
	// attributes of the attachment structure. The Slack attachment structure is
	// documented here: https://api.slack.com/docs/attachments
	ProcessSlackAttachments(attachments []*model.SlackAttachment) []*model.SlackAttachment
	// ExtendSessionExpiryIfNeeded extends Session.ExpiresAt based on session lengths in config.
	// A new ExpiresAt is only written if enough time has elapsed since last update.
	// Returns true only if the session was extended.
	ExtendSessionExpiryIfNeeded(session *model.Session) bool
	// FillInPostProps should be invoked before saving posts to fill in properties such as
	// channel_mentions.
	//
	// If channel is nil, FillInPostProps will look up the channel corresponding to the post.
	FillInPostProps(post *model.Post, channel *model.Channel) *model.AppError
	// FilterNonGroupChannelMembers returns the subset of the given user IDs of the users who are not members of groups
	// associated to the channel excluding bots
	FilterNonGroupChannelMembers(userIDs []string, channel *model.Channel) ([]string, error)
	// FilterNonGroupTeamMembers returns the subset of the given user IDs of the users who are not members of groups
	// associated to the team excluding bots.
	FilterNonGroupTeamMembers(userIDs []string, team *model.Team) ([]string, error)
	// GetAllLdapGroupsPage retrieves all LDAP groups under the configured base DN using the default or configured group
	// filter.
	GetAllLdapGroupsPage(page int, perPage int, opts model.LdapGroupSearchOpts) ([]*model.Group, int, *model.AppError)
	// GetBot returns the given bot.
	GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError)
	// GetBots returns the requested page of bots.
	GetBots(options *model.BotGetOptions) (model.BotList, *model.AppError)
	// GetChannelGroupUsers returns the users who are associated to the channel via GroupChannels and GroupMembers.
	GetChannelGroupUsers(channelID string) ([]*model.User, *model.AppError)
	// GetChannelModerationsForChannel Gets a channels ChannelModerations from either the higherScoped roles or from the channel scheme roles.
	GetChannelModerationsForChannel(channel *model.Channel) ([]*model.ChannelModeration, *model.AppError)
	// GetClusterPluginStatuses returns the status for plugins installed anywhere in the cluster.
	GetClusterPluginStatuses() (model.PluginStatuses, *model.AppError)
	// GetConfigFile proxies access to the given configuration file to the underlying config store.
	GetConfigFile(name string) ([]byte, error)
	// GetEmojiStaticURL returns a relative static URL for system default emojis,
	// and the API route for custom ones. Errors if not found or if custom and deleted.
	GetEmojiStaticURL(emojiName string) (string, *model.AppError)
	// GetEnvironmentConfig returns a map of configuration keys whose values have been overridden by an environment variable.
	// If filter is not nil and returns false for a struct field, that field will be omitted.
	GetEnvironmentConfig(filter func(reflect.StructField) bool) map[string]interface{}
	// GetFilteredUsersStats is used to get a count of users based on the set of filters supported by UserCountOptions.
	GetFilteredUsersStats(options *model.UserCountOptions) (*model.UsersStats, *model.AppError)
	// GetGroupsByTeam returns the paged list and the total count of group associated to the given team.
	GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.AppError)
	// GetKnownUsers returns the list of user ids of users with any direct
	// relationship with a user. That means any user sharing any channel, including
	// direct and group channels.
	GetKnownUsers(userID string) ([]string, *model.AppError)
	// GetLdapGroup retrieves a single LDAP group by the given LDAP group id.
	GetLdapGroup(ldapGroupID string) (*model.Group, *model.AppError)
	// GetMarketplacePlugins returns a list of plugins from the marketplace-server,
	// and plugins that are installed locally.
	GetMarketplacePlugins(filter *model.MarketplacePluginFilter) ([]*model.MarketplacePlugin, *model.AppError)
	// GetPluginStatus returns the status for a plugin installed on this server.
	GetPluginStatus(id string) (*model.PluginStatus, *model.AppError)
	// GetPluginStatuses returns the status for plugins installed on this server.
	GetPluginStatuses() (model.PluginStatuses, *model.AppError)
	// GetPluginsEnvironment returns the plugin environment for use if plugins are enabled and
	// initialized.
	//
	// To get the plugins environment when the plugins are disabled, manually acquire the plugins
	// lock instead.
	GetPluginsEnvironment() *plugin.Environment
	// GetProductNotices is called from the frontend to fetch the product notices that are relevant to the caller
	GetProductNotices(c *request.Context, userID, teamID string, client model.NoticeClientType, clientVersion string, locale string) (model.NoticeMessages, *model.AppError)
	// GetPublicKey will return the actual public key saved in the `name` file.
	GetPublicKey(name string) ([]byte, *model.AppError)
	// GetSanitizedConfig gets the configuration for a system admin without any secrets.
	GetSanitizedConfig() *model.Config
	// GetSchemeRolesForChannel Checks if a channel or its team has an override scheme for channel roles and returns the scheme roles or default channel roles.
	GetSchemeRolesForChannel(channelID string) (guestRoleName string, userRoleName string, adminRoleName string, err *model.AppError)
	// GetSessionLengthInMillis returns the session length, in milliseconds,
	// based on the type of session (Mobile, SSO, Web/LDAP).
	GetSessionLengthInMillis(session *model.Session) int64
	// GetSuggestions returns suggestions for user input.
	GetSuggestions(c *request.Context, commandArgs *model.CommandArgs, commands []*model.Command, roleID string) []model.AutocompleteSuggestion
	// GetTeamGroupUsers returns the users who are associated to the team via GroupTeams and GroupMembers.
	GetTeamGroupUsers(teamID string) ([]*model.User, *model.AppError)
	// GetTeamSchemeChannelRoles Checks if a team has an override scheme and returns the scheme channel role names or default channel role names.
	GetTeamSchemeChannelRoles(teamID string) (guestRoleName string, userRoleName string, adminRoleName string, err *model.AppError)
	// GetTotalUsersStats is used for the DM list total
	GetTotalUsersStats(viewRestrictions *model.ViewUsersRestrictions) (*model.UsersStats, *model.AppError)
	// HasRemote returns whether a given channelID is present in the channel remotes or not.
	HasRemote(channelID string, remoteID string) (bool, error)
	// HubRegister registers a connection to a hub.
	HubRegister(webConn *WebConn)
	// HubUnregister unregisters a connection from a hub.
	HubUnregister(webConn *WebConn)
	// InstallPlugin unpacks and installs a plugin but does not enable or activate it.
	InstallPlugin(pluginFile io.ReadSeeker, replace bool) (*model.Manifest, *model.AppError)
	// LimitedClientConfigWithComputed gets the configuration in a format suitable for sending to the client.
	LimitedClientConfigWithComputed() map[string]string
	// LogAuditRec logs an audit record using default LvlAuditCLI.
	LogAuditRec(rec *audit.Record, err error)
	// LogAuditRecWithLevel logs an audit record using specified Level.
	LogAuditRecWithLevel(rec *audit.Record, level mlog.Level, err error)
	// MakeAuditRecord creates a audit record pre-populated with defaults.
	MakeAuditRecord(event string, initialStatus string) *audit.Record
	// MarkChanelAsUnreadFromPost will take a post and set the channel as unread from that one.
	MarkChannelAsUnreadFromPost(postID string, userID string, collapsedThreadsSupported bool) (*model.ChannelUnreadAt, *model.AppError)
	// MentionsToPublicChannels returns all the mentions to public channels,
	// linking them to their channels
	MentionsToPublicChannels(message, teamID string) model.ChannelMentionMap
	// MentionsToTeamMembers returns all the @ mentions found in message that
	// belong to users in the specified team, linking them to their users
	MentionsToTeamMembers(message, teamID string) model.UserMentionMap
	// MoveChannel method is prone to data races if someone joins to channel during the move process. However this
	// function is only exposed to sysadmins and the possibility of this edge case is relatively small.
	MoveChannel(c *request.Context, team *model.Team, channel *model.Channel, user *model.User) *model.AppError
	// NewWebConn returns a new WebConn instance.
	NewWebConn(cfg *WebConnConfig) *WebConn
	// NotifySessionsExpired is called periodically from the job server to notify any mobile sessions that have expired.
	NotifySessionsExpired() error
	// OverrideIconURLIfEmoji changes the post icon override URL prop, if it has an emoji icon,
	// so that it points to the URL (relative) of the emoji - static if emoji is default, /api if custom.
	OverrideIconURLIfEmoji(post *model.Post)
	// PatchBot applies the given patch to the bot and corresponding user.
	PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError)
	// PatchChannelModerationsForChannel Updates a channels scheme roles based on a given ChannelModerationPatch, if the permissions match the higher scoped role the scheme is deleted.
	PatchChannelModerationsForChannel(channel *model.Channel, channelModerationsPatch []*model.ChannelModerationPatch) ([]*model.ChannelModeration, *model.AppError)
	// Perform an HTTP POST request to an integration's action endpoint.
	// Caller must consume and close returned http.Response as necessary.
	// For internal requests, requests are routed directly to a plugin ServerHTTP hook
	DoActionRequest(c *request.Context, rawURL string, body []byte) (*http.Response, *model.AppError)
	// PermanentDeleteBot permanently deletes a bot and its corresponding user.
	PermanentDeleteBot(botUserId string) *model.AppError
	// PopulateWebConnConfig checks if the connection id already exists in the hub,
	// and if so, accordingly populates the other fields of the webconn.
	PopulateWebConnConfig(s *model.Session, cfg *WebConnConfig, seqVal string) (*WebConnConfig, error)
	// PromoteGuestToUser Convert user's roles and all his membership's roles from
	// guest roles to regular user roles.
	PromoteGuestToUser(c *request.Context, user *model.User, requestorId string) *model.AppError
	// RenameChannel is used to rename the channel Name and the DisplayName fields
	RenameChannel(channel *model.Channel, newChannelName string, newDisplayName string) (*model.Channel, *model.AppError)
	// RenameTeam is used to rename the team Name and the DisplayName fields
	RenameTeam(team *model.Team, newTeamName string, newDisplayName string) (*model.Team, *model.AppError)
	// RevokeSessionsFromAllUsers will go through all the sessions active
	// in the server and revoke them
	RevokeSessionsFromAllUsers() *model.AppError
	// SaveConfig replaces the active configuration, optionally notifying cluster peers.
	SaveConfig(newCfg *model.Config, sendConfigChangeClusterMessage bool) (*model.Config, *model.Config, *model.AppError)
	// SearchAllChannels returns a list of channels, the total count of the results of the search (if the paginate search option is true), and an error.
	SearchAllChannels(term string, opts model.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, *model.AppError)
	// SearchAllTeams returns a team list and the total count of the results
	SearchAllTeams(searchOpts *model.TeamSearch) ([]*model.Team, int64, *model.AppError)
	// SendNoCardPaymentFailedEmail
	SendNoCardPaymentFailedEmail() *model.AppError
	// SessionHasPermissionToManageBot returns nil if the session has access to manage the given bot.
	// This function deviates from other authorization checks in returning an error instead of just
	// a boolean, allowing the permission failure to be exposed with more granularity.
	SessionHasPermissionToManageBot(session model.Session, botUserId string) *model.AppError
	// SessionIsRegistered determines if a specific session has been registered
	SessionIsRegistered(session model.Session) bool
	// SetSessionExpireInDays sets the session's expiry the specified number of days
	// relative to either the session creation date or the current time, depending
	// on the `ExtendSessionOnActivity` config setting.
	SetSessionExpireInDays(session *model.Session, days int)
	// SetStatusDoNotDisturbTimed takes endtime in unix epoch format in UTC
	// and sets status of given userId to dnd which will be restored back after endtime
	SetStatusDoNotDisturbTimed(userId string, endtime int64)
	// SetStatusLastActivityAt sets the last activity at for a user on the local app server and updates
	// status to away if needed. Used by the WS to set status to away if an 'online' device disconnects
	// while an 'away' device is still connected
	SetStatusLastActivityAt(userID string, activityAt int64)
	// SyncLdap starts an LDAP sync job.
	// If includeRemovedMembers is true, then members who left or were removed from a team/channel will
	// be re-added; otherwise, they will not be re-added.
	SyncLdap(includeRemovedMembers bool)
	// SyncPlugins synchronizes the plugins installed locally
	// with the plugin bundles available in the file store.
	SyncPlugins() *model.AppError
	// SyncRolesAndMembership updates the SchemeAdmin status and membership of all of the members of the given
	// syncable.
	SyncRolesAndMembership(c *request.Context, syncableID string, syncableType model.GroupSyncableType, includeRemovedMembers bool)
	// SyncSyncableRoles updates the SchemeAdmin field value of the given syncable's members based on the configuration of
	// the member's group memberships and the configuration of those groups to the syncable. This method should only
	// be invoked on group-synced (aka group-constrained) syncables.
	SyncSyncableRoles(syncableID string, syncableType model.GroupSyncableType) *model.AppError
	// TeamMembersMinusGroupMembers returns the set of users on the given team minus the set of users in the given
	// groups.
	//
	// The result can be used, for example, to determine the set of users who would be removed from a team if the team
	// were group-constrained with the given groups.
	TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page, perPage int) ([]*model.UserWithGroups, int64, *model.AppError)
	// TeamMembersToAdd returns a slice of UserTeamIDPair that need newly created memberships
	// based on the groups configurations. The returned list can be optionally scoped to a single given team.
	//
	// Typically since will be the last successful group sync time.
	// If includeRemovedMembers is true, then team members who left or were removed from the team will
	// be included; otherwise, they will be excluded.
	TeamMembersToAdd(since int64, teamID *string, includeRemovedMembers bool) ([]*model.UserTeamIDPair, *model.AppError)
	// This function migrates the default built in roles from code/config to the database.
	DoAdvancedPermissionsMigration()
	// This function zip's up all the files in fileDatas array and then saves it to the directory specified with the specified zip file name
	// Ensure the zip file name ends with a .zip
	CreateZipFileAndAddFiles(fileBackend filestore.FileBackend, fileDatas []model.FileData, zipFileName, directory string) error
	// This to be used for places we check the users password when they are already logged in
	DoubleCheckPassword(user *model.User, password string) *model.AppError
	// UpdateBotActive marks a bot as active or inactive, along with its corresponding user.
	UpdateBotActive(c *request.Context, botUserId string, active bool) (*model.Bot, *model.AppError)
	// UpdateBotOwner changes a bot's owner to the given value.
	UpdateBotOwner(botUserId, newOwnerId string) (*model.Bot, *model.AppError)
	// UpdateChannel updates a given channel by its Id. It also publishes the CHANNEL_UPDATED event.
	UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError)
	// UpdateChannelScheme saves the new SchemeId of the channel passed.
	UpdateChannelScheme(channel *model.Channel) (*model.Channel, *model.AppError)
	// UpdateDNDStatusOfUsers is a recurring task which is started when server starts
	// which unsets dnd status of users if needed and saves and broadcasts it
	UpdateDNDStatusOfUsers()
	// UpdateProductNotices is called periodically from a scheduled worker to fetch new notices and update the cache
	UpdateProductNotices() *model.AppError
	// UpdateViewedProductNotices is called from the frontend to mark a set of notices as 'viewed' by user
	UpdateViewedProductNotices(userID string, noticeIds []string) *model.AppError
	// UpdateViewedProductNoticesForNewUser is called when new user is created to mark all current notices for this
	// user as viewed in order to avoid showing them imminently on first login
	UpdateViewedProductNoticesForNewUser(userID string)
	// UpdateWebConnUserActivity sets the LastUserActivityAt of the hub for the given session.
	UpdateWebConnUserActivity(session model.Session, activityAt int64)
	// UploadFile uploads a single file in form of a completely constructed byte array for a channel.
	UploadFile(c *request.Context, data []byte, channelID string, filename string) (*model.FileInfo, *model.AppError)
	// UploadFileX uploads a single file as specified in t. It applies the upload
	// constraints, executes plugins and image processing logic as needed. It
	// returns a filled-out FileInfo and an optional error. A plugin may reject the
	// upload, returning a rejection error. In this case FileInfo would have
	// contained the last "good" FileInfo before the execution of that plugin.
	UploadFileX(c *request.Context, channelID, name string, input io.Reader, opts ...func(*UploadFileTask)) (*model.FileInfo, *model.AppError)
	// Uploads some files to the given team and channel as the given user. files and filenames should have
	// the same length. clientIds should either not be provided or have the same length as files and filenames.
	// The provided files should be closed by the caller so that they are not leaked.
	UploadFiles(c *request.Context, teamID string, channelID string, userID string, files []io.ReadCloser, filenames []string, clientIds []string, now time.Time) (*model.FileUploadResponse, *model.AppError)
	// UserIsInAdminRoleGroup returns true at least one of the user's groups are configured to set the members as
	// admins in the given syncable.
	UserIsInAdminRoleGroup(userID, syncableID string, syncableType model.GroupSyncableType) (bool, *model.AppError)
	// VerifyPlugin checks that the given signature corresponds to the given plugin and matches a trusted certificate.
	VerifyPlugin(plugin, signature io.ReadSeeker) *model.AppError
	//GetUserStatusesByIds used by apiV4
	GetUserStatusesByIds(userIDs []string) ([]*model.Status, *model.AppError)
	AccountMigration() einterfaces.AccountMigrationInterface
	ActivateMfa(userID, token string) *model.AppError
	AddChannelsToRetentionPolicy(policyID string, channelIDs []string) *model.AppError
	AddConfigListener(listener func(*model.Config, *model.Config)) string
	AddDirectChannels(teamID string, user *model.User) *model.AppError
	AddLdapPrivateCertificate(fileData *multipart.FileHeader) *model.AppError
	AddLdapPublicCertificate(fileData *multipart.FileHeader) *model.AppError
	AddRemoteCluster(rc *model.RemoteCluster) (*model.RemoteCluster, *model.AppError)
	AddSamlIdpCertificate(fileData *multipart.FileHeader) *model.AppError
	AddSamlPrivateCertificate(fileData *multipart.FileHeader) *model.AppError
	AddSamlPublicCertificate(fileData *multipart.FileHeader) *model.AppError
	AddSessionToCache(session *model.Session)
	AddStatusCache(status *model.Status)
	AddStatusCacheSkipClusterSend(status *model.Status)
	AddTeamMember(c *request.Context, teamID, userID string) (*model.TeamMember, *model.AppError)
	AddTeamMemberByInviteId(c *request.Context, inviteId, userID string) (*model.TeamMember, *model.AppError)
	AddTeamMemberByToken(c *request.Context, userID, tokenID string) (*model.TeamMember, *model.AppError)
	AddTeamMembers(c *request.Context, teamID string, userIDs []string, userRequestorId string, graceful bool) ([]*model.TeamMemberWithError, *model.AppError)
	AddTeamsToRetentionPolicy(policyID string, teamIDs []string) *model.AppError
	AddUserToTeam(c *request.Context, teamID string, userID string, userRequestorId string) (*model.Team, *model.TeamMember, *model.AppError)
	AddUserToTeamByInviteId(c *request.Context, inviteId string, userID string) (*model.Team, *model.TeamMember, *model.AppError)
	AddUserToTeamByTeamId(c *request.Context, teamID string, user *model.User) *model.AppError
	AddUserToTeamByToken(c *request.Context, userID string, tokenID string) (*model.Team, *model.TeamMember, *model.AppError)
	AdjustImage(file io.Reader) (*bytes.Buffer, *model.AppError)
	AllowOAuthAppAccessToUser(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError)
	AppendFile(fr io.Reader, path string) (int64, *model.AppError)
	AsymmetricSigningKey() *ecdsa.PrivateKey
	AttachCloudSessionCookie(c *request.Context, w http.ResponseWriter, r *http.Request)
	AttachDeviceId(sessionID string, deviceID string, expiresAt int64) *model.AppError
	AttachSessionCookies(c *request.Context, w http.ResponseWriter, r *http.Request)
	AuthenticateUserForLogin(c *request.Context, id, loginId, password, mfaToken, cwsToken string, ldapOnly bool) (user *model.User, err *model.AppError)
	AuthorizeOAuthUser(w http.ResponseWriter, r *http.Request, service, code, state, redirectURI string) (io.ReadCloser, string, map[string]string, *model.User, *model.AppError)
	AutocompleteChannels(userID, term string) (model.ChannelListWithTeamData, *model.AppError)
	AutocompleteChannelsForSearch(teamID string, userID string, term string) (model.ChannelList, *model.AppError)
	AutocompleteChannelsForTeam(teamID, userID, term string) (model.ChannelList, *model.AppError)
	AutocompleteUsersInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, *model.AppError)
	AutocompleteUsersInTeam(teamID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInTeam, *model.AppError)
	BroadcastStatus(status *model.Status)
	BuildPostReactions(postID string) (*[]ReactionImportData, *model.AppError)
	BuildPushNotificationMessage(contentsConfig string, post *model.Post, user *model.User, channel *model.Channel, channelName string, senderName string, explicitMention bool, channelWideMention bool, replyToThreadType string) (*model.PushNotification, *model.AppError)
	BuildSamlMetadataObject(idpMetadata []byte) (*model.SamlMetadataResponse, *model.AppError)
	BulkExport(writer io.Writer, outPath string, opts model.BulkExportOpts) *model.AppError
	BulkImport(c *request.Context, jsonlReader io.Reader, attachmentsReader *zip.Reader, dryRun bool, workers int) (*model.AppError, int)
	BulkImportWithPath(c *request.Context, jsonlReader io.Reader, attachmentsReader *zip.Reader, dryRun bool, workers int, importPath string) (*model.AppError, int)
	CancelJob(jobId string) *model.AppError
	ChannelMembersToRemove(teamID *string) ([]*model.ChannelMember, *model.AppError)
	Channels() *Channels
	CheckCanInviteToSharedChannel(channelId string) error
	CheckForClientSideCert(r *http.Request) (string, string, string)
	CheckIntegrity() <-chan model.IntegrityCheckResult
	CheckMandatoryS3Fields(settings *model.FileSettings) *model.AppError
	CheckPasswordAndAllCriteria(user *model.User, password string, mfaToken string) *model.AppError
	CheckRolesExist(roleNames []string) *model.AppError
	CheckUserAllAuthenticationCriteria(user *model.User, mfaToken string) *model.AppError
	CheckUserMfa(user *model.User, token string) *model.AppError
	CheckUserPostflightAuthenticationCriteria(user *model.User) *model.AppError
	CheckUserPreflightAuthenticationCriteria(user *model.User, mfaToken string) *model.AppError
	CheckWebConn(userID, connectionID string) *CheckConnResult
	ClearChannelMembersCache(channelID string)
	ClearLatestVersionCache()
	ClearSessionCacheForAllUsers()
	ClearSessionCacheForAllUsersSkipClusterSend()
	ClearSessionCacheForUser(userID string)
	ClearSessionCacheForUserSkipClusterSend(userID string)
	ClearTeamMembersCache(teamID string)
	ClientConfig() map[string]string
	ClientConfigHash() string
	Cloud() einterfaces.CloudInterface
	Cluster() einterfaces.ClusterInterface
	CompareAndDeletePluginKey(pluginID string, key string, oldValue []byte) (bool, *model.AppError)
	CompareAndSetPluginKey(pluginID string, key string, oldValue, newValue []byte) (bool, *model.AppError)
	CompleteOAuth(c *request.Context, service string, body io.ReadCloser, teamID string, props map[string]string, tokenUser *model.User) (*model.User, *model.AppError)
	CompleteOnboarding(c *request.Context, request *model.CompleteOnboardingRequest) *model.AppError
	CompleteSwitchWithOAuth(service string, userData io.Reader, email string, tokenUser *model.User) (*model.User, *model.AppError)
	Compliance() einterfaces.ComplianceInterface
	Config() *model.Config
	CopyFileInfos(userID string, fileIDs []string) ([]string, *model.AppError)
	CreateChannel(c *request.Context, channel *model.Channel, addMember bool) (*model.Channel, *model.AppError)
	CreateChannelWithUser(c *request.Context, channel *model.Channel, userID string) (*model.Channel, *model.AppError)
	CreateCommand(cmd *model.Command) (*model.Command, *model.AppError)
	CreateCommandWebhook(commandID string, args *model.CommandArgs) (*model.CommandWebhook, *model.AppError)
	CreateEmoji(sessionUserId string, emoji *model.Emoji, multiPartImageData *multipart.Form) (*model.Emoji, *model.AppError)
	CreateGroup(group *model.Group) (*model.Group, *model.AppError)
	CreateGroupChannel(userIDs []string, creatorId string) (*model.Channel, *model.AppError)
	CreateGroupWithUserIds(group *model.GroupWithUserIds) (*model.Group, *model.AppError)
	CreateIncomingWebhookForChannel(creatorId string, channel *model.Channel, hook *model.IncomingWebhook) (*model.IncomingWebhook, *model.AppError)
	CreateJob(job *model.Job) (*model.Job, *model.AppError)
	CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError)
	CreateOAuthStateToken(extra string) (*model.Token, *model.AppError)
	CreateOAuthUser(c *request.Context, service string, userData io.Reader, teamID string, tokenUser *model.User) (*model.User, *model.AppError)
	CreateOutgoingWebhook(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError)
	CreatePasswordRecoveryToken(userID, email string) (*model.Token, *model.AppError)
	CreatePost(c *request.Context, post *model.Post, channel *model.Channel, triggerWebhooks, setOnline bool) (savedPost *model.Post, err *model.AppError)
	CreatePostAsUser(c *request.Context, post *model.Post, currentSessionId string, setOnline bool) (*model.Post, *model.AppError)
	CreatePostMissingChannel(c *request.Context, post *model.Post, triggerWebhooks bool) (*model.Post, *model.AppError)
	CreateRetentionPolicy(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError)
	CreateRole(role *model.Role) (*model.Role, *model.AppError)
	CreateScheme(scheme *model.Scheme) (*model.Scheme, *model.AppError)
	CreateSession(session *model.Session) (*model.Session, *model.AppError)
	CreateSidebarCategory(userID, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError)
	CreateTeam(c *request.Context, team *model.Team) (*model.Team, *model.AppError)
	CreateTeamWithUser(c *request.Context, team *model.Team, userID string) (*model.Team, *model.AppError)
	CreateTermsOfService(text, userID string) (*model.TermsOfService, *model.AppError)
	CreateUploadSession(us *model.UploadSession) (*model.UploadSession, *model.AppError)
	CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError)
	CreateUserAsAdmin(c *request.Context, user *model.User, redirect string) (*model.User, *model.AppError)
	CreateUserFromSignup(c *request.Context, user *model.User, redirect string) (*model.User, *model.AppError)
	CreateUserWithInviteId(c *request.Context, user *model.User, inviteId, redirect string) (*model.User, *model.AppError)
	CreateUserWithToken(c *request.Context, user *model.User, token *model.Token) (*model.User, *model.AppError)
	CreateWebhookPost(c *request.Context, userID string, channel *model.Channel, text, overrideUsername, overrideIconURL, overrideIconEmoji string, props model.StringInterface, postType string, postRootId string) (*model.Post, *model.AppError)
	DBHealthCheckDelete() error
	DBHealthCheckWrite() error
	DataRetention() einterfaces.DataRetentionInterface
	DeactivateGuests(c *request.Context) *model.AppError
	DeactivateMfa(userID string) *model.AppError
	DeauthorizeOAuthAppForUser(userID, appID string) *model.AppError
	DeleteAllExpiredPluginKeys() *model.AppError
	DeleteAllKeysForPlugin(pluginID string) *model.AppError
	DeleteBrandImage() *model.AppError
	DeleteChannel(c *request.Context, channel *model.Channel, userID string) *model.AppError
	DeleteCommand(commandID string) *model.AppError
	DeleteEmoji(emoji *model.Emoji) *model.AppError
	DeleteEphemeralPost(userID, postID string)
	DeleteExport(name string) *model.AppError
	DeleteGroup(groupID string) (*model.Group, *model.AppError)
	DeleteGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError)
	DeleteGroupMembers(groupID string, userIDs []string) ([]*model.GroupMember, *model.AppError)
	DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError)
	DeleteIncomingWebhook(hookID string) *model.AppError
	DeleteOAuthApp(appID string) *model.AppError
	DeleteOutgoingWebhook(hookID string) *model.AppError
	DeletePluginKey(pluginID string, key string) *model.AppError
	DeletePost(postID, deleteByID string) (*model.Post, *model.AppError)
	DeletePreferences(userID string, preferences model.Preferences) *model.AppError
	DeleteReactionForPost(c *request.Context, reaction *model.Reaction) *model.AppError
	DeleteRemoteCluster(remoteClusterId string) (bool, *model.AppError)
	DeleteRetentionPolicy(policyID string) *model.AppError
	DeleteScheme(schemeId string) (*model.Scheme, *model.AppError)
	DeleteSharedChannel(channelID string) (bool, error)
	DeleteSharedChannelRemote(id string) (bool, error)
	DeleteSidebarCategory(userID, teamID, categoryId string) *model.AppError
	DeleteToken(token *model.Token) *model.AppError
	DisableAutoResponder(userID string, asAdmin bool) *model.AppError
	DisableUserAccessToken(token *model.UserAccessToken) *model.AppError
	DoAppMigrations()
	DoCommandRequest(cmd *model.Command, p url.Values) (*model.Command, *model.CommandResponse, *model.AppError)
	DoEmojisPermissionsMigration()
	DoGuestRolesCreationMigration()
	DoLocalRequest(c *request.Context, rawURL string, body []byte) (*http.Response, *model.AppError)
	DoLogin(c *request.Context, w http.ResponseWriter, r *http.Request, user *model.User, deviceID string, isMobile, isOAuthUser, isSaml bool) *model.AppError
	DoPostAction(c *request.Context, postID, actionId, userID, selectedOption string) (string, *model.AppError)
	DoPostActionWithCookie(c *request.Context, postID, actionId, userID, selectedOption string, cookie *model.PostActionCookie) (string, *model.AppError)
	DoSystemConsoleRolesCreationMigration()
	DoUploadFile(c *request.Context, now time.Time, rawTeamId string, rawChannelId string, rawUserId string, rawFilename string, data []byte) (*model.FileInfo, *model.AppError)
	DoUploadFileExpectModification(c *request.Context, now time.Time, rawTeamId string, rawChannelId string, rawUserId string, rawFilename string, data []byte) (*model.FileInfo, []byte, *model.AppError)
	DownloadFromURL(downloadURL string) ([]byte, error)
	EnableUserAccessToken(token *model.UserAccessToken) *model.AppError
	EnvironmentConfig(filter func(reflect.StructField) bool) map[string]interface{}
	ExportPermissions(w io.Writer) error
	ExtractContentFromFileInfo(fileInfo *model.FileInfo) error
	FetchSamlMetadataFromIdp(url string) ([]byte, *model.AppError)
	FileBackend() filestore.FileBackend
	FileExists(path string) (bool, *model.AppError)
	FileModTime(path string) (time.Time, *model.AppError)
	FileSize(path string) (int64, *model.AppError)
	FillInChannelProps(channel *model.Channel) *model.AppError
	FillInChannelsProps(channelList model.ChannelList) *model.AppError
	FilterUsersByVisible(viewer *model.User, otherUsers []*model.User) ([]*model.User, *model.AppError)
	FindTeamByName(name string) bool
	GenerateMfaSecret(userID string) (*model.MfaSecret, *model.AppError)
	GeneratePublicLink(siteURL string, info *model.FileInfo) string
	GenerateSupportPacket() []model.FileData
	GetActivePluginManifests() ([]*model.Manifest, *model.AppError)
	GetAllChannels(page, perPage int, opts model.ChannelSearchOpts) (model.ChannelListWithTeamData, *model.AppError)
	GetAllChannelsCount(opts model.ChannelSearchOpts) (int64, *model.AppError)
	GetAllPrivateTeams() ([]*model.Team, *model.AppError)
	GetAllPublicTeams() ([]*model.Team, *model.AppError)
	GetAllRemoteClusters(filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, *model.AppError)
	GetAllRoles() ([]*model.Role, *model.AppError)
	GetAllStatuses() map[string]*model.Status
	GetAllTeams() ([]*model.Team, *model.AppError)
	GetAllTeamsPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, *model.AppError)
	GetAllTeamsPageWithCount(offset int, limit int, opts *model.TeamSearch) (*model.TeamsWithCount, *model.AppError)
	GetAnalytics(name string, teamID string) (model.AnalyticsRows, *model.AppError)
	GetAppliedSchemaMigrations() ([]model.AppliedMigration, *model.AppError)
	GetAudits(userID string, limit int) (model.Audits, *model.AppError)
	GetAuditsPage(userID string, page int, perPage int) (model.Audits, *model.AppError)
	GetAuthorizationCode(w http.ResponseWriter, r *http.Request, service string, props map[string]string, loginHint string) (string, *model.AppError)
	GetAuthorizedAppsForUser(userID string, page, perPage int) ([]*model.OAuthApp, *model.AppError)
	GetBrandImage() ([]byte, *model.AppError)
	GetBulkReactionsForPosts(postIDs []string) (map[string][]*model.Reaction, *model.AppError)
	GetChannel(channelID string) (*model.Channel, *model.AppError)
	GetChannelByName(channelName, teamID string, includeDeleted bool) (*model.Channel, *model.AppError)
	GetChannelByNameForTeamName(channelName, teamName string, includeDeleted bool) (*model.Channel, *model.AppError)
	GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, *model.AppError)
	GetChannelFileCount(channelID string) (int64, *model.AppError)
	GetChannelGuestCount(channelID string) (int64, *model.AppError)
	GetChannelMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, *model.AppError)
	GetChannelMemberCount(channelID string) (int64, *model.AppError)
	GetChannelMembersByIds(channelID string, userIDs []string) (model.ChannelMembers, *model.AppError)
	GetChannelMembersForUser(teamID string, userID string) (model.ChannelMembers, *model.AppError)
	GetChannelMembersForUserWithPagination(userID string, page, perPage int) ([]*model.ChannelMember, *model.AppError)
	GetChannelMembersPage(channelID string, page, perPage int) (model.ChannelMembers, *model.AppError)
	GetChannelMembersTimezones(channelID string) ([]string, *model.AppError)
	GetChannelMembersWithTeamDataForUserWithPagination(userID string, page, perPage int) (model.ChannelMembersWithTeamData, *model.AppError)
	GetChannelPinnedPostCount(channelID string) (int64, *model.AppError)
	GetChannelPoliciesForUser(userID string, offset, limit int) (*model.RetentionPolicyForChannelList, *model.AppError)
	GetChannelUnread(channelID, userID string) (*model.ChannelUnread, *model.AppError)
	GetChannels(channelIDs []string) ([]*model.Channel, *model.AppError)
	GetChannelsByNames(channelNames []string, teamID string) ([]*model.Channel, *model.AppError)
	GetChannelsForRetentionPolicy(policyID string, offset, limit int) (*model.ChannelsWithCount, *model.AppError)
	GetChannelsForScheme(scheme *model.Scheme, offset int, limit int) (model.ChannelList, *model.AppError)
	GetChannelsForSchemePage(scheme *model.Scheme, page int, perPage int) (model.ChannelList, *model.AppError)
	GetChannelsForTeamForUser(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, *model.AppError)
	GetChannelsForTeamForUserWithCursor(teamID string, userID string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, *model.AppError)
	GetChannelsForUser(userID string, includeDeleted bool, lastDeleteAt, pageSize int, fromChannelID string) (model.ChannelList, *model.AppError)
	GetChannelsUserNotIn(teamID string, userID string, offset int, limit int) (model.ChannelList, *model.AppError)
	GetCloudSession(token string) (*model.Session, *model.AppError)
	GetClusterId() string
	GetClusterStatus() []*model.ClusterInfo
	GetCommand(commandID string) (*model.Command, *model.AppError)
	GetCommonTeamIDsForTwoUsers(userID, otherUserID string) ([]string, *model.AppError)
	GetComplianceFile(job *model.Compliance) ([]byte, *model.AppError)
	GetComplianceReport(reportId string) (*model.Compliance, *model.AppError)
	GetComplianceReports(page, perPage int) (model.Compliances, *model.AppError)
	GetCookieDomain() string
	GetCustomStatus(userID string) (*model.CustomStatus, *model.AppError)
	GetDefaultProfileImage(user *model.User) ([]byte, *model.AppError)
	GetDeletedChannels(teamID string, offset int, limit int, userID string) (model.ChannelList, *model.AppError)
	GetEmoji(emojiId string) (*model.Emoji, *model.AppError)
	GetEmojiByName(emojiName string) (*model.Emoji, *model.AppError)
	GetEmojiImage(emojiId string) ([]byte, string, *model.AppError)
	GetEmojiList(page, perPage int, sort string) ([]*model.Emoji, *model.AppError)
	GetFile(fileID string) ([]byte, *model.AppError)
	GetFileInfo(fileID string) (*model.FileInfo, *model.AppError)
	GetFileInfos(page, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError)
	GetFileInfosForPost(postID string, fromMaster bool) ([]*model.FileInfo, *model.AppError)
	GetFileInfosForPostWithMigration(postID string) ([]*model.FileInfo, *model.AppError)
	GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, *model.AppError)
	GetFlaggedPostsForChannel(userID, channelID string, offset int, limit int) (*model.PostList, *model.AppError)
	GetFlaggedPostsForTeam(userID, teamID string, offset int, limit int) (*model.PostList, *model.AppError)
	GetGlobalRetentionPolicy() (*model.GlobalRetentionPolicy, *model.AppError)
	GetGroup(id string, opts *model.GetGroupOpts) (*model.Group, *model.AppError)
	GetGroupByName(name string, opts model.GroupSearchOpts) (*model.Group, *model.AppError)
	GetGroupByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, *model.AppError)
	GetGroupChannel(userIDs []string) (*model.Channel, *model.AppError)
	GetGroupMemberCount(groupID string) (int64, *model.AppError)
	GetGroupMemberUsers(groupID string) ([]*model.User, *model.AppError)
	GetGroupMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, int, *model.AppError)
	GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError)
	GetGroupSyncables(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, *model.AppError)
	GetGroups(page, perPage int, opts model.GroupSearchOpts) ([]*model.Group, *model.AppError)
	GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, *model.AppError)
	GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.AppError)
	GetGroupsByIDs(groupIDs []string) ([]*model.Group, *model.AppError)
	GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError)
	GetGroupsByUserId(userID string) ([]*model.Group, *model.AppError)
	GetHubForUserId(userID string) *Hub
	GetIncomingWebhook(hookID string) (*model.IncomingWebhook, *model.AppError)
	GetIncomingWebhooksForTeamPage(teamID string, page, perPage int) ([]*model.IncomingWebhook, *model.AppError)
	GetIncomingWebhooksForTeamPageByUser(teamID string, userID string, page, perPage int) ([]*model.IncomingWebhook, *model.AppError)
	GetIncomingWebhooksPage(page, perPage int) ([]*model.IncomingWebhook, *model.AppError)
	GetIncomingWebhooksPageByUser(userID string, page, perPage int) ([]*model.IncomingWebhook, *model.AppError)
	GetJob(id string) (*model.Job, *model.AppError)
	GetJobs(offset int, limit int) ([]*model.Job, *model.AppError)
	GetJobsByType(jobType string, offset int, limit int) ([]*model.Job, *model.AppError)
	GetJobsByTypePage(jobType string, page int, perPage int) ([]*model.Job, *model.AppError)
	GetJobsByTypes(jobTypes []string, offset int, limit int) ([]*model.Job, *model.AppError)
	GetJobsByTypesPage(jobType []string, page int, perPage int) ([]*model.Job, *model.AppError)
	GetJobsPage(page int, perPage int) ([]*model.Job, *model.AppError)
	GetLatestTermsOfService() (*model.TermsOfService, *model.AppError)
	GetLatestVersion(latestVersionUrl string) (*model.GithubReleaseInfo, *model.AppError)
	GetLogs(page, perPage int) ([]string, *model.AppError)
	GetLogsSkipSend(page, perPage int) ([]string, *model.AppError)
	GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, *model.AppError)
	GetMessageForNotification(post *model.Post, translateFunc i18n.TranslateFunc) string
	GetMultipleEmojiByName(names []string) ([]*model.Emoji, *model.AppError)
	GetNewUsersForTeamPage(teamID string, page, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetNextPostIdFromPostList(postList *model.PostList, collapsedThreads bool) string
	GetNotificationNameFormat(user *model.User) string
	GetNumberOfChannelsOnTeam(teamID string) (int, *model.AppError)
	GetOAuthAccessTokenForCodeFlow(clientId, grantType, redirectURI, code, secret, refreshToken string) (*model.AccessResponse, *model.AppError)
	GetOAuthAccessTokenForImplicitFlow(userID string, authRequest *model.AuthorizeRequest) (*model.Session, *model.AppError)
	GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError)
	GetOAuthApps(page, perPage int) ([]*model.OAuthApp, *model.AppError)
	GetOAuthAppsByCreator(userID string, page, perPage int) ([]*model.OAuthApp, *model.AppError)
	GetOAuthCodeRedirect(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError)
	GetOAuthImplicitRedirect(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError)
	GetOAuthLoginEndpoint(w http.ResponseWriter, r *http.Request, service, teamID, action, redirectTo, loginHint string, isMobile bool) (string, *model.AppError)
	GetOAuthSignupEndpoint(w http.ResponseWriter, r *http.Request, service, teamID string) (string, *model.AppError)
	GetOAuthStateToken(token string) (*model.Token, *model.AppError)
	GetOnboarding() (*model.System, *model.AppError)
	GetOpenGraphMetadata(requestURL string) ([]byte, error)
	GetOrCreateDirectChannel(c *request.Context, userID, otherUserID string, channelOptions ...model.ChannelOption) (*model.Channel, *model.AppError)
	GetOutgoingWebhook(hookID string) (*model.OutgoingWebhook, *model.AppError)
	GetOutgoingWebhooksForChannelPageByUser(channelID string, userID string, page, perPage int) ([]*model.OutgoingWebhook, *model.AppError)
	GetOutgoingWebhooksForTeamPage(teamID string, page, perPage int) ([]*model.OutgoingWebhook, *model.AppError)
	GetOutgoingWebhooksForTeamPageByUser(teamID string, userID string, page, perPage int) ([]*model.OutgoingWebhook, *model.AppError)
	GetOutgoingWebhooksPage(page, perPage int) ([]*model.OutgoingWebhook, *model.AppError)
	GetOutgoingWebhooksPageByUser(userID string, page, perPage int) ([]*model.OutgoingWebhook, *model.AppError)
	GetPasswordRecoveryToken(token string) (*model.Token, *model.AppError)
	GetPermalinkPost(c *request.Context, postID string, userID string) (*model.PostList, *model.AppError)
	GetPinnedPosts(channelID string) (*model.PostList, *model.AppError)
	GetPluginKey(pluginID string, key string) ([]byte, *model.AppError)
	GetPlugins() (*model.PluginsResponse, *model.AppError)
	GetPostAfterTime(channelID string, time int64, collapsedThreads bool) (*model.Post, *model.AppError)
	GetPostIdAfterTime(channelID string, time int64, collapsedThreads bool) (string, *model.AppError)
	GetPostIdBeforeTime(channelID string, time int64, collapsedThreads bool) (string, *model.AppError)
	GetPostIfAuthorized(postID string, session *model.Session) (*model.Post, *model.AppError)
	GetPostThread(postID string, opts model.GetPostsOptions, userID string) (*model.PostList, *model.AppError)
	GetPosts(channelID string, offset int, limit int) (*model.PostList, *model.AppError)
	GetPostsAfterPost(options model.GetPostsOptions) (*model.PostList, *model.AppError)
	GetPostsAroundPost(before bool, options model.GetPostsOptions) (*model.PostList, *model.AppError)
	GetPostsBeforePost(options model.GetPostsOptions) (*model.PostList, *model.AppError)
	GetPostsByIds(postIDs []string) ([]*model.Post, *model.AppError)
	GetPostsEtag(channelID string, collapsedThreads bool) string
	GetPostsForChannelAroundLastUnread(channelID, userID string, limitBefore, limitAfter int, skipFetchThreads bool, collapsedThreads, collapsedThreadsExtended bool) (*model.PostList, *model.AppError)
	GetPostsPage(options model.GetPostsOptions) (*model.PostList, *model.AppError)
	GetPostsSince(options model.GetPostsSinceOptions) (*model.PostList, *model.AppError)
	GetPreferenceByCategoryAndNameForUser(userID string, category string, preferenceName string) (*model.Preference, *model.AppError)
	GetPreferenceByCategoryForUser(userID string, category string) (model.Preferences, *model.AppError)
	GetPreferencesForUser(userID string) (model.Preferences, *model.AppError)
	GetPrevPostIdFromPostList(postList *model.PostList, collapsedThreads bool) string
	GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, *model.AppError)
	GetProfileImage(user *model.User) ([]byte, bool, *model.AppError)
	GetPublicChannelsByIdsForTeam(teamID string, channelIDs []string) (model.ChannelList, *model.AppError)
	GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, *model.AppError)
	GetReactionsForPost(postID string) ([]*model.Reaction, *model.AppError)
	GetRecentlyActiveUsersForTeam(teamID string) (map[string]*model.User, *model.AppError)
	GetRecentlyActiveUsersForTeamPage(teamID string, page, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetRemoteCluster(remoteClusterId string) (*model.RemoteCluster, *model.AppError)
	GetRemoteClusterForUser(remoteID string, userID string) (*model.RemoteCluster, *model.AppError)
	GetRemoteClusterService() (remotecluster.RemoteClusterServiceIFace, *model.AppError)
	GetRemoteClusterSession(token string, remoteId string) (*model.Session, *model.AppError)
	GetRetentionPolicies(offset, limit int) (*model.RetentionPolicyWithTeamAndChannelCountsList, *model.AppError)
	GetRetentionPoliciesCount() (int64, *model.AppError)
	GetRetentionPolicy(policyID string) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError)
	GetRole(id string) (*model.Role, *model.AppError)
	GetRoleByName(ctx context.Context, name string) (*model.Role, *model.AppError)
	GetRolesByNames(names []string) ([]*model.Role, *model.AppError)
	GetSamlCertificateStatus() *model.SamlCertificateStatus
	GetSamlMetadata() (string, *model.AppError)
	GetSamlMetadataFromIdp(idpMetadataURL string) (*model.SamlMetadataResponse, *model.AppError)
	GetSanitizeOptions(asAdmin bool) map[string]bool
	GetScheme(id string) (*model.Scheme, *model.AppError)
	GetSchemeByName(name string) (*model.Scheme, *model.AppError)
	GetSchemeRolesForTeam(teamID string) (string, string, string, *model.AppError)
	GetSchemes(scope string, offset int, limit int) ([]*model.Scheme, *model.AppError)
	GetSchemesPage(scope string, page int, perPage int) ([]*model.Scheme, *model.AppError)
	GetSession(token string) (*model.Session, *model.AppError)
	GetSessionById(sessionID string) (*model.Session, *model.AppError)
	GetSessions(userID string) ([]*model.Session, *model.AppError)
	GetSharedChannel(channelID string) (*model.SharedChannel, error)
	GetSharedChannelRemote(id string) (*model.SharedChannelRemote, error)
	GetSharedChannelRemoteByIds(channelID string, remoteID string) (*model.SharedChannelRemote, error)
	GetSharedChannelRemotes(opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error)
	GetSharedChannelRemotesStatus(channelID string) ([]*model.SharedChannelRemoteStatus, error)
	GetSharedChannels(page int, perPage int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, *model.AppError)
	GetSharedChannelsCount(opts model.SharedChannelFilterOpts) (int64, error)
	GetSidebarCategories(userID, teamID string) (*model.OrderedSidebarCategories, *model.AppError)
	GetSidebarCategory(categoryId string) (*model.SidebarCategoryWithChannels, *model.AppError)
	GetSidebarCategoryOrder(userID, teamID string) ([]string, *model.AppError)
	GetSinglePost(postID string) (*model.Post, *model.AppError)
	GetSiteURL() string
	GetStatus(userID string) (*model.Status, *model.AppError)
	GetStatusFromCache(userID string) *model.Status
	GetStatusesByIds(userIDs []string) (map[string]interface{}, *model.AppError)
	GetSystemBot() (*model.Bot, *model.AppError)
	GetTeam(teamID string) (*model.Team, *model.AppError)
	GetTeamByInviteId(inviteId string) (*model.Team, *model.AppError)
	GetTeamByName(name string) (*model.Team, *model.AppError)
	GetTeamIcon(team *model.Team) ([]byte, *model.AppError)
	GetTeamIdFromQuery(query url.Values) (string, *model.AppError)
	GetTeamMember(teamID, userID string) (*model.TeamMember, *model.AppError)
	GetTeamMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, *model.AppError)
	GetTeamMembersByIds(teamID string, userIDs []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, *model.AppError)
	GetTeamMembersForUser(userID string) ([]*model.TeamMember, *model.AppError)
	GetTeamMembersForUserWithPagination(userID string, page, perPage int) ([]*model.TeamMember, *model.AppError)
	GetTeamPoliciesForUser(userID string, offset, limit int) (*model.RetentionPolicyForTeamList, *model.AppError)
	GetTeamStats(teamID string, restrictions *model.ViewUsersRestrictions) (*model.TeamStats, *model.AppError)
	GetTeamUnread(teamID, userID string) (*model.TeamUnread, *model.AppError)
	GetTeams(teamIDs []string) ([]*model.Team, *model.AppError)
	GetTeamsForRetentionPolicy(policyID string, offset, limit int) (*model.TeamsWithCount, *model.AppError)
	GetTeamsForScheme(scheme *model.Scheme, offset int, limit int) ([]*model.Team, *model.AppError)
	GetTeamsForSchemePage(scheme *model.Scheme, page int, perPage int) ([]*model.Team, *model.AppError)
	GetTeamsForUser(userID string) ([]*model.Team, *model.AppError)
	GetTeamsUnreadForUser(excludeTeamId string, userID string, includeCollapsedThreads bool) ([]*model.TeamUnread, *model.AppError)
	GetTermsOfService(id string) (*model.TermsOfService, *model.AppError)
	GetThreadForUser(teamID string, threadMembership *model.ThreadMembership, extended bool) (*model.ThreadResponse, *model.AppError)
	GetThreadMembershipForUser(userId, threadId string) (*model.ThreadMembership, *model.AppError)
	GetThreadMembershipsForUser(userID, teamID string) ([]*model.ThreadMembership, error)
	GetThreadsForUser(userID, teamID string, options model.GetUserThreadsOpts) (*model.Threads, *model.AppError)
	GetTokenById(token string) (*model.Token, *model.AppError)
	GetTopReactionsForTeamSince(teamID string, userID string, opts *model.InsightsOpts) (*model.TopReactionList, *model.AppError)
	GetTopReactionsForUserSince(userID string, teamID string, opts *model.InsightsOpts) (*model.TopReactionList, *model.AppError)
	GetUploadSession(uploadId string) (*model.UploadSession, *model.AppError)
	GetUploadSessionsForUser(userID string) ([]*model.UploadSession, *model.AppError)
	GetUser(userID string) (*model.User, *model.AppError)
	GetUserAccessToken(tokenID string, sanitize bool) (*model.UserAccessToken, *model.AppError)
	GetUserAccessTokens(page, perPage int) ([]*model.UserAccessToken, *model.AppError)
	GetUserAccessTokensForUser(userID string, page, perPage int) ([]*model.UserAccessToken, *model.AppError)
	GetUserByAuth(authData *string, authService string) (*model.User, *model.AppError)
	GetUserByEmail(email string) (*model.User, *model.AppError)
	GetUserByUsername(username string) (*model.User, *model.AppError)
	GetUserForLogin(id, loginId string) (*model.User, *model.AppError)
	GetUserTermsOfService(userID string) (*model.UserTermsOfService, *model.AppError)
	GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	GetUsersByGroupChannelIds(c *request.Context, channelIDs []string, asAdmin bool) (map[string][]*model.User, *model.AppError)
	GetUsersByIds(userIDs []string, options *store.UserGetByIdsOpts) ([]*model.User, *model.AppError)
	GetUsersByUsernames(usernames []string, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetUsersEtag(restrictionsHash string) string
	GetUsersInChannel(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	GetUsersInChannelByStatus(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	GetUsersInChannelMap(options *model.UserGetOptions, asAdmin bool) (map[string]*model.User, *model.AppError)
	GetUsersInChannelPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError)
	GetUsersInChannelPageByStatus(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError)
	GetUsersInTeam(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	GetUsersInTeamEtag(teamID string, restrictionsHash string) string
	GetUsersInTeamPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError)
	GetUsersNotInChannel(teamID string, channelID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetUsersNotInChannelMap(teamID string, channelID string, groupConstrained bool, offset int, limit int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) (map[string]*model.User, *model.AppError)
	GetUsersNotInChannelPage(teamID string, channelID string, groupConstrained bool, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetUsersNotInGroupPage(groupID string, page int, perPage int) ([]*model.User, *model.AppError)
	GetUsersNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetUsersNotInTeamEtag(teamID string, restrictionsHash string) string
	GetUsersNotInTeamPage(teamID string, groupConstrained bool, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError)
	GetUsersPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError)
	GetUsersWithInvalidEmails(page int, perPage int) ([]*model.User, *model.AppError)
	GetUsersWithoutTeam(options *model.UserGetOptions) ([]*model.User, *model.AppError)
	GetUsersWithoutTeamPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError)
	GetVerifyEmailToken(token string) (*model.Token, *model.AppError)
	GetViewUsersRestrictions(userID string) (*model.ViewUsersRestrictions, *model.AppError)
	GetWarnMetricsBot() (*model.Bot, *model.AppError)
	GetWarnMetricsStatus() (map[string]*model.WarnMetricStatus, *model.AppError)
	HTTPService() httpservice.HTTPService
	Handle404(w http.ResponseWriter, r *http.Request)
	HandleCommandResponse(c *request.Context, command *model.Command, args *model.CommandArgs, response *model.CommandResponse, builtIn bool) (*model.CommandResponse, *model.AppError)
	HandleCommandResponsePost(c *request.Context, command *model.Command, args *model.CommandArgs, response *model.CommandResponse, builtIn bool) (*model.Post, *model.AppError)
	HandleCommandWebhook(c *request.Context, hookID string, response *model.CommandResponse) *model.AppError
	HandleImages(previewPathList []string, thumbnailPathList []string, fileData [][]byte)
	HandleIncomingWebhook(c *request.Context, hookID string, req *model.IncomingWebhookRequest) *model.AppError
	HandleMessageExportConfig(cfg *model.Config, appCfg *model.Config)
	HasPermissionTo(askingUserId string, permission *model.Permission) bool
	HasPermissionToChannel(askingUserId string, channelID string, permission *model.Permission) bool
	HasPermissionToChannelByPost(askingUserId string, postID string, permission *model.Permission) bool
	HasPermissionToReadChannel(userID string, channel *model.Channel) bool
	HasPermissionToTeam(askingUserId string, teamID string, permission *model.Permission) bool
	HasPermissionToUser(askingUserId string, userID string) bool
	HasSharedChannel(channelID string) (bool, error)
	ImageProxy() *imageproxy.ImageProxy
	ImageProxyAdder() func(string) string
	ImageProxyRemover() (f func(string) string)
	ImportPermissions(jsonl io.Reader) error
	InitPlugins(c *request.Context, pluginDir, webappPluginDir string)
	InvalidateAllEmailInvites() *model.AppError
	InvalidateAllResendInviteEmailJobs() *model.AppError
	InvalidateCacheForUser(userID string)
	InviteGuestsToChannels(teamID string, guestsInvite *model.GuestsInvite, senderId string) *model.AppError
	InviteGuestsToChannelsGracefully(teamID string, guestsInvite *model.GuestsInvite, senderId string) ([]*model.EmailInviteWithError, *model.AppError)
	InviteNewUsersToTeam(emailList []string, teamID, senderId string) *model.AppError
	InviteNewUsersToTeamGracefully(memberInvite *model.MemberInvite, teamID, senderId string, reminderInterval string) ([]*model.EmailInviteWithError, *model.AppError)
	IsCRTEnabledForUser(userID string) bool
	IsFirstUserAccount() bool
	IsLeader() bool
	IsPasswordValid(password string) *model.AppError
	IsPhase2MigrationCompleted() *model.AppError
	IsUserAway(lastActivityAt int64) bool
	IsUserSignUpAllowed() *model.AppError
	JoinChannel(c *request.Context, channel *model.Channel, userID string) *model.AppError
	JoinDefaultChannels(c *request.Context, teamID string, user *model.User, shouldBeAdmin bool, userRequestorId string) *model.AppError
	JoinUserToTeam(c *request.Context, team *model.Team, user *model.User, userRequestorId string) (*model.TeamMember, *model.AppError)
	Ldap() einterfaces.LdapInterface
	LeaveChannel(c *request.Context, channelID string, userID string) *model.AppError
	LeaveTeam(c *request.Context, team *model.Team, user *model.User, requestorId string) *model.AppError
	License() *model.License
	LimitedClientConfig() map[string]string
	ListAllCommands(teamID string, T i18n.TranslateFunc) ([]*model.Command, *model.AppError)
	ListDirectory(path string) ([]string, *model.AppError)
	ListDirectoryRecursively(path string) ([]string, *model.AppError)
	ListExports() ([]string, *model.AppError)
	ListImports() ([]string, *model.AppError)
	ListPluginKeys(pluginID string, page, perPage int) ([]string, *model.AppError)
	ListTeamCommands(teamID string) ([]*model.Command, *model.AppError)
	Log() *mlog.Logger
	LoginByOAuth(c *request.Context, service string, userData io.Reader, teamID string, tokenUser *model.User) (*model.User, *model.AppError)
	MakePermissionError(s *model.Session, permissions []*model.Permission) *model.AppError
	MarkChannelsAsViewed(channelIDs []string, userID string, currentSessionId string, collapsedThreadsSupported bool) (map[string]int64, *model.AppError)
	MaxPostSize() int
	MessageExport() einterfaces.MessageExportInterface
	Metrics() einterfaces.MetricsInterface
	MigrateIdLDAP(toAttribute string) *model.AppError
	MoveCommand(team *model.Team, command *model.Command) *model.AppError
	MoveFile(oldPath, newPath string) *model.AppError
	NewClusterDiscoveryService() *ClusterDiscoveryService
	NewPluginAPI(c *request.Context, manifest *model.Manifest) plugin.API
	Notification() einterfaces.NotificationInterface
	NotificationsLog() *mlog.Logger
	NotifyAndSetWarnMetricAck(warnMetricId string, sender *model.User, forceAck bool, isBot bool) *model.AppError
	NotifySharedChannelUserUpdate(user *model.User)
	OpenInteractiveDialog(request model.OpenDialogRequest) *model.AppError
	OriginChecker() func(*http.Request) bool
	PatchChannel(c *request.Context, channel *model.Channel, patch *model.ChannelPatch, userID string) (*model.Channel, *model.AppError)
	PatchPost(c *request.Context, postID string, patch *model.PostPatch) (*model.Post, *model.AppError)
	PatchRetentionPolicy(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError)
	PatchRole(role *model.Role, patch *model.RolePatch) (*model.Role, *model.AppError)
	PatchScheme(scheme *model.Scheme, patch *model.SchemePatch) (*model.Scheme, *model.AppError)
	PatchTeam(teamID string, patch *model.TeamPatch) (*model.Team, *model.AppError)
	PatchUser(userID string, patch *model.UserPatch, asAdmin bool) (*model.User, *model.AppError)
	PermanentDeleteAllUsers(c *request.Context) *model.AppError
	PermanentDeleteChannel(channel *model.Channel) *model.AppError
	PermanentDeleteTeam(team *model.Team) *model.AppError
	PermanentDeleteTeamId(teamID string) *model.AppError
	PermanentDeleteUser(c *request.Context, user *model.User) *model.AppError
	PluginCommandsForTeam(teamID string) []*model.Command
	PostActionCookieSecret() []byte
	PostAddToChannelMessage(c *request.Context, user *model.User, addedUser *model.User, channel *model.Channel, postRootId string) *model.AppError
	PostPatchWithProxyRemovedFromImageURLs(patch *model.PostPatch) *model.PostPatch
	PostUpdateChannelDisplayNameMessage(c *request.Context, userID string, channel *model.Channel, oldChannelDisplayName, newChannelDisplayName string) *model.AppError
	PostUpdateChannelHeaderMessage(c *request.Context, userID string, channel *model.Channel, oldChannelHeader, newChannelHeader string) *model.AppError
	PostUpdateChannelPurposeMessage(c *request.Context, userID string, channel *model.Channel, oldChannelPurpose string, newChannelPurpose string) *model.AppError
	PostWithProxyAddedToImageURLs(post *model.Post) *model.Post
	PostWithProxyRemovedFromImageURLs(post *model.Post) *model.Post
	PreparePostForClient(originalPost *model.Post, isNewPost, isEditPost bool) *model.Post
	PreparePostForClientWithEmbedsAndImages(originalPost *model.Post, isNewPost, isEditPost bool) *model.Post
	PreparePostListForClient(originalList *model.PostList) *model.PostList
	ProcessSlackText(text string) string
	Publish(message *model.WebSocketEvent)
	PublishUserTyping(userID, channelID, parentId string) *model.AppError
	PurgeBleveIndexes() *model.AppError
	PurgeElasticsearchIndexes() *model.AppError
	ReadFile(path string) ([]byte, *model.AppError)
	RecycleDatabaseConnection()
	RegenCommandToken(cmd *model.Command) (*model.Command, *model.AppError)
	RegenOutgoingWebhookToken(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError)
	RegenerateOAuthAppSecret(app *model.OAuthApp) (*model.OAuthApp, *model.AppError)
	RegenerateTeamInviteId(teamID string) (*model.Team, *model.AppError)
	RegisterPluginCommand(pluginID string, command *model.Command) error
	ReloadConfig() error
	RemoveAllDeactivatedMembersFromChannel(channel *model.Channel) *model.AppError
	RemoveChannelsFromRetentionPolicy(policyID string, channelIDs []string) *model.AppError
	RemoveConfigListener(id string)
	RemoveCustomStatus(userID string) *model.AppError
	RemoveDirectory(path string) *model.AppError
	RemoveFile(path string) *model.AppError
	RemoveLdapPrivateCertificate() *model.AppError
	RemoveLdapPublicCertificate() *model.AppError
	RemoveRecentCustomStatus(userID string, status *model.CustomStatus) *model.AppError
	RemoveSamlIdpCertificate() *model.AppError
	RemoveSamlPrivateCertificate() *model.AppError
	RemoveSamlPublicCertificate() *model.AppError
	RemoveTeamIcon(teamID string) *model.AppError
	RemoveTeamsFromRetentionPolicy(policyID string, teamIDs []string) *model.AppError
	RemoveUserFromChannel(c *request.Context, userIDToRemove string, removerUserId string, channel *model.Channel) *model.AppError
	RemoveUserFromTeam(c *request.Context, teamID string, userID string, requestorId string) *model.AppError
	RemoveUsersFromChannelNotMemberOfTeam(c *request.Context, remover *model.User, channel *model.Channel, team *model.Team) *model.AppError
	RequestLicenseAndAckWarnMetric(c *request.Context, warnMetricId string, isBot bool) *model.AppError
	ResetPasswordFromToken(userSuppliedTokenString, newPassword string) *model.AppError
	ResetPermissionsSystem() *model.AppError
	ResetSamlAuthDataToEmail(includeDeleted bool, dryRun bool, userIDs []string) (numAffected int, appErr *model.AppError)
	RestoreChannel(c *request.Context, channel *model.Channel, userID string) (*model.Channel, *model.AppError)
	RestoreTeam(teamID string) *model.AppError
	RestrictUsersGetByPermissions(userID string, options *model.UserGetOptions) (*model.UserGetOptions, *model.AppError)
	RestrictUsersSearchByPermissions(userID string, options *model.UserSearchOptions) (*model.UserSearchOptions, *model.AppError)
	ReturnSessionToPool(session *model.Session)
	RevokeAccessToken(token string) *model.AppError
	RevokeAllSessions(userID string) *model.AppError
	RevokeSession(session *model.Session) *model.AppError
	RevokeSessionById(sessionID string) *model.AppError
	RevokeSessionsForDeviceId(userID string, deviceID string, currentSessionId string) *model.AppError
	RevokeUserAccessToken(token *model.UserAccessToken) *model.AppError
	RolesGrantPermission(roleNames []string, permissionId string) bool
	Saml() einterfaces.SamlInterface
	SanitizePostListMetadataForUser(postList *model.PostList, userID string) (*model.PostList, *model.AppError)
	SanitizePostMetadataForUser(post *model.Post, userID string) (*model.Post, *model.AppError)
	SanitizeProfile(user *model.User, asAdmin bool)
	SanitizeTeam(session model.Session, team *model.Team) *model.Team
	SanitizeTeams(session model.Session, teams []*model.Team) []*model.Team
	SaveAndBroadcastStatus(status *model.Status)
	SaveBrandImage(imageData *multipart.FileHeader) *model.AppError
	SaveComplianceReport(job *model.Compliance) (*model.Compliance, *model.AppError)
	SaveReactionForPost(c *request.Context, reaction *model.Reaction) (*model.Reaction, *model.AppError)
	SaveSharedChannel(sc *model.SharedChannel) (*model.SharedChannel, error)
	SaveSharedChannelRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error)
	SaveUserTermsOfService(userID, termsOfServiceId string, accepted bool) *model.AppError
	SchemesIterator(scope string, batchSize int) func() []*model.Scheme
	SearchArchivedChannels(teamID string, term string, userID string) (model.ChannelList, *model.AppError)
	SearchChannels(teamID string, term string) (model.ChannelList, *model.AppError)
	SearchChannelsForUser(userID, teamID, term string) (model.ChannelList, *model.AppError)
	SearchChannelsUserNotIn(teamID string, userID string, term string) (model.ChannelList, *model.AppError)
	SearchEmoji(name string, prefixOnly bool, limit int) ([]*model.Emoji, *model.AppError)
	SearchEngine() *searchengine.Broker
	SearchFilesInTeamForUser(c *request.Context, terms string, userId string, teamId string, isOrSearch bool, includeDeletedChannels bool, timeZoneOffset int, page, perPage int) (*model.FileInfoList, *model.AppError)
	SearchGroupChannels(userID, term string) (model.ChannelList, *model.AppError)
	SearchPostsForUser(c *request.Context, terms string, userID string, teamID string, isOrSearch bool, includeDeletedChannels bool, timeZoneOffset int, page, perPage int) (*model.PostSearchResults, *model.AppError)
	SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) (*model.PostList, *model.AppError)
	SearchPrivateTeams(searchOpts *model.TeamSearch) ([]*model.Team, *model.AppError)
	SearchPublicTeams(searchOpts *model.TeamSearch) ([]*model.Team, *model.AppError)
	SearchUserAccessTokens(term string) ([]*model.UserAccessToken, *model.AppError)
	SearchUsers(props *model.UserSearch, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersInTeam(teamID, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersNotInTeam(notInTeamId string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SearchUsersWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError)
	SendAckToPushProxy(ack *model.PushNotificationAck) error
	SendAutoResponse(c *request.Context, channel *model.Channel, receiver *model.User, post *model.Post) (bool, *model.AppError)
	SendAutoResponseIfNecessary(c *request.Context, channel *model.Channel, sender *model.User, post *model.Post) (bool, *model.AppError)
	SendCloudTrialEndWarningEmail(trialEndDate, siteURL string) *model.AppError
	SendCloudTrialEndedEmail() *model.AppError
	SendEmailVerification(user *model.User, newEmail, redirect string) *model.AppError
	SendEphemeralPost(userID string, post *model.Post) *model.Post
	SendNotifications(post *model.Post, team *model.Team, channel *model.Channel, sender *model.User, parentPostList *model.PostList, setOnline bool) ([]string, error)
	SendPasswordReset(email string, siteURL string) (bool, *model.AppError)
	SendPaymentFailedEmail(failedPayment *model.FailedPayment) *model.AppError
	SendTestPushNotification(deviceID string) string
	ServeInterPluginRequest(w http.ResponseWriter, r *http.Request, sourcePluginId, destinationPluginId string)
	SessionHasPermissionTo(session model.Session, permission *model.Permission) bool
	SessionHasPermissionToAny(session model.Session, permissions []*model.Permission) bool
	SessionHasPermissionToCategory(session model.Session, userID, teamID, categoryId string) bool
	SessionHasPermissionToChannel(session model.Session, channelID string, permission *model.Permission) bool
	SessionHasPermissionToChannelByPost(session model.Session, postID string, permission *model.Permission) bool
	SessionHasPermissionToCreateJob(session model.Session, job *model.Job) (bool, *model.Permission)
	SessionHasPermissionToGroup(session model.Session, groupID string, permission *model.Permission) bool
	SessionHasPermissionToReadJob(session model.Session, jobType string) (bool, *model.Permission)
	SessionHasPermissionToTeam(session model.Session, teamID string, permission *model.Permission) bool
	SessionHasPermissionToUser(session model.Session, userID string) bool
	SessionHasPermissionToUserOrBot(session model.Session, userID string) bool
	SetActiveChannel(userID string, channelID string) *model.AppError
	SetAutoResponderStatus(user *model.User, oldNotifyProps model.StringMap)
	SetChannels(ch *Channels)
	SetCustomStatus(userID string, cs *model.CustomStatus) *model.AppError
	SetDefaultProfileImage(user *model.User) *model.AppError
	SetPhase2PermissionsMigrationStatus(isComplete bool) error
	SetPluginKey(pluginID string, key string, value []byte) *model.AppError
	SetPluginKeyWithExpiry(pluginID string, key string, value []byte, expireInSeconds int64) *model.AppError
	SetPluginKeyWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError)
	SetProfileImage(userID string, imageData *multipart.FileHeader) *model.AppError
	SetProfileImageFromFile(userID string, file io.Reader) *model.AppError
	SetProfileImageFromMultiPartFile(userID string, file multipart.File) *model.AppError
	SetRemoteClusterLastPingAt(remoteClusterId string) *model.AppError
	SetSamlIdpCertificateFromMetadata(data []byte) *model.AppError
	SetSearchEngine(se *searchengine.Broker)
	SetServer(srv *Server)
	SetStatusAwayIfNeeded(userID string, manual bool)
	SetStatusDoNotDisturb(userID string)
	SetStatusOffline(userID string, manual bool)
	SetStatusOnline(userID string, manual bool)
	SetStatusOutOfOffice(userID string)
	SetTeamIcon(teamID string, imageData *multipart.FileHeader) *model.AppError
	SetTeamIconFromFile(team *model.Team, file io.Reader) *model.AppError
	SetTeamIconFromMultiPartFile(teamID string, file multipart.File) *model.AppError
	SlackImport(c *request.Context, fileData multipart.File, fileSize int64, teamID string) (*model.AppError, *bytes.Buffer)
	SoftDeleteTeam(teamID string) *model.AppError
	Srv() *Server
	SubmitInteractiveDialog(c *request.Context, request model.SubmitDialogRequest) (*model.SubmitDialogResponse, *model.AppError)
	SwitchEmailToLdap(email, password, code, ldapLoginId, ldapPassword string) (string, *model.AppError)
	SwitchEmailToOAuth(w http.ResponseWriter, r *http.Request, email, password, code, service string) (string, *model.AppError)
	SwitchLdapToEmail(ldapPassword, code, email, newPassword string) (string, *model.AppError)
	SwitchOAuthToEmail(email, password, requesterId string) (string, *model.AppError)
	TeamMembersToRemove(teamID *string) ([]*model.TeamMember, *model.AppError)
	TelemetryId() string
	TestElasticsearch(cfg *model.Config) *model.AppError
	TestEmail(userID string, cfg *model.Config) *model.AppError
	TestFileStoreConnection() *model.AppError
	TestFileStoreConnectionWithConfig(cfg *model.FileSettings) *model.AppError
	TestLdap() *model.AppError
	TestSiteURL(siteURL string) *model.AppError
	Timezones() *timezones.Timezones
	ToggleMuteChannel(channelID, userID string) (*model.ChannelMember, *model.AppError)
	TotalWebsocketConnections() int
	TriggerWebhook(c *request.Context, payload *model.OutgoingWebhookPayload, hook *model.OutgoingWebhook, post *model.Post, channel *model.Channel)
	UnregisterPluginCommand(pluginID, teamID, trigger string)
	UpdateActive(c *request.Context, user *model.User, active bool) (*model.User, *model.AppError)
	UpdateChannelMemberNotifyProps(data map[string]string, channelID string, userID string) (*model.ChannelMember, *model.AppError)
	UpdateChannelMemberRoles(channelID string, userID string, newRoles string) (*model.ChannelMember, *model.AppError)
	UpdateChannelMemberSchemeRoles(channelID string, userID string, isSchemeGuest bool, isSchemeUser bool, isSchemeAdmin bool) (*model.ChannelMember, *model.AppError)
	UpdateChannelPrivacy(c *request.Context, oldChannel *model.Channel, user *model.User) (*model.Channel, *model.AppError)
	UpdateCommand(oldCmd, updatedCmd *model.Command) (*model.Command, *model.AppError)
	UpdateConfig(f func(*model.Config))
	UpdateEphemeralPost(userID string, post *model.Post) *model.Post
	UpdateExpiredDNDStatuses() ([]*model.Status, error)
	UpdateGroup(group *model.Group) (*model.Group, *model.AppError)
	UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError)
	UpdateHashedPassword(user *model.User, newHashedPassword string) *model.AppError
	UpdateHashedPasswordByUserId(userID, newHashedPassword string) *model.AppError
	UpdateIncomingWebhook(oldHook, updatedHook *model.IncomingWebhook) (*model.IncomingWebhook, *model.AppError)
	UpdateLastActivityAtIfNeeded(session model.Session)
	UpdateMfa(activate bool, userID, token string) *model.AppError
	UpdateMobileAppBadge(userID string)
	UpdateOAuthApp(oldApp, updatedApp *model.OAuthApp) (*model.OAuthApp, *model.AppError)
	UpdateOAuthUserAttrs(userData io.Reader, user *model.User, provider einterfaces.OAuthProvider, service string, tokenUser *model.User) *model.AppError
	UpdateOutgoingWebhook(oldHook, updatedHook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError)
	UpdatePassword(user *model.User, newPassword string) *model.AppError
	UpdatePasswordAsUser(userID, currentPassword, newPassword string) *model.AppError
	UpdatePasswordByUserIdSendEmail(userID, newPassword, method string) *model.AppError
	UpdatePasswordSendEmail(user *model.User, newPassword, method string) *model.AppError
	UpdatePost(c *request.Context, post *model.Post, safeUpdate bool) (*model.Post, *model.AppError)
	UpdatePreferences(userID string, preferences model.Preferences) *model.AppError
	UpdateRemoteCluster(rc *model.RemoteCluster) (*model.RemoteCluster, *model.AppError)
	UpdateRemoteClusterTopics(remoteClusterId string, topics string) (*model.RemoteCluster, *model.AppError)
	UpdateRole(role *model.Role) (*model.Role, *model.AppError)
	UpdateScheme(scheme *model.Scheme) (*model.Scheme, *model.AppError)
	UpdateSharedChannel(sc *model.SharedChannel) (*model.SharedChannel, error)
	UpdateSharedChannelRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error
	UpdateSidebarCategories(userID, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError)
	UpdateSidebarCategoryOrder(userID, teamID string, categoryOrder []string) *model.AppError
	UpdateTeam(team *model.Team) (*model.Team, *model.AppError)
	UpdateTeamMemberRoles(teamID string, userID string, newRoles string) (*model.TeamMember, *model.AppError)
	UpdateTeamMemberSchemeRoles(teamID string, userID string, isSchemeGuest bool, isSchemeUser bool, isSchemeAdmin bool) (*model.TeamMember, *model.AppError)
	UpdateTeamPrivacy(teamID string, teamType string, allowOpenInvite bool) *model.AppError
	UpdateTeamScheme(team *model.Team) (*model.Team, *model.AppError)
	UpdateThreadFollowForUser(userID, teamID, threadID string, state bool) *model.AppError
	UpdateThreadFollowForUserFromChannelAdd(userID, teamID, threadID string) *model.AppError
	UpdateThreadReadForUser(currentSessionId, userID, teamID, threadID string, timestamp int64) (*model.ThreadResponse, *model.AppError)
	UpdateThreadReadForUserByPost(currentSessionId, userID, teamID, threadID, postID string) (*model.ThreadResponse, *model.AppError)
	UpdateThreadsReadForUser(userID, teamID string) *model.AppError
	UpdateUser(user *model.User, sendNotifications bool) (*model.User, *model.AppError)
	UpdateUserActive(c *request.Context, userID string, active bool) *model.AppError
	UpdateUserAsUser(user *model.User, asAdmin bool) (*model.User, *model.AppError)
	UpdateUserAuth(userID string, userAuth *model.UserAuth) (*model.UserAuth, *model.AppError)
	UpdateUserRoles(userID string, newRoles string, sendWebSocketEvent bool) (*model.User, *model.AppError)
	UpdateUserRolesWithUser(user *model.User, newRoles string, sendWebSocketEvent bool) (*model.User, *model.AppError)
	UploadData(c *request.Context, us *model.UploadSession, rd io.Reader) (*model.FileInfo, *model.AppError)
	UploadEmojiImage(id string, imageData *multipart.FileHeader) *model.AppError
	UploadMultipartFiles(c *request.Context, teamID string, channelID string, userID string, fileHeaders []*multipart.FileHeader, clientIds []string, now time.Time) (*model.FileUploadResponse, *model.AppError)
	UpsertGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError)
	UpsertGroupMembers(groupID string, userIDs []string) ([]*model.GroupMember, *model.AppError)
	UpsertGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError)
	UserCanSeeOtherUser(userID string, otherUserId string) (bool, *model.AppError)
	VerifyEmailFromToken(userSuppliedTokenString string) *model.AppError
	VerifyUserEmail(userID, email string) *model.AppError
	ViewChannel(view *model.ChannelView, userID string, currentSessionId string, collapsedThreadsSupported bool) (map[string]int64, *model.AppError)
	WriteFile(fr io.Reader, path string) (int64, *model.AppError)
}
