// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Fusion Applications Environment Management API
//
// Use the Fusion Applications Environment Management API to manage the environments where your Fusion Applications run. For more information, see the Fusion Applications Environment Management documentation (https://docs.oracle.com/iaas/Content/fusion-applications/home.htm).
//

package fusionapps

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// Capabilities Status of capabilities that can be enabled for an environment family.
type Capabilities struct {

	// Indicates whether data masking is enabled for the environment family. When enabled, data masking activities are supported.
	IsDataMaskingEnabled *bool `mandatory:"false" json:"isDataMaskingEnabled"`

	// Indicates whether Break Glass is enabled for the environment family.
	IsBreakGlassEnabled *bool `mandatory:"false" json:"isBreakGlassEnabled"`

	// Indicates whether customers can use their own encryption keys.
	IsByokEnabled *bool `mandatory:"false" json:"isByokEnabled"`
}

func (m Capabilities) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m Capabilities) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
