// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostAgentScanResultProblem A problem found in a host agent scan
type HostAgentScanResultProblem struct {

	// Name of the problem
	Name *string `mandatory:"true" json:"name"`

	// Problem severity
	Severity ScanResultProblemSeverityEnum `mandatory:"true" json:"severity"`

	// Problem description
	Description *string `mandatory:"false" json:"description"`

	// State of the vulnerability
	State ScanResultVulnerabilityStateEnum `mandatory:"false" json:"state,omitempty"`

	// Reference to problem MITRE CVE ID
	CveReference *string `mandatory:"false" json:"cveReference"`

	// Reference to problem issue ID
	IssueId *int `mandatory:"false" json:"issueId"`

	// Date of scan result that first reported the vulnerability
	TimeFirstDetected *common.SDKTime `mandatory:"false" json:"timeFirstDetected"`

	// Date of scan result that most recently reported the vulnerability
	TimeLastDetected *common.SDKTime `mandatory:"false" json:"timeLastDetected"`

	// Packages in which the problem is detected
	VulnerablePackages []ModelPackage `mandatory:"false" json:"vulnerablePackages"`
}

func (m HostAgentScanResultProblem) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostAgentScanResultProblem) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingScanResultProblemSeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetScanResultProblemSeverityEnumStringValues(), ",")))
	}

	if _, ok := GetMappingScanResultVulnerabilityStateEnum(string(m.State)); !ok && m.State != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for State: %s. Supported values are: %s.", m.State, strings.Join(GetScanResultVulnerabilityStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
