// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle Cloud VMware Solution API
//
// Use the Oracle Cloud VMware API to create SDDCs and manage ESXi hosts and software.
// For more information, see Oracle Cloud VMware Solution (https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/ocvsoverview.htm).
//

package ocvp

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// SddcPassword SDDC vCenter/NSX/HCX password.
type SddcPassword struct {

	// SDDC password type.
	PasswordType PasswordTypesEnum `mandatory:"true" json:"passwordType"`

	// SDDC vCenter/NSX/HCX password context.
	Value *string `mandatory:"true" json:"value"`
}

func (m SddcPassword) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m SddcPassword) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingPasswordTypesEnum(string(m.PasswordType)); !ok && m.PasswordType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for PasswordType: %s. Supported values are: %s.", m.PasswordType, strings.Join(GetPasswordTypesEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
