// Code generated by yy. DO NOT EDIT.

// Copyright 2017 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc

import (
	"fmt"
	"go/token"
	"modernc.org/xc"
)

// AbstractDeclaratorCase represents case numbers of production AbstractDeclarator
type AbstractDeclaratorCase int

// Values of type AbstractDeclaratorCase
const (
	AbstractDeclaratorPointer AbstractDeclaratorCase = iota
	AbstractDeclaratorAbstract
)

// String implements fmt.Stringer
func (n AbstractDeclaratorCase) String() string {
	switch n {
	case AbstractDeclaratorPointer:
		return "AbstractDeclaratorPointer"
	case AbstractDeclaratorAbstract:
		return "AbstractDeclaratorAbstract"
	default:
		return fmt.Sprintf("AbstractDeclaratorCase(%v)", int(n))
	}
}

// AbstractDeclarator represents data reduced by productions:
//
//	AbstractDeclarator:
//	        Pointer                              // Case AbstractDeclaratorPointer
//	|       PointerOpt DirectAbstractDeclarator  // Case AbstractDeclaratorAbstract
type AbstractDeclarator struct {
	DeclarationSpecifier     *DeclarationSpecifier
	Type                     Type
	TypeQualifiers           []*TypeQualifier // From the PointerOpt production, if any.
	Case                     AbstractDeclaratorCase
	DirectAbstractDeclarator *DirectAbstractDeclarator
	Pointer                  *Pointer
	PointerOpt               *PointerOpt
}

func (n *AbstractDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AbstractDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AbstractDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Pointer.Pos()
	case 1:
		if p := n.PointerOpt.Pos(); p != 0 {
			return p
		}

		return n.DirectAbstractDeclarator.Pos()
	default:
		panic("internal error")
	}
}

// AbstractDeclaratorOpt represents data reduced by productions:
//
//	AbstractDeclaratorOpt:
//	        /* empty */         // Case 0
//	|       AbstractDeclarator  // Case 1
type AbstractDeclaratorOpt struct {
	AbstractDeclarator *AbstractDeclarator
}

func (n *AbstractDeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AbstractDeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AbstractDeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.AbstractDeclarator.Pos()
}

// ArgumentExprList represents data reduced by productions:
//
//	ArgumentExprList:
//	        Expr                       // Case 0
//	|       ArgumentExprList ',' Expr  // Case 1
type ArgumentExprList struct {
	ArgumentExprList *ArgumentExprList
	Case             int
	Expr             *Expr
	Token            xc.Token
}

func (n *ArgumentExprList) reverse() *ArgumentExprList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ArgumentExprList
	for nb != nil {
		nc := nb.ArgumentExprList
		nb.ArgumentExprList = na
		na = nb
		nb = nc
	}
	n.ArgumentExprList = nil
	return na
}

func (n *ArgumentExprList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ArgumentExprList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ArgumentExprList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.ArgumentExprList.Pos()
	case 0:
		return n.Expr.Pos()
	default:
		panic("internal error")
	}
}

// ArgumentExprListOpt represents data reduced by productions:
//
//	ArgumentExprListOpt:
//	        /* empty */       // Case 0
//	|       ArgumentExprList  // Case 1
type ArgumentExprListOpt struct {
	ArgumentExprList *ArgumentExprList
}

func (n *ArgumentExprListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ArgumentExprListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ArgumentExprListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ArgumentExprList.Pos()
}

// BlockItemCase represents case numbers of production BlockItem
type BlockItemCase int

// Values of type BlockItemCase
const (
	BlockItemDecl BlockItemCase = iota
	BlockItemStmt
)

// String implements fmt.Stringer
func (n BlockItemCase) String() string {
	switch n {
	case BlockItemDecl:
		return "BlockItemDecl"
	case BlockItemStmt:
		return "BlockItemStmt"
	default:
		return fmt.Sprintf("BlockItemCase(%v)", int(n))
	}
}

// BlockItem represents data reduced by productions:
//
//	BlockItem:
//	        Declaration  // Case BlockItemDecl
//	|       Stmt         // Case BlockItemStmt
type BlockItem struct {
	Case        BlockItemCase
	Declaration *Declaration
	Stmt        *Stmt
}

func (n *BlockItem) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *BlockItem) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItem) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declaration.Pos()
	case 1:
		return n.Stmt.Pos()
	default:
		panic("internal error")
	}
}

// BlockItemList represents data reduced by productions:
//
//	BlockItemList:
//	        BlockItem                // Case 0
//	|       BlockItemList BlockItem  // Case 1
type BlockItemList struct {
	BlockItem     *BlockItem
	BlockItemList *BlockItemList
	Case          int
}

func (n *BlockItemList) reverse() *BlockItemList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.BlockItemList
	for nb != nil {
		nc := nb.BlockItemList
		nb.BlockItemList = na
		na = nb
		nb = nc
	}
	n.BlockItemList = nil
	return na
}

func (n *BlockItemList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *BlockItemList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItemList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.BlockItem.Pos()
	case 1:
		return n.BlockItemList.Pos()
	default:
		panic("internal error")
	}
}

// BlockItemListOpt represents data reduced by productions:
//
//	BlockItemListOpt:
//	        /* empty */    // Case 0
//	|       BlockItemList  // Case 1
type BlockItemListOpt struct {
	BlockItemList *BlockItemList
}

func (n *BlockItemListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *BlockItemListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItemListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.BlockItemList.Pos()
}

// CommaOpt represents data reduced by productions:
//
//	CommaOpt:
//	        /* empty */  // Case 0
//	|       ','          // Case 1
type CommaOpt struct {
	Token xc.Token
}

func (n *CommaOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *CommaOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *CommaOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// CompoundStmt represents data reduced by production:
//
//	CompoundStmt:
//	        '{' BlockItemListOpt '}'  // Case 0
type CompoundStmt struct {
	scope            *Scope
	BlockItemListOpt *BlockItemListOpt
	Token            xc.Token
	Token2           xc.Token
}

func (n *CompoundStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *CompoundStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *CompoundStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ConstExpr represents data reduced by production:
//
//	ConstExpr:
//	        Expr  // Case 0
type ConstExpr struct {
	Operand Operand
	Expr    *Expr
}

func (n *ConstExpr) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ConstExpr) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ConstExpr) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Expr.Pos()
}

// Declaration represents data reduced by production:
//
//	Declaration:
//	        DeclarationSpecifiers InitDeclaratorListOpt ';'  // Case 0
type Declaration struct {
	Attributes            [][]xc.Token
	Scope                 *Scope
	DeclarationSpecifiers *DeclarationSpecifiers
	InitDeclaratorListOpt *InitDeclaratorListOpt
	Token                 xc.Token
}

func (n *Declaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Declaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Declaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationSpecifiers.Pos()
}

// DeclarationList represents data reduced by productions:
//
//	DeclarationList:
//	        Declaration                  // Case 0
//	|       DeclarationList Declaration  // Case 1
type DeclarationList struct {
	Case            int
	Declaration     *Declaration
	DeclarationList *DeclarationList
}

func (n *DeclarationList) reverse() *DeclarationList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.DeclarationList
	for nb != nil {
		nc := nb.DeclarationList
		nb.DeclarationList = na
		na = nb
		nb = nc
	}
	n.DeclarationList = nil
	return na
}

func (n *DeclarationList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *DeclarationList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declaration.Pos()
	case 1:
		return n.DeclarationList.Pos()
	default:
		panic("internal error")
	}
}

// DeclarationListOpt represents data reduced by productions:
//
//	DeclarationListOpt:
//	        /* empty */      // Case 0
//	|       DeclarationList  // Case 1
type DeclarationListOpt struct {
	DeclarationList *DeclarationList
}

func (n *DeclarationListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationList.Pos()
}

// DeclarationSpecifiersCase represents case numbers of production DeclarationSpecifiers
type DeclarationSpecifiersCase int

// Values of type DeclarationSpecifiersCase
const (
	DeclarationSpecifiersFunc DeclarationSpecifiersCase = iota
	DeclarationSpecifiersStorage
	DeclarationSpecifiersQualifier
	DeclarationSpecifiersSpecifier
)

// String implements fmt.Stringer
func (n DeclarationSpecifiersCase) String() string {
	switch n {
	case DeclarationSpecifiersFunc:
		return "DeclarationSpecifiersFunc"
	case DeclarationSpecifiersStorage:
		return "DeclarationSpecifiersStorage"
	case DeclarationSpecifiersQualifier:
		return "DeclarationSpecifiersQualifier"
	case DeclarationSpecifiersSpecifier:
		return "DeclarationSpecifiersSpecifier"
	default:
		return fmt.Sprintf("DeclarationSpecifiersCase(%v)", int(n))
	}
}

// DeclarationSpecifiers represents data reduced by productions:
//
//	DeclarationSpecifiers:
//	        FunctionSpecifier DeclarationSpecifiersOpt      // Case DeclarationSpecifiersFunc
//	|       StorageClassSpecifier DeclarationSpecifiersOpt  // Case DeclarationSpecifiersStorage
//	|       TypeQualifier DeclarationSpecifiersOpt          // Case DeclarationSpecifiersQualifier
//	|       TypeSpecifier DeclarationSpecifiersOpt          // Case DeclarationSpecifiersSpecifier
type DeclarationSpecifiers struct {
	Case                     DeclarationSpecifiersCase
	DeclarationSpecifiersOpt *DeclarationSpecifiersOpt
	FunctionSpecifier        *FunctionSpecifier
	StorageClassSpecifier    *StorageClassSpecifier
	TypeQualifier            *TypeQualifier
	TypeSpecifier            *TypeSpecifier
}

func (n *DeclarationSpecifiers) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationSpecifiers) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationSpecifiers) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.FunctionSpecifier.Pos()
	case 1:
		return n.StorageClassSpecifier.Pos()
	case 2:
		return n.TypeQualifier.Pos()
	case 3:
		return n.TypeSpecifier.Pos()
	default:
		panic("internal error")
	}
}

// DeclarationSpecifiersOpt represents data reduced by productions:
//
//	DeclarationSpecifiersOpt:
//	        /* empty */            // Case 0
//	|       DeclarationSpecifiers  // Case 1
type DeclarationSpecifiersOpt struct {
	DeclarationSpecifiers *DeclarationSpecifiers
}

func (n *DeclarationSpecifiersOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationSpecifiersOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationSpecifiersOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationSpecifiers.Pos()
}

// Declarator represents data reduced by production:
//
//	Declarator:
//	        PointerOpt DirectDeclarator  // Case 0
type Declarator struct {
	AssignedTo           int // Declarator appears at the left side of assignment.
	Attributes           [][]xc.Token
	Bits                 int                   // StructDeclarator: bit width when a bit field.
	DeclarationSpecifier *DeclarationSpecifier // Nil for embedded declarators.
	Definition           *Declarator           // Declaration -> definition.
	Field                int                   // Declaration order# if struct field declarator.
	FunctionDefinition   *FunctionDefinition   // When the declarator defines a function.
	Initializer          *Initializer          // Only when part of an InitDeclarator.
	Linkage              Linkage               // Linkage of the declared name, [0]6.2.2.
	Parameters           []*Declarator         // Of the function declarator.
	Referenced           int
	Scope                *Scope           // Declaration scope.
	ScopeNum             int              // Sequential scope number within function body.
	StorageDuration      StorageDuration  // Storage duration of the declared name, [0]6.2.4.
	Type                 Type             // Declared type.
	TypeQualifiers       []*TypeQualifier // From the PointerOpt production, if any.
	unnamed              int
	vars                 []*Declarator // Function declarator only.
	AddressTaken         bool
	Alloca               bool // Function declarator: Body calls __builtin_alloca
	Embedded             bool // [0]6.7.5-3: Not a full declarator.
	IsField              bool
	IsFunctionParameter  bool
	IsBuiltin            bool
	DirectDeclarator     *DirectDeclarator
	PointerOpt           *PointerOpt
}

func (n *Declarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Declarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Declarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	if p := n.PointerOpt.Pos(); p != 0 {
		return p
	}

	return n.DirectDeclarator.Pos()
}

// DeclaratorOpt represents data reduced by productions:
//
//	DeclaratorOpt:
//	        /* empty */  // Case 0
//	|       Declarator   // Case 1
type DeclaratorOpt struct {
	Declarator *Declarator
}

func (n *DeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Declarator.Pos()
}

// Designation represents data reduced by production:
//
//	Designation:
//	        DesignatorList '='  // Case 0
type Designation struct {
	List           []int64
	DesignatorList *DesignatorList
	Token          xc.Token
}

func (n *Designation) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Designation) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Designation) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DesignatorList.Pos()
}

// DesignatorCase represents case numbers of production Designator
type DesignatorCase int

// Values of type DesignatorCase
const (
	DesignatorField DesignatorCase = iota
	DesignatorIndex
)

// String implements fmt.Stringer
func (n DesignatorCase) String() string {
	switch n {
	case DesignatorField:
		return "DesignatorField"
	case DesignatorIndex:
		return "DesignatorIndex"
	default:
		return fmt.Sprintf("DesignatorCase(%v)", int(n))
	}
}

// Designator represents data reduced by productions:
//
//	Designator:
//	        '.' IDENTIFIER     // Case DesignatorField
//	|       '[' ConstExpr ']'  // Case DesignatorIndex
type Designator struct {
	Case      DesignatorCase
	ConstExpr *ConstExpr
	Token     xc.Token
	Token2    xc.Token
}

func (n *Designator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Designator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Designator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// DesignatorList represents data reduced by productions:
//
//	DesignatorList:
//	        Designator                 // Case 0
//	|       DesignatorList Designator  // Case 1
type DesignatorList struct {
	Case           int
	Designator     *Designator
	DesignatorList *DesignatorList
}

func (n *DesignatorList) reverse() *DesignatorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.DesignatorList
	for nb != nil {
		nc := nb.DesignatorList
		nb.DesignatorList = na
		na = nb
		nb = nc
	}
	n.DesignatorList = nil
	return na
}

func (n *DesignatorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *DesignatorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DesignatorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Designator.Pos()
	case 1:
		return n.DesignatorList.Pos()
	default:
		panic("internal error")
	}
}

// DirectAbstractDeclaratorCase represents case numbers of production DirectAbstractDeclarator
type DirectAbstractDeclaratorCase int

// Values of type DirectAbstractDeclaratorCase
const (
	DirectAbstractDeclaratorAbstract DirectAbstractDeclaratorCase = iota
	DirectAbstractDeclaratorParamList
	DirectAbstractDeclaratorDFn
	DirectAbstractDeclaratorDArrSize
	DirectAbstractDeclaratorDArrVL
	DirectAbstractDeclaratorDArr
	DirectAbstractDeclaratorDArrSize2
	DirectAbstractDeclaratorDArr2
)

// String implements fmt.Stringer
func (n DirectAbstractDeclaratorCase) String() string {
	switch n {
	case DirectAbstractDeclaratorAbstract:
		return "DirectAbstractDeclaratorAbstract"
	case DirectAbstractDeclaratorParamList:
		return "DirectAbstractDeclaratorParamList"
	case DirectAbstractDeclaratorDFn:
		return "DirectAbstractDeclaratorDFn"
	case DirectAbstractDeclaratorDArrSize:
		return "DirectAbstractDeclaratorDArrSize"
	case DirectAbstractDeclaratorDArrVL:
		return "DirectAbstractDeclaratorDArrVL"
	case DirectAbstractDeclaratorDArr:
		return "DirectAbstractDeclaratorDArr"
	case DirectAbstractDeclaratorDArrSize2:
		return "DirectAbstractDeclaratorDArrSize2"
	case DirectAbstractDeclaratorDArr2:
		return "DirectAbstractDeclaratorDArr2"
	default:
		return fmt.Sprintf("DirectAbstractDeclaratorCase(%v)", int(n))
	}
}

// DirectAbstractDeclarator represents data reduced by productions:
//
//	DirectAbstractDeclarator:
//	        '(' AbstractDeclarator ')'                                              // Case DirectAbstractDeclaratorAbstract
//	|       '(' ParameterTypeListOpt ')'                                            // Case DirectAbstractDeclaratorParamList
//	|       DirectAbstractDeclarator '(' ParameterTypeListOpt ')'                   // Case DirectAbstractDeclaratorDFn
//	|       DirectAbstractDeclaratorOpt '[' "static" TypeQualifierListOpt Expr ']'  // Case DirectAbstractDeclaratorDArrSize
//	|       DirectAbstractDeclaratorOpt '[' '*' ']'                                 // Case DirectAbstractDeclaratorDArrVL
//	|       DirectAbstractDeclaratorOpt '[' ExprOpt ']'                             // Case DirectAbstractDeclaratorDArr
//	|       DirectAbstractDeclaratorOpt '[' TypeQualifierList "static" Expr ']'     // Case DirectAbstractDeclaratorDArrSize2
//	|       DirectAbstractDeclaratorOpt '[' TypeQualifierList ExprOpt ']'           // Case DirectAbstractDeclaratorDArr2
type DirectAbstractDeclarator struct {
	AbstractDeclarator          *AbstractDeclarator
	Case                        DirectAbstractDeclaratorCase
	DirectAbstractDeclarator    *DirectAbstractDeclarator
	DirectAbstractDeclaratorOpt *DirectAbstractDeclaratorOpt
	Expr                        *Expr
	ExprOpt                     *ExprOpt
	ParameterTypeListOpt        *ParameterTypeListOpt
	Token                       xc.Token
	Token2                      xc.Token
	Token3                      xc.Token
	TypeQualifierList           *TypeQualifierList
	TypeQualifierListOpt        *TypeQualifierListOpt
}

func (n *DirectAbstractDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectAbstractDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectAbstractDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 2:
		return n.DirectAbstractDeclarator.Pos()
	case 3, 4, 5, 6, 7:
		if p := n.DirectAbstractDeclaratorOpt.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	case 0, 1:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// DirectAbstractDeclaratorOpt represents data reduced by productions:
//
//	DirectAbstractDeclaratorOpt:
//	        /* empty */               // Case 0
//	|       DirectAbstractDeclarator  // Case 1
type DirectAbstractDeclaratorOpt struct {
	DirectAbstractDeclarator *DirectAbstractDeclarator
}

func (n *DirectAbstractDeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectAbstractDeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectAbstractDeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DirectAbstractDeclarator.Pos()
}

// DirectDeclaratorCase represents case numbers of production DirectDeclarator
type DirectDeclaratorCase int

// Values of type DirectDeclaratorCase
const (
	DirectDeclaratorParen DirectDeclaratorCase = iota
	DirectDeclaratorIdentList
	DirectDeclaratorParamList
	DirectDeclaratorArraySize
	DirectDeclaratorArraySize2
	DirectDeclaratorArrayVar
	DirectDeclaratorArray
	DirectDeclaratorIdent
)

// String implements fmt.Stringer
func (n DirectDeclaratorCase) String() string {
	switch n {
	case DirectDeclaratorParen:
		return "DirectDeclaratorParen"
	case DirectDeclaratorIdentList:
		return "DirectDeclaratorIdentList"
	case DirectDeclaratorParamList:
		return "DirectDeclaratorParamList"
	case DirectDeclaratorArraySize:
		return "DirectDeclaratorArraySize"
	case DirectDeclaratorArraySize2:
		return "DirectDeclaratorArraySize2"
	case DirectDeclaratorArrayVar:
		return "DirectDeclaratorArrayVar"
	case DirectDeclaratorArray:
		return "DirectDeclaratorArray"
	case DirectDeclaratorIdent:
		return "DirectDeclaratorIdent"
	default:
		return fmt.Sprintf("DirectDeclaratorCase(%v)", int(n))
	}
}

// DirectDeclarator represents data reduced by productions:
//
//	DirectDeclarator:
//	        '(' Declarator ')'                                           // Case DirectDeclaratorParen
//	|       DirectDeclarator '(' IdentifierListOpt ')'                   // Case DirectDeclaratorIdentList
//	|       DirectDeclarator '(' ParameterTypeList ')'                   // Case DirectDeclaratorParamList
//	|       DirectDeclarator '[' "static" TypeQualifierListOpt Expr ']'  // Case DirectDeclaratorArraySize
//	|       DirectDeclarator '[' TypeQualifierList "static" Expr ']'     // Case DirectDeclaratorArraySize2
//	|       DirectDeclarator '[' TypeQualifierListOpt '*' ']'            // Case DirectDeclaratorArrayVar
//	|       DirectDeclarator '[' TypeQualifierListOpt ExprOpt ']'        // Case DirectDeclaratorArray
//	|       IDENTIFIER                                                   // Case DirectDeclaratorIdent
type DirectDeclarator struct {
	paramScope           *Scope
	Case                 DirectDeclaratorCase
	Declarator           *Declarator
	DirectDeclarator     *DirectDeclarator
	Expr                 *Expr
	ExprOpt              *ExprOpt
	IdentifierListOpt    *IdentifierListOpt
	ParameterTypeList    *ParameterTypeList
	Token                xc.Token
	Token2               xc.Token
	Token3               xc.Token
	TypeQualifierList    *TypeQualifierList
	TypeQualifierListOpt *TypeQualifierListOpt
}

func (n *DirectDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1, 2, 3, 4, 5, 6:
		return n.DirectDeclarator.Pos()
	case 0, 7:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// EnumSpecifierCase represents case numbers of production EnumSpecifier
type EnumSpecifierCase int

// Values of type EnumSpecifierCase
const (
	EnumSpecifierTag EnumSpecifierCase = iota
	EnumSpecifierDefine
)

// String implements fmt.Stringer
func (n EnumSpecifierCase) String() string {
	switch n {
	case EnumSpecifierTag:
		return "EnumSpecifierTag"
	case EnumSpecifierDefine:
		return "EnumSpecifierDefine"
	default:
		return fmt.Sprintf("EnumSpecifierCase(%v)", int(n))
	}
}

// EnumSpecifier represents data reduced by productions:
//
//	EnumSpecifier:
//	        "enum" IDENTIFIER                                     // Case EnumSpecifierTag
//	|       "enum" IdentifierOpt '{' EnumeratorList CommaOpt '}'  // Case EnumSpecifierDefine
type EnumSpecifier struct {
	Tag            int
	scope          *Scope // Where to declare enumeration constants.
	typ            Type
	Case           EnumSpecifierCase
	CommaOpt       *CommaOpt
	EnumeratorList *EnumeratorList
	IdentifierOpt  *IdentifierOpt
	Token          xc.Token
	Token2         xc.Token
	Token3         xc.Token
}

func (n *EnumSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *EnumSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// EnumerationConstant represents data reduced by production:
//
//	EnumerationConstant:
//	        IDENTIFIER  // Case 0
type EnumerationConstant struct {
	Operand Operand
	Token   xc.Token
}

func (n *EnumerationConstant) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *EnumerationConstant) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumerationConstant) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// EnumeratorCase represents case numbers of production Enumerator
type EnumeratorCase int

// Values of type EnumeratorCase
const (
	EnumeratorBase EnumeratorCase = iota
	EnumeratorInit
)

// String implements fmt.Stringer
func (n EnumeratorCase) String() string {
	switch n {
	case EnumeratorBase:
		return "EnumeratorBase"
	case EnumeratorInit:
		return "EnumeratorInit"
	default:
		return fmt.Sprintf("EnumeratorCase(%v)", int(n))
	}
}

// Enumerator represents data reduced by productions:
//
//	Enumerator:
//	        EnumerationConstant                // Case EnumeratorBase
//	|       EnumerationConstant '=' ConstExpr  // Case EnumeratorInit
type Enumerator struct {
	Case                EnumeratorCase
	ConstExpr           *ConstExpr
	EnumerationConstant *EnumerationConstant
	Token               xc.Token
}

func (n *Enumerator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Enumerator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Enumerator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.EnumerationConstant.Pos()
}

// EnumeratorList represents data reduced by productions:
//
//	EnumeratorList:
//	        Enumerator                     // Case 0
//	|       EnumeratorList ',' Enumerator  // Case 1
type EnumeratorList struct {
	Case           int
	Enumerator     *Enumerator
	EnumeratorList *EnumeratorList
	Token          xc.Token
}

func (n *EnumeratorList) reverse() *EnumeratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.EnumeratorList
	for nb != nil {
		nc := nb.EnumeratorList
		nb.EnumeratorList = na
		na = nb
		nb = nc
	}
	n.EnumeratorList = nil
	return na
}

func (n *EnumeratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *EnumeratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumeratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Enumerator.Pos()
	case 1:
		return n.EnumeratorList.Pos()
	default:
		panic("internal error")
	}
}

// ExprCase represents case numbers of production Expr
type ExprCase int

// Values of type ExprCase
const (
	ExprPreInc ExprCase = iota
	ExprPreDec
	ExprAlignofType
	ExprAlignofExpr
	ExprSizeofType
	ExprSizeofExpr
	ExprNot
	ExprAddrof
	ExprStatement
	ExprPExprList
	ExprCompLit
	ExprCast
	ExprDeref
	ExprUnaryPlus
	ExprUnaryMinus
	ExprCpl
	ExprChar
	ExprNe
	ExprModAssign
	ExprLAnd
	ExprAndAssign
	ExprMulAssign
	ExprPostInc
	ExprAddAssign
	ExprPostDec
	ExprSubAssign
	ExprPSelect
	ExprDivAssign
	ExprLsh
	ExprLshAssign
	ExprLe
	ExprEq
	ExprGe
	ExprRsh
	ExprRshAssign
	ExprXorAssign
	ExprOrAssign
	ExprLOr
	ExprMod
	ExprAnd
	ExprCall
	ExprMul
	ExprAdd
	ExprSub
	ExprSelect
	ExprDiv
	ExprLt
	ExprAssign
	ExprGt
	ExprCond
	ExprIndex
	ExprXor
	ExprOr
	ExprFloat
	ExprIdent
	ExprInt
	ExprLChar
	ExprLString
	ExprString
)

// String implements fmt.Stringer
func (n ExprCase) String() string {
	switch n {
	case ExprPreInc:
		return "ExprPreInc"
	case ExprPreDec:
		return "ExprPreDec"
	case ExprAlignofType:
		return "ExprAlignofType"
	case ExprAlignofExpr:
		return "ExprAlignofExpr"
	case ExprSizeofType:
		return "ExprSizeofType"
	case ExprSizeofExpr:
		return "ExprSizeofExpr"
	case ExprNot:
		return "ExprNot"
	case ExprAddrof:
		return "ExprAddrof"
	case ExprStatement:
		return "ExprStatement"
	case ExprPExprList:
		return "ExprPExprList"
	case ExprCompLit:
		return "ExprCompLit"
	case ExprCast:
		return "ExprCast"
	case ExprDeref:
		return "ExprDeref"
	case ExprUnaryPlus:
		return "ExprUnaryPlus"
	case ExprUnaryMinus:
		return "ExprUnaryMinus"
	case ExprCpl:
		return "ExprCpl"
	case ExprChar:
		return "ExprChar"
	case ExprNe:
		return "ExprNe"
	case ExprModAssign:
		return "ExprModAssign"
	case ExprLAnd:
		return "ExprLAnd"
	case ExprAndAssign:
		return "ExprAndAssign"
	case ExprMulAssign:
		return "ExprMulAssign"
	case ExprPostInc:
		return "ExprPostInc"
	case ExprAddAssign:
		return "ExprAddAssign"
	case ExprPostDec:
		return "ExprPostDec"
	case ExprSubAssign:
		return "ExprSubAssign"
	case ExprPSelect:
		return "ExprPSelect"
	case ExprDivAssign:
		return "ExprDivAssign"
	case ExprLsh:
		return "ExprLsh"
	case ExprLshAssign:
		return "ExprLshAssign"
	case ExprLe:
		return "ExprLe"
	case ExprEq:
		return "ExprEq"
	case ExprGe:
		return "ExprGe"
	case ExprRsh:
		return "ExprRsh"
	case ExprRshAssign:
		return "ExprRshAssign"
	case ExprXorAssign:
		return "ExprXorAssign"
	case ExprOrAssign:
		return "ExprOrAssign"
	case ExprLOr:
		return "ExprLOr"
	case ExprMod:
		return "ExprMod"
	case ExprAnd:
		return "ExprAnd"
	case ExprCall:
		return "ExprCall"
	case ExprMul:
		return "ExprMul"
	case ExprAdd:
		return "ExprAdd"
	case ExprSub:
		return "ExprSub"
	case ExprSelect:
		return "ExprSelect"
	case ExprDiv:
		return "ExprDiv"
	case ExprLt:
		return "ExprLt"
	case ExprAssign:
		return "ExprAssign"
	case ExprGt:
		return "ExprGt"
	case ExprCond:
		return "ExprCond"
	case ExprIndex:
		return "ExprIndex"
	case ExprXor:
		return "ExprXor"
	case ExprOr:
		return "ExprOr"
	case ExprFloat:
		return "ExprFloat"
	case ExprIdent:
		return "ExprIdent"
	case ExprInt:
		return "ExprInt"
	case ExprLChar:
		return "ExprLChar"
	case ExprLString:
		return "ExprLString"
	case ExprString:
		return "ExprString"
	default:
		return fmt.Sprintf("ExprCase(%v)", int(n))
	}
}

// Expr represents data reduced by productions:
//
//	Expr:
//	        "++" Expr                                          // Case ExprPreInc
//	|       "--" Expr                                          // Case ExprPreDec
//	|       "__alignof__" '(' TypeName ')'                     // Case ExprAlignofType
//	|       "__alignof__" Expr                                 // Case ExprAlignofExpr
//	|       "sizeof" '(' TypeName ')'                          // Case ExprSizeofType
//	|       "sizeof" Expr                                      // Case ExprSizeofExpr
//	|       '!' Expr                                           // Case ExprNot
//	|       '&' Expr                                           // Case ExprAddrof
//	|       '(' CompoundStmt ')'                               // Case ExprStatement
//	|       '(' ExprList ')'                                   // Case ExprPExprList
//	|       '(' TypeName ')' '{' InitializerList CommaOpt '}'  // Case ExprCompLit
//	|       '(' TypeName ')' Expr                              // Case ExprCast
//	|       '*' Expr                                           // Case ExprDeref
//	|       '+' Expr                                           // Case ExprUnaryPlus
//	|       '-' Expr                                           // Case ExprUnaryMinus
//	|       '~' Expr                                           // Case ExprCpl
//	|       CHARCONST                                          // Case ExprChar
//	|       Expr "!=" Expr                                     // Case ExprNe
//	|       Expr "%=" Expr                                     // Case ExprModAssign
//	|       Expr "&&" Expr                                     // Case ExprLAnd
//	|       Expr "&=" Expr                                     // Case ExprAndAssign
//	|       Expr "*=" Expr                                     // Case ExprMulAssign
//	|       Expr "++"                                          // Case ExprPostInc
//	|       Expr "+=" Expr                                     // Case ExprAddAssign
//	|       Expr "--"                                          // Case ExprPostDec
//	|       Expr "-=" Expr                                     // Case ExprSubAssign
//	|       Expr "->" IDENTIFIER                               // Case ExprPSelect
//	|       Expr "/=" Expr                                     // Case ExprDivAssign
//	|       Expr "<<" Expr                                     // Case ExprLsh
//	|       Expr "<<=" Expr                                    // Case ExprLshAssign
//	|       Expr "<=" Expr                                     // Case ExprLe
//	|       Expr "==" Expr                                     // Case ExprEq
//	|       Expr ">=" Expr                                     // Case ExprGe
//	|       Expr ">>" Expr                                     // Case ExprRsh
//	|       Expr ">>=" Expr                                    // Case ExprRshAssign
//	|       Expr "^=" Expr                                     // Case ExprXorAssign
//	|       Expr "|=" Expr                                     // Case ExprOrAssign
//	|       Expr "||" Expr                                     // Case ExprLOr
//	|       Expr '%' Expr                                      // Case ExprMod
//	|       Expr '&' Expr                                      // Case ExprAnd
//	|       Expr '(' ArgumentExprListOpt ')'                   // Case ExprCall
//	|       Expr '*' Expr                                      // Case ExprMul
//	|       Expr '+' Expr                                      // Case ExprAdd
//	|       Expr '-' Expr                                      // Case ExprSub
//	|       Expr '.' IDENTIFIER                                // Case ExprSelect
//	|       Expr '/' Expr                                      // Case ExprDiv
//	|       Expr '<' Expr                                      // Case ExprLt
//	|       Expr '=' Expr                                      // Case ExprAssign
//	|       Expr '>' Expr                                      // Case ExprGt
//	|       Expr '?' ExprList ':' Expr                         // Case ExprCond
//	|       Expr '[' ExprList ']'                              // Case ExprIndex
//	|       Expr '^' Expr                                      // Case ExprXor
//	|       Expr '|' Expr                                      // Case ExprOr
//	|       FLOATCONST                                         // Case ExprFloat
//	|       IDENTIFIER                                         // Case ExprIdent
//	|       INTCONST                                           // Case ExprInt
//	|       LONGCHARCONST                                      // Case ExprLChar
//	|       LONGSTRINGLITERAL                                  // Case ExprLString
//	|       STRINGLITERAL                                      // Case ExprString
type Expr struct {
	CallArgs            []Operand   // Promoted arguments of Call.
	Declarator          *Declarator // Case Ident.
	Operand             Operand
	Scope               *Scope // Case Ident, CompLit.
	enum                *EnumType
	AssignedTo          bool // Expression appears at the left side of assignment.
	ArgumentExprListOpt *ArgumentExprListOpt
	Case                ExprCase
	CommaOpt            *CommaOpt
	CompoundStmt        *CompoundStmt
	Expr                *Expr
	Expr2               *Expr
	ExprList            *ExprList
	InitializerList     *InitializerList
	Token               xc.Token
	Token2              xc.Token
	Token3              xc.Token
	Token4              xc.Token
	TypeName            *TypeName
}

func (n *Expr) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Expr) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Expr) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52:
		return n.Expr.Pos()
	case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 53, 54, 55, 56, 57, 58:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// ExprList represents data reduced by productions:
//
//	ExprList:
//	        Expr               // Case 0
//	|       ExprList ',' Expr  // Case 1
type ExprList struct {
	Operand  Operand
	Case     int
	Expr     *Expr
	ExprList *ExprList
	Token    xc.Token
}

func (n *ExprList) reverse() *ExprList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ExprList
	for nb != nil {
		nc := nb.ExprList
		nb.ExprList = na
		na = nb
		nb = nc
	}
	n.ExprList = nil
	return na
}

func (n *ExprList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ExprList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExprList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Expr.Pos()
	case 1:
		return n.ExprList.Pos()
	default:
		panic("internal error")
	}
}

// ExprListOpt represents data reduced by productions:
//
//	ExprListOpt:
//	        /* empty */  // Case 0
//	|       ExprList     // Case 1
type ExprListOpt struct {
	ExprList *ExprList
}

func (n *ExprListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExprListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExprListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ExprList.Pos()
}

// ExprOpt represents data reduced by productions:
//
//	ExprOpt:
//	        /* empty */  // Case 0
//	|       Expr         // Case 1
type ExprOpt struct {
	Expr *Expr
}

func (n *ExprOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExprOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExprOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Expr.Pos()
}

// ExprStmt represents data reduced by production:
//
//	ExprStmt:
//	        ExprListOpt ';'  // Case 0
type ExprStmt struct {
	ExprListOpt *ExprListOpt
	Token       xc.Token
}

func (n *ExprStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExprStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExprStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	if p := n.ExprListOpt.Pos(); p != 0 {
		return p
	}

	return n.Token.Pos()
}

// ExternalDeclarationCase represents case numbers of production ExternalDeclaration
type ExternalDeclarationCase int

// Values of type ExternalDeclarationCase
const (
	ExternalDeclarationDecl ExternalDeclarationCase = iota
	ExternalDeclarationFunc
)

// String implements fmt.Stringer
func (n ExternalDeclarationCase) String() string {
	switch n {
	case ExternalDeclarationDecl:
		return "ExternalDeclarationDecl"
	case ExternalDeclarationFunc:
		return "ExternalDeclarationFunc"
	default:
		return fmt.Sprintf("ExternalDeclarationCase(%v)", int(n))
	}
}

// ExternalDeclaration represents data reduced by productions:
//
//	ExternalDeclaration:
//	        Declaration         // Case ExternalDeclarationDecl
//	|       FunctionDefinition  // Case ExternalDeclarationFunc
type ExternalDeclaration struct {
	Case               ExternalDeclarationCase
	Declaration        *Declaration
	FunctionDefinition *FunctionDefinition
}

func (n *ExternalDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExternalDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExternalDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declaration.Pos()
	case 1:
		return n.FunctionDefinition.Pos()
	default:
		panic("internal error")
	}
}

// ExternalDeclarationList represents data reduced by productions:
//
//	ExternalDeclarationList:
//	        ExternalDeclaration                          // Case 0
//	|       ExternalDeclarationList ExternalDeclaration  // Case 1
type ExternalDeclarationList struct {
	Case                    int
	ExternalDeclaration     *ExternalDeclaration
	ExternalDeclarationList *ExternalDeclarationList
}

func (n *ExternalDeclarationList) reverse() *ExternalDeclarationList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ExternalDeclarationList
	for nb != nil {
		nc := nb.ExternalDeclarationList
		nb.ExternalDeclarationList = na
		na = nb
		nb = nc
	}
	n.ExternalDeclarationList = nil
	return na
}

func (n *ExternalDeclarationList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ExternalDeclarationList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExternalDeclarationList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.ExternalDeclaration.Pos()
	case 1:
		return n.ExternalDeclarationList.Pos()
	default:
		panic("internal error")
	}
}

// FunctionBody represents data reduced by production:
//
//	FunctionBody:
//	        CompoundStmt  // Case 0
type FunctionBody struct {
	CompoundStmt *CompoundStmt
}

func (n *FunctionBody) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionBody) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionBody) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.CompoundStmt.Pos()
}

// FunctionDefinitionCase represents case numbers of production FunctionDefinition
type FunctionDefinitionCase int

// Values of type FunctionDefinitionCase
const (
	FunctionDefinitionSpec FunctionDefinitionCase = iota
	FunctionDefinitionInt
)

// String implements fmt.Stringer
func (n FunctionDefinitionCase) String() string {
	switch n {
	case FunctionDefinitionSpec:
		return "FunctionDefinitionSpec"
	case FunctionDefinitionInt:
		return "FunctionDefinitionInt"
	default:
		return fmt.Sprintf("FunctionDefinitionCase(%v)", int(n))
	}
}

// FunctionDefinition represents data reduced by productions:
//
//	FunctionDefinition:
//	        DeclarationSpecifiers Declarator DeclarationListOpt FunctionBody  // Case FunctionDefinitionSpec
//	|       Declarator DeclarationListOpt FunctionBody                        // Case FunctionDefinitionInt
type FunctionDefinition struct {
	Case                  FunctionDefinitionCase
	DeclarationListOpt    *DeclarationListOpt
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
	FunctionBody          *FunctionBody
}

func (n *FunctionDefinition) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionDefinition) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionDefinition) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.DeclarationSpecifiers.Pos()
	case 1:
		return n.Declarator.Pos()
	default:
		panic("internal error")
	}
}

// FunctionSpecifier represents data reduced by production:
//
//	FunctionSpecifier:
//	        "inline"  // Case 0
type FunctionSpecifier struct {
	Token xc.Token
}

func (n *FunctionSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// IdentifierList represents data reduced by productions:
//
//	IdentifierList:
//	        IDENTIFIER                     // Case 0
//	|       IdentifierList ',' IDENTIFIER  // Case 1
type IdentifierList struct {
	Case           int
	IdentifierList *IdentifierList
	Token          xc.Token
	Token2         xc.Token
}

func (n *IdentifierList) reverse() *IdentifierList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.IdentifierList
	for nb != nil {
		nc := nb.IdentifierList
		nb.IdentifierList = na
		na = nb
		nb = nc
	}
	n.IdentifierList = nil
	return na
}

func (n *IdentifierList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *IdentifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.IdentifierList.Pos()
	case 0:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// IdentifierListOpt represents data reduced by productions:
//
//	IdentifierListOpt:
//	        /* empty */     // Case 0
//	|       IdentifierList  // Case 1
type IdentifierListOpt struct {
	IdentifierList *IdentifierList
}

func (n *IdentifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IdentifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.IdentifierList.Pos()
}

// IdentifierOpt represents data reduced by productions:
//
//	IdentifierOpt:
//	        /* empty */  // Case 0
//	|       IDENTIFIER   // Case 1
type IdentifierOpt struct {
	Token xc.Token
}

func (n *IdentifierOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IdentifierOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// InitDeclaratorCase represents case numbers of production InitDeclarator
type InitDeclaratorCase int

// Values of type InitDeclaratorCase
const (
	InitDeclaratorBase InitDeclaratorCase = iota
	InitDeclaratorInit
)

// String implements fmt.Stringer
func (n InitDeclaratorCase) String() string {
	switch n {
	case InitDeclaratorBase:
		return "InitDeclaratorBase"
	case InitDeclaratorInit:
		return "InitDeclaratorInit"
	default:
		return fmt.Sprintf("InitDeclaratorCase(%v)", int(n))
	}
}

// InitDeclarator represents data reduced by productions:
//
//	InitDeclarator:
//	        Declarator                  // Case InitDeclaratorBase
//	|       Declarator '=' Initializer  // Case InitDeclaratorInit
type InitDeclarator struct {
	Case        InitDeclaratorCase
	Declarator  *Declarator
	Initializer *Initializer
	Token       xc.Token
}

func (n *InitDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *InitDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Declarator.Pos()
}

// InitDeclaratorList represents data reduced by productions:
//
//	InitDeclaratorList:
//	        InitDeclarator                         // Case 0
//	|       InitDeclaratorList ',' InitDeclarator  // Case 1
type InitDeclaratorList struct {
	Case               int
	InitDeclarator     *InitDeclarator
	InitDeclaratorList *InitDeclaratorList
	Token              xc.Token
}

func (n *InitDeclaratorList) reverse() *InitDeclaratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.InitDeclaratorList
	for nb != nil {
		nc := nb.InitDeclaratorList
		nb.InitDeclaratorList = na
		na = nb
		nb = nc
	}
	n.InitDeclaratorList = nil
	return na
}

func (n *InitDeclaratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *InitDeclaratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclaratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.InitDeclarator.Pos()
	case 1:
		return n.InitDeclaratorList.Pos()
	default:
		panic("internal error")
	}
}

// InitDeclaratorListOpt represents data reduced by productions:
//
//	InitDeclaratorListOpt:
//	        /* empty */         // Case 0
//	|       InitDeclaratorList  // Case 1
type InitDeclaratorListOpt struct {
	InitDeclaratorList *InitDeclaratorList
}

func (n *InitDeclaratorListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *InitDeclaratorListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclaratorListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.InitDeclaratorList.Pos()
}

// InitializerCase represents case numbers of production Initializer
type InitializerCase int

// Values of type InitializerCase
const (
	InitializerCompLit InitializerCase = iota
	InitializerExpr
)

// String implements fmt.Stringer
func (n InitializerCase) String() string {
	switch n {
	case InitializerCompLit:
		return "InitializerCompLit"
	case InitializerExpr:
		return "InitializerExpr"
	default:
		return fmt.Sprintf("InitializerCase(%v)", int(n))
	}
}

// Initializer represents data reduced by productions:
//
//	Initializer:
//	        '{' InitializerList CommaOpt '}'  // Case InitializerCompLit
//	|       Expr                              // Case InitializerExpr
type Initializer struct {
	Case            InitializerCase
	CommaOpt        *CommaOpt
	Expr            *Expr
	InitializerList *InitializerList
	Token           xc.Token
	Token2          xc.Token
}

func (n *Initializer) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Initializer) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Initializer) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.Expr.Pos()
	case 0:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// InitializerList represents data reduced by productions:
//
//	InitializerList:
//	        /* empty */                                  // Case 0
//	|       Initializer                                  // Case 1
//	|       Designation Initializer                      // Case 2
//	|       InitializerList ',' Initializer              // Case 3
//	|       InitializerList ',' Designation Initializer  // Case 4
type InitializerList struct {
	Operand         Operand //TODO-
	Len             int
	Case            int
	Designation     *Designation
	Initializer     *Initializer
	InitializerList *InitializerList
	Token           xc.Token
}

func (n *InitializerList) reverse() *InitializerList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.InitializerList
	for nb != nil {
		nc := nb.InitializerList
		nb.InitializerList = na
		na = nb
		nb = nc
	}
	n.InitializerList = nil
	return na
}

func (n *InitializerList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *InitializerList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitializerList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return 0
	case 2:
		return n.Designation.Pos()
	case 1:
		return n.Initializer.Pos()
	case 3, 4:
		if p := n.InitializerList.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// IterationStmtCase represents case numbers of production IterationStmt
type IterationStmtCase int

// Values of type IterationStmtCase
const (
	IterationStmtDo IterationStmtCase = iota
	IterationStmtForDecl
	IterationStmtFor
	IterationStmtWhile
)

// String implements fmt.Stringer
func (n IterationStmtCase) String() string {
	switch n {
	case IterationStmtDo:
		return "IterationStmtDo"
	case IterationStmtForDecl:
		return "IterationStmtForDecl"
	case IterationStmtFor:
		return "IterationStmtFor"
	case IterationStmtWhile:
		return "IterationStmtWhile"
	default:
		return fmt.Sprintf("IterationStmtCase(%v)", int(n))
	}
}

// IterationStmt represents data reduced by productions:
//
//	IterationStmt:
//	        "do" Stmt "while" '(' ExprList ')' ';'                          // Case IterationStmtDo
//	|       "for" '(' Declaration ExprListOpt ';' ExprListOpt ')' Stmt      // Case IterationStmtForDecl
//	|       "for" '(' ExprListOpt ';' ExprListOpt ';' ExprListOpt ')' Stmt  // Case IterationStmtFor
//	|       "while" '(' ExprList ')' Stmt                                   // Case IterationStmtWhile
type IterationStmt struct {
	Case         IterationStmtCase
	Declaration  *Declaration
	ExprList     *ExprList
	ExprListOpt  *ExprListOpt
	ExprListOpt2 *ExprListOpt
	ExprListOpt3 *ExprListOpt
	Stmt         *Stmt
	Token        xc.Token
	Token2       xc.Token
	Token3       xc.Token
	Token4       xc.Token
	Token5       xc.Token
}

func (n *IterationStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IterationStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IterationStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// JumpStmtCase represents case numbers of production JumpStmt
type JumpStmtCase int

// Values of type JumpStmtCase
const (
	JumpStmtBreak JumpStmtCase = iota
	JumpStmtContinue
	JumpStmtGoto
	JumpStmtReturn
)

// String implements fmt.Stringer
func (n JumpStmtCase) String() string {
	switch n {
	case JumpStmtBreak:
		return "JumpStmtBreak"
	case JumpStmtContinue:
		return "JumpStmtContinue"
	case JumpStmtGoto:
		return "JumpStmtGoto"
	case JumpStmtReturn:
		return "JumpStmtReturn"
	default:
		return fmt.Sprintf("JumpStmtCase(%v)", int(n))
	}
}

// JumpStmt represents data reduced by productions:
//
//	JumpStmt:
//	        "break" ';'               // Case JumpStmtBreak
//	|       "continue" ';'            // Case JumpStmtContinue
//	|       "goto" IDENTIFIER ';'     // Case JumpStmtGoto
//	|       "return" ExprListOpt ';'  // Case JumpStmtReturn
type JumpStmt struct {
	ReturnOperand Operand
	scope         *Scope
	Case          JumpStmtCase
	ExprListOpt   *ExprListOpt
	Token         xc.Token
	Token2        xc.Token
	Token3        xc.Token
}

func (n *JumpStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *JumpStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *JumpStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// LabeledStmtCase represents case numbers of production LabeledStmt
type LabeledStmtCase int

// Values of type LabeledStmtCase
const (
	LabeledStmtSwitchCase LabeledStmtCase = iota
	LabeledStmtDefault
	LabeledStmtLabel
	LabeledStmtLabel2
)

// String implements fmt.Stringer
func (n LabeledStmtCase) String() string {
	switch n {
	case LabeledStmtSwitchCase:
		return "LabeledStmtSwitchCase"
	case LabeledStmtDefault:
		return "LabeledStmtDefault"
	case LabeledStmtLabel:
		return "LabeledStmtLabel"
	case LabeledStmtLabel2:
		return "LabeledStmtLabel2"
	default:
		return fmt.Sprintf("LabeledStmtCase(%v)", int(n))
	}
}

// LabeledStmt represents data reduced by productions:
//
//	LabeledStmt:
//	        "case" ConstExpr ':' Stmt  // Case LabeledStmtSwitchCase
//	|       "default" ':' Stmt         // Case LabeledStmtDefault
//	|       IDENTIFIER ':' Stmt        // Case LabeledStmtLabel
//	|       TYPEDEF_NAME ':' Stmt      // Case LabeledStmtLabel2
type LabeledStmt struct {
	Case      LabeledStmtCase
	ConstExpr *ConstExpr
	Stmt      *Stmt
	Token     xc.Token
	Token2    xc.Token
}

func (n *LabeledStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *LabeledStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *LabeledStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ParameterDeclarationCase represents case numbers of production ParameterDeclaration
type ParameterDeclarationCase int

// Values of type ParameterDeclarationCase
const (
	ParameterDeclarationAbstract ParameterDeclarationCase = iota
	ParameterDeclarationDeclarator
)

// String implements fmt.Stringer
func (n ParameterDeclarationCase) String() string {
	switch n {
	case ParameterDeclarationAbstract:
		return "ParameterDeclarationAbstract"
	case ParameterDeclarationDeclarator:
		return "ParameterDeclarationDeclarator"
	default:
		return fmt.Sprintf("ParameterDeclarationCase(%v)", int(n))
	}
}

// ParameterDeclaration represents data reduced by productions:
//
//	ParameterDeclaration:
//	        DeclarationSpecifiers AbstractDeclaratorOpt  // Case ParameterDeclarationAbstract
//	|       DeclarationSpecifiers Declarator             // Case ParameterDeclarationDeclarator
type ParameterDeclaration struct {
	AbstractDeclaratorOpt *AbstractDeclaratorOpt
	Case                  ParameterDeclarationCase
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
}

func (n *ParameterDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationSpecifiers.Pos()
}

// ParameterList represents data reduced by productions:
//
//	ParameterList:
//	        ParameterDeclaration                    // Case 0
//	|       ParameterList ',' ParameterDeclaration  // Case 1
type ParameterList struct {
	Case                 int
	ParameterDeclaration *ParameterDeclaration
	ParameterList        *ParameterList
	Token                xc.Token
}

func (n *ParameterList) reverse() *ParameterList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ParameterList
	for nb != nil {
		nc := nb.ParameterList
		nb.ParameterList = na
		na = nb
		nb = nc
	}
	n.ParameterList = nil
	return na
}

func (n *ParameterList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ParameterList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.ParameterDeclaration.Pos()
	case 1:
		return n.ParameterList.Pos()
	default:
		panic("internal error")
	}
}

// ParameterTypeListCase represents case numbers of production ParameterTypeList
type ParameterTypeListCase int

// Values of type ParameterTypeListCase
const (
	ParameterTypeListBase ParameterTypeListCase = iota
	ParameterTypeListDots
)

// String implements fmt.Stringer
func (n ParameterTypeListCase) String() string {
	switch n {
	case ParameterTypeListBase:
		return "ParameterTypeListBase"
	case ParameterTypeListDots:
		return "ParameterTypeListDots"
	default:
		return fmt.Sprintf("ParameterTypeListCase(%v)", int(n))
	}
}

// ParameterTypeList represents data reduced by productions:
//
//	ParameterTypeList:
//	        ParameterList            // Case ParameterTypeListBase
//	|       ParameterList ',' "..."  // Case ParameterTypeListDots
type ParameterTypeList struct {
	Case          ParameterTypeListCase
	ParameterList *ParameterList
	Token         xc.Token
	Token2        xc.Token
}

func (n *ParameterTypeList) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterTypeList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterTypeList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ParameterList.Pos()
}

// ParameterTypeListOpt represents data reduced by productions:
//
//	ParameterTypeListOpt:
//	        /* empty */        // Case 0
//	|       ParameterTypeList  // Case 1
type ParameterTypeListOpt struct {
	ParameterTypeList *ParameterTypeList
}

func (n *ParameterTypeListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterTypeListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterTypeListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ParameterTypeList.Pos()
}

// PointerCase represents case numbers of production Pointer
type PointerCase int

// Values of type PointerCase
const (
	PointerBase PointerCase = iota
	PointerPtr
)

// String implements fmt.Stringer
func (n PointerCase) String() string {
	switch n {
	case PointerBase:
		return "PointerBase"
	case PointerPtr:
		return "PointerPtr"
	default:
		return fmt.Sprintf("PointerCase(%v)", int(n))
	}
}

// Pointer represents data reduced by productions:
//
//	Pointer:
//	        '*' TypeQualifierListOpt          // Case PointerBase
//	|       '*' TypeQualifierListOpt Pointer  // Case PointerPtr
type Pointer struct {
	Case                 PointerCase
	Pointer              *Pointer
	Token                xc.Token
	TypeQualifierListOpt *TypeQualifierListOpt
}

func (n *Pointer) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Pointer) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Pointer) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// PointerOpt represents data reduced by productions:
//
//	PointerOpt:
//	        /* empty */  // Case 0
//	|       Pointer      // Case 1
type PointerOpt struct {
	Pointer *Pointer
}

func (n *PointerOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *PointerOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *PointerOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Pointer.Pos()
}

// SelectionStmtCase represents case numbers of production SelectionStmt
type SelectionStmtCase int

// Values of type SelectionStmtCase
const (
	SelectionStmtIfElse SelectionStmtCase = iota
	SelectionStmtIf
	SelectionStmtSwitch
)

// String implements fmt.Stringer
func (n SelectionStmtCase) String() string {
	switch n {
	case SelectionStmtIfElse:
		return "SelectionStmtIfElse"
	case SelectionStmtIf:
		return "SelectionStmtIf"
	case SelectionStmtSwitch:
		return "SelectionStmtSwitch"
	default:
		return fmt.Sprintf("SelectionStmtCase(%v)", int(n))
	}
}

// SelectionStmt represents data reduced by productions:
//
//	SelectionStmt:
//	        "if" '(' ExprList ')' Stmt "else" Stmt  // Case SelectionStmtIfElse
//	|       "if" '(' ExprList ')' Stmt              // Case SelectionStmtIf
//	|       "switch" '(' ExprList ')' Stmt          // Case SelectionStmtSwitch
type SelectionStmt struct {
	Cases    []*LabeledStmt
	SwitchOp Operand // Promoted switch operand
	Case     SelectionStmtCase
	ExprList *ExprList
	Stmt     *Stmt
	Stmt2    *Stmt
	Token    xc.Token
	Token2   xc.Token
	Token3   xc.Token
	Token4   xc.Token
}

func (n *SelectionStmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SelectionStmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SelectionStmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// SpecifierQualifierListCase represents case numbers of production SpecifierQualifierList
type SpecifierQualifierListCase int

// Values of type SpecifierQualifierListCase
const (
	SpecifierQualifierListQualifier SpecifierQualifierListCase = iota
	SpecifierQualifierListSpecifier
)

// String implements fmt.Stringer
func (n SpecifierQualifierListCase) String() string {
	switch n {
	case SpecifierQualifierListQualifier:
		return "SpecifierQualifierListQualifier"
	case SpecifierQualifierListSpecifier:
		return "SpecifierQualifierListSpecifier"
	default:
		return fmt.Sprintf("SpecifierQualifierListCase(%v)", int(n))
	}
}

// SpecifierQualifierList represents data reduced by productions:
//
//	SpecifierQualifierList:
//	        TypeQualifier SpecifierQualifierListOpt  // Case SpecifierQualifierListQualifier
//	|       TypeSpecifier SpecifierQualifierListOpt  // Case SpecifierQualifierListSpecifier
type SpecifierQualifierList struct {
	Case                      SpecifierQualifierListCase
	SpecifierQualifierListOpt *SpecifierQualifierListOpt
	TypeQualifier             *TypeQualifier
	TypeSpecifier             *TypeSpecifier
}

func (n *SpecifierQualifierList) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SpecifierQualifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SpecifierQualifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.TypeQualifier.Pos()
	case 1:
		return n.TypeSpecifier.Pos()
	default:
		panic("internal error")
	}
}

// SpecifierQualifierListOpt represents data reduced by productions:
//
//	SpecifierQualifierListOpt:
//	        /* empty */             // Case 0
//	|       SpecifierQualifierList  // Case 1
type SpecifierQualifierListOpt struct {
	SpecifierQualifierList *SpecifierQualifierList
}

func (n *SpecifierQualifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SpecifierQualifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SpecifierQualifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.SpecifierQualifierList.Pos()
}

// StmtCase represents case numbers of production Stmt
type StmtCase int

// Values of type StmtCase
const (
	StmtBlock StmtCase = iota
	StmtExpr
	StmtIter
	StmtJump
	StmtLabeled
	StmtSelect
)

// String implements fmt.Stringer
func (n StmtCase) String() string {
	switch n {
	case StmtBlock:
		return "StmtBlock"
	case StmtExpr:
		return "StmtExpr"
	case StmtIter:
		return "StmtIter"
	case StmtJump:
		return "StmtJump"
	case StmtLabeled:
		return "StmtLabeled"
	case StmtSelect:
		return "StmtSelect"
	default:
		return fmt.Sprintf("StmtCase(%v)", int(n))
	}
}

// Stmt represents data reduced by productions:
//
//	Stmt:
//	        CompoundStmt   // Case StmtBlock
//	|       ExprStmt       // Case StmtExpr
//	|       IterationStmt  // Case StmtIter
//	|       JumpStmt       // Case StmtJump
//	|       LabeledStmt    // Case StmtLabeled
//	|       SelectionStmt  // Case StmtSelect
type Stmt struct {
	Case          StmtCase
	CompoundStmt  *CompoundStmt
	ExprStmt      *ExprStmt
	IterationStmt *IterationStmt
	JumpStmt      *JumpStmt
	LabeledStmt   *LabeledStmt
	SelectionStmt *SelectionStmt
}

func (n *Stmt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Stmt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Stmt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.CompoundStmt.Pos()
	case 1:
		return n.ExprStmt.Pos()
	case 2:
		return n.IterationStmt.Pos()
	case 3:
		return n.JumpStmt.Pos()
	case 4:
		return n.LabeledStmt.Pos()
	case 5:
		return n.SelectionStmt.Pos()
	default:
		panic("internal error")
	}
}

// StorageClassSpecifierCase represents case numbers of production StorageClassSpecifier
type StorageClassSpecifierCase int

// Values of type StorageClassSpecifierCase
const (
	StorageClassSpecifierAuto StorageClassSpecifierCase = iota
	StorageClassSpecifierExtern
	StorageClassSpecifierRegister
	StorageClassSpecifierStatic
	StorageClassSpecifierTypedef
)

// String implements fmt.Stringer
func (n StorageClassSpecifierCase) String() string {
	switch n {
	case StorageClassSpecifierAuto:
		return "StorageClassSpecifierAuto"
	case StorageClassSpecifierExtern:
		return "StorageClassSpecifierExtern"
	case StorageClassSpecifierRegister:
		return "StorageClassSpecifierRegister"
	case StorageClassSpecifierStatic:
		return "StorageClassSpecifierStatic"
	case StorageClassSpecifierTypedef:
		return "StorageClassSpecifierTypedef"
	default:
		return fmt.Sprintf("StorageClassSpecifierCase(%v)", int(n))
	}
}

// StorageClassSpecifier represents data reduced by productions:
//
//	StorageClassSpecifier:
//	        "auto"      // Case StorageClassSpecifierAuto
//	|       "extern"    // Case StorageClassSpecifierExtern
//	|       "register"  // Case StorageClassSpecifierRegister
//	|       "static"    // Case StorageClassSpecifierStatic
//	|       "typedef"   // Case StorageClassSpecifierTypedef
type StorageClassSpecifier struct {
	Case  StorageClassSpecifierCase
	Token xc.Token
}

func (n *StorageClassSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StorageClassSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StorageClassSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// StructDeclarationCase represents case numbers of production StructDeclaration
type StructDeclarationCase int

// Values of type StructDeclarationCase
const (
	StructDeclarationBase StructDeclarationCase = iota
	StructDeclarationAnon
)

// String implements fmt.Stringer
func (n StructDeclarationCase) String() string {
	switch n {
	case StructDeclarationBase:
		return "StructDeclarationBase"
	case StructDeclarationAnon:
		return "StructDeclarationAnon"
	default:
		return fmt.Sprintf("StructDeclarationCase(%v)", int(n))
	}
}

// StructDeclaration represents data reduced by productions:
//
//	StructDeclaration:
//	        SpecifierQualifierList StructDeclaratorList ';'  // Case StructDeclarationBase
//	|       SpecifierQualifierList ';'                       // Case StructDeclarationAnon
type StructDeclaration struct {
	Case                   StructDeclarationCase
	SpecifierQualifierList *SpecifierQualifierList
	StructDeclaratorList   *StructDeclaratorList
	Token                  xc.Token
}

func (n *StructDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.SpecifierQualifierList.Pos()
}

// StructDeclarationList represents data reduced by productions:
//
//	StructDeclarationList:
//	        StructDeclaration                        // Case 0
//	|       StructDeclarationList StructDeclaration  // Case 1
type StructDeclarationList struct {
	Case                  int
	StructDeclaration     *StructDeclaration
	StructDeclarationList *StructDeclarationList
}

func (n *StructDeclarationList) reverse() *StructDeclarationList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.StructDeclarationList
	for nb != nil {
		nc := nb.StructDeclarationList
		nb.StructDeclarationList = na
		na = nb
		nb = nc
	}
	n.StructDeclarationList = nil
	return na
}

func (n *StructDeclarationList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *StructDeclarationList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclarationList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.StructDeclaration.Pos()
	case 1:
		return n.StructDeclarationList.Pos()
	default:
		panic("internal error")
	}
}

// StructDeclaratorCase represents case numbers of production StructDeclarator
type StructDeclaratorCase int

// Values of type StructDeclaratorCase
const (
	StructDeclaratorBase StructDeclaratorCase = iota
	StructDeclaratorBits
)

// String implements fmt.Stringer
func (n StructDeclaratorCase) String() string {
	switch n {
	case StructDeclaratorBase:
		return "StructDeclaratorBase"
	case StructDeclaratorBits:
		return "StructDeclaratorBits"
	default:
		return fmt.Sprintf("StructDeclaratorCase(%v)", int(n))
	}
}

// StructDeclarator represents data reduced by productions:
//
//	StructDeclarator:
//	        Declarator                   // Case StructDeclaratorBase
//	|       DeclaratorOpt ':' ConstExpr  // Case StructDeclaratorBits
type StructDeclarator struct {
	Bits          int
	Case          StructDeclaratorCase
	ConstExpr     *ConstExpr
	Declarator    *Declarator
	DeclaratorOpt *DeclaratorOpt
	Token         xc.Token
}

func (n *StructDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declarator.Pos()
	case 1:
		if p := n.DeclaratorOpt.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// StructDeclaratorList represents data reduced by productions:
//
//	StructDeclaratorList:
//	        StructDeclarator                           // Case 0
//	|       StructDeclaratorList ',' StructDeclarator  // Case 1
type StructDeclaratorList struct {
	Case                 int
	StructDeclarator     *StructDeclarator
	StructDeclaratorList *StructDeclaratorList
	Token                xc.Token
}

func (n *StructDeclaratorList) reverse() *StructDeclaratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.StructDeclaratorList
	for nb != nil {
		nc := nb.StructDeclaratorList
		nb.StructDeclaratorList = na
		na = nb
		nb = nc
	}
	n.StructDeclaratorList = nil
	return na
}

func (n *StructDeclaratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *StructDeclaratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclaratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.StructDeclarator.Pos()
	case 1:
		return n.StructDeclaratorList.Pos()
	default:
		panic("internal error")
	}
}

// StructOrUnionCase represents case numbers of production StructOrUnion
type StructOrUnionCase int

// Values of type StructOrUnionCase
const (
	StructOrUnionStruct StructOrUnionCase = iota
	StructOrUnionUnion
)

// String implements fmt.Stringer
func (n StructOrUnionCase) String() string {
	switch n {
	case StructOrUnionStruct:
		return "StructOrUnionStruct"
	case StructOrUnionUnion:
		return "StructOrUnionUnion"
	default:
		return fmt.Sprintf("StructOrUnionCase(%v)", int(n))
	}
}

// StructOrUnion represents data reduced by productions:
//
//	StructOrUnion:
//	        "struct"  // Case StructOrUnionStruct
//	|       "union"   // Case StructOrUnionUnion
type StructOrUnion struct {
	Case  StructOrUnionCase
	Token xc.Token
}

func (n *StructOrUnion) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructOrUnion) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructOrUnion) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// StructOrUnionSpecifierCase represents case numbers of production StructOrUnionSpecifier
type StructOrUnionSpecifierCase int

// Values of type StructOrUnionSpecifierCase
const (
	StructOrUnionSpecifierTag StructOrUnionSpecifierCase = iota
	StructOrUnionSpecifierEmpty
	StructOrUnionSpecifierDefine
)

// String implements fmt.Stringer
func (n StructOrUnionSpecifierCase) String() string {
	switch n {
	case StructOrUnionSpecifierTag:
		return "StructOrUnionSpecifierTag"
	case StructOrUnionSpecifierEmpty:
		return "StructOrUnionSpecifierEmpty"
	case StructOrUnionSpecifierDefine:
		return "StructOrUnionSpecifierDefine"
	default:
		return fmt.Sprintf("StructOrUnionSpecifierCase(%v)", int(n))
	}
}

// StructOrUnionSpecifier represents data reduced by productions:
//
//	StructOrUnionSpecifier:
//	        StructOrUnion IDENTIFIER                                   // Case StructOrUnionSpecifierTag
//	|       StructOrUnion IdentifierOpt '{' '}'                        // Case StructOrUnionSpecifierEmpty
//	|       StructOrUnion IdentifierOpt '{' StructDeclarationList '}'  // Case StructOrUnionSpecifierDefine
type StructOrUnionSpecifier struct {
	scope                 *Scope // Declare the struct tag in scope.parent.
	typ                   Type
	Case                  StructOrUnionSpecifierCase
	IdentifierOpt         *IdentifierOpt
	StructDeclarationList *StructDeclarationList
	StructOrUnion         *StructOrUnion
	Token                 xc.Token
	Token2                xc.Token
}

func (n *StructOrUnionSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructOrUnionSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructOrUnionSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.StructOrUnion.Pos()
}

// TypeName represents data reduced by production:
//
//	TypeName:
//	        SpecifierQualifierList AbstractDeclaratorOpt  // Case 0
type TypeName struct {
	Type                   Type
	AbstractDeclaratorOpt  *AbstractDeclaratorOpt
	SpecifierQualifierList *SpecifierQualifierList
}

func (n *TypeName) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeName) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeName) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.SpecifierQualifierList.Pos()
}

// TypeQualifierCase represents case numbers of production TypeQualifier
type TypeQualifierCase int

// Values of type TypeQualifierCase
const (
	TypeQualifierConst TypeQualifierCase = iota
	TypeQualifierRestrict
	TypeQualifierVolatile
)

// String implements fmt.Stringer
func (n TypeQualifierCase) String() string {
	switch n {
	case TypeQualifierConst:
		return "TypeQualifierConst"
	case TypeQualifierRestrict:
		return "TypeQualifierRestrict"
	case TypeQualifierVolatile:
		return "TypeQualifierVolatile"
	default:
		return fmt.Sprintf("TypeQualifierCase(%v)", int(n))
	}
}

// TypeQualifier represents data reduced by productions:
//
//	TypeQualifier:
//	        "const"     // Case TypeQualifierConst
//	|       "restrict"  // Case TypeQualifierRestrict
//	|       "volatile"  // Case TypeQualifierVolatile
type TypeQualifier struct {
	Case  TypeQualifierCase
	Token xc.Token
}

func (n *TypeQualifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeQualifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// TypeQualifierList represents data reduced by productions:
//
//	TypeQualifierList:
//	        TypeQualifier                    // Case 0
//	|       TypeQualifierList TypeQualifier  // Case 1
type TypeQualifierList struct {
	Case              int
	TypeQualifier     *TypeQualifier
	TypeQualifierList *TypeQualifierList
}

func (n *TypeQualifierList) reverse() *TypeQualifierList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.TypeQualifierList
	for nb != nil {
		nc := nb.TypeQualifierList
		nb.TypeQualifierList = na
		na = nb
		nb = nc
	}
	n.TypeQualifierList = nil
	return na
}

func (n *TypeQualifierList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *TypeQualifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.TypeQualifier.Pos()
	case 1:
		return n.TypeQualifierList.Pos()
	default:
		panic("internal error")
	}
}

// TypeQualifierListOpt represents data reduced by productions:
//
//	TypeQualifierListOpt:
//	        /* empty */        // Case 0
//	|       TypeQualifierList  // Case 1
type TypeQualifierListOpt struct {
	TypeQualifierList *TypeQualifierList
}

func (n *TypeQualifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeQualifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.TypeQualifierList.Pos()
}

// TypeSpecifierCase represents case numbers of production TypeSpecifier
type TypeSpecifierCase int

// Values of type TypeSpecifierCase
const (
	TypeSpecifierBool TypeSpecifierCase = iota
	TypeSpecifierComplex
	TypeSpecifierChar
	TypeSpecifierDouble
	TypeSpecifierFloat
	TypeSpecifierInt
	TypeSpecifierLong
	TypeSpecifierShort
	TypeSpecifierSigned
	TypeSpecifierUnsigned
	TypeSpecifierVoid
	TypeSpecifierEnum
	TypeSpecifierStruct
	TypeSpecifierName
	TypeSpecifierTypeofExpr
	TypeSpecifierTypeof
)

// String implements fmt.Stringer
func (n TypeSpecifierCase) String() string {
	switch n {
	case TypeSpecifierBool:
		return "TypeSpecifierBool"
	case TypeSpecifierComplex:
		return "TypeSpecifierComplex"
	case TypeSpecifierChar:
		return "TypeSpecifierChar"
	case TypeSpecifierDouble:
		return "TypeSpecifierDouble"
	case TypeSpecifierFloat:
		return "TypeSpecifierFloat"
	case TypeSpecifierInt:
		return "TypeSpecifierInt"
	case TypeSpecifierLong:
		return "TypeSpecifierLong"
	case TypeSpecifierShort:
		return "TypeSpecifierShort"
	case TypeSpecifierSigned:
		return "TypeSpecifierSigned"
	case TypeSpecifierUnsigned:
		return "TypeSpecifierUnsigned"
	case TypeSpecifierVoid:
		return "TypeSpecifierVoid"
	case TypeSpecifierEnum:
		return "TypeSpecifierEnum"
	case TypeSpecifierStruct:
		return "TypeSpecifierStruct"
	case TypeSpecifierName:
		return "TypeSpecifierName"
	case TypeSpecifierTypeofExpr:
		return "TypeSpecifierTypeofExpr"
	case TypeSpecifierTypeof:
		return "TypeSpecifierTypeof"
	default:
		return fmt.Sprintf("TypeSpecifierCase(%v)", int(n))
	}
}

// TypeSpecifier represents data reduced by productions:
//
//	TypeSpecifier:
//	        "_Bool"                    // Case TypeSpecifierBool
//	|       "_Complex"                 // Case TypeSpecifierComplex
//	|       "char"                     // Case TypeSpecifierChar
//	|       "double"                   // Case TypeSpecifierDouble
//	|       "float"                    // Case TypeSpecifierFloat
//	|       "int"                      // Case TypeSpecifierInt
//	|       "long"                     // Case TypeSpecifierLong
//	|       "short"                    // Case TypeSpecifierShort
//	|       "signed"                   // Case TypeSpecifierSigned
//	|       "unsigned"                 // Case TypeSpecifierUnsigned
//	|       "void"                     // Case TypeSpecifierVoid
//	|       EnumSpecifier              // Case TypeSpecifierEnum
//	|       StructOrUnionSpecifier     // Case TypeSpecifierStruct
//	|       TYPEDEF_NAME               // Case TypeSpecifierName
//	|       "typeof" '(' Expr ')'      // Case TypeSpecifierTypeofExpr
//	|       "typeof" '(' TypeName ')'  // Case TypeSpecifierTypeof
type TypeSpecifier struct {
	scope                  *Scope
	typ                    Type // typeof
	Case                   TypeSpecifierCase
	EnumSpecifier          *EnumSpecifier
	Expr                   *Expr
	StructOrUnionSpecifier *StructOrUnionSpecifier
	Token                  xc.Token
	Token2                 xc.Token
	Token3                 xc.Token
	TypeName               *TypeName
}

func (n *TypeSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 11:
		return n.EnumSpecifier.Pos()
	case 12:
		return n.StructOrUnionSpecifier.Pos()
	case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// VolatileOpt represents data reduced by productions:
//
//	VolatileOpt:
//	        /* empty */  // Case 0
//	|       "volatile"   // Case 1
type VolatileOpt struct {
	Token xc.Token
}

func (n *VolatileOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *VolatileOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *VolatileOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}
