// Code generated by 'ccgo -lmodernc.org/z/lib -o internal/example_netbsd_amd64.go -trace-translation-units /tmp/go-generate-2662545308/cdb.json example64', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

//	$NetBSD: null.h,v 1.9 2010/07/06 11:56:20 kleink Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, December 22, 1999.
// Public domain.

type max_align_t = struct{ _v uintptr } /* stddef.h:75:3 */

type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint64 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = int8   /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

//	$NetBSD: limits.h,v 1.40 2016/08/04 06:43:43 christos Exp $

// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)limits.h	8.2 (Berkeley) 1/4/94

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// We have not implemented these yet
//
// _POSIX_THREAD_ATTR_STACKADDR
// _POSIX_THREAD_ATTR_STACKSIZE
// _POSIX_THREAD_CPUTIME
// _POSIX_THREAD_PRIORITY_SCHEDULING
// _POSIX_THREAD_PRIO_INHERIT
// _POSIX_THREAD_PRIO_PROTECT
// _POSIX_THREAD_PROCESS_SHARED
// _POSIX_THREAD_SAFE_FUNCTIONS
// _POSIX_THREAD_SPORADIC_SERVER

// The following 3 are defined in
// Open Group Base Specifications Issue 7

// These are the correct names, defined in terms of the above
// except for PTHREAD_KEYS_MAX which is bigger than standard
// mandated minimum value _POSIX_THREAD_KEYS_MAX.
// Not yet: PTHREAD_STACK_MIN

// X/Open CAE Specifications,
// adopted in IEEE Std 1003.1-2001 XSI.

// IEEE Std 1003.1-2001 TSF

// Always ensure that this is consistent with <stdio.h>

// X/Open Extended API set 2 (a.k.a. C063)
// This hides unimplemented functions from GNU configure until
// we are done implementing them.

//	$NetBSD: limits.h,v 1.15 2019/01/21 20:22:48 dholland Exp $

// Copyright (c) 1988 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)limits.h	7.2 (Berkeley) 6/28/90

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: syslimits.h,v 1.28 2015/08/21 07:19:39 uebayasi Exp $

// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)syslimits.h	8.1 (Berkeley) 6/2/93

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// kept in sync with MAXNAMLEN

// IEEE Std 1003.1c-95, adopted in X/Open CAE Specification Issue 5 Version 2

// X/Open CAE Specification Issue 5 Version 2

type z_crc_t = uint32 /* zconf.h:429:17 */

type int8_t = int8 /* types.h:54:18 */

type uint8_t = uint8 /* types.h:59:19 */

type int16_t = int16 /* types.h:64:19 */

type uint16_t = uint16 /* types.h:69:20 */

type int32_t = int32 /* types.h:74:19 */

type uint32_t = uint32 /* types.h:79:20 */

type int64_t = int64 /* types.h:84:19 */

type uint64_t = uint64 /* types.h:89:20 */

type u_int8_t = uint8_t   /* types.h:93:18 */
type u_int16_t = uint16_t /* types.h:94:18 */
type u_int32_t = uint32_t /* types.h:95:18 */
type u_int64_t = uint64_t /* types.h:96:18 */

//	$NetBSD: endian.h,v 1.1 2003/04/26 18:39:40 fvdl Exp $

//	$NetBSD: endian.h,v 1.30 2016/02/27 21:37:35 christos Exp $

// Copyright (c) 1987, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)endian.h	8.1 (Berkeley) 6/11/93

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// Definitions for byte order, according to byte significance from low
// address to high.

// C-family endian-ness definitions

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

type in_addr_t = uint32 /* endian.h:58:21 */

type in_port_t = uint16 /* endian.h:63:21 */

func __byte_swap_u64_variable(tls *libc.TLS, x uint64_t) uint64_t { /* byte_swap.h:48:1: */
	panic(`/usr/include/machine/byte_swap.h:50:2: assembler statements not supported`)
	return x
}

func __byte_swap_u32_variable(tls *libc.TLS, x uint32_t) uint32_t { /* byte_swap.h:57:1: */
	panic(`/usr/include/machine/byte_swap.h:59:2: assembler statements not supported`)
	return x
}

func __byte_swap_u16_variable(tls *libc.TLS, x uint16_t) uint16_t { /* byte_swap.h:66:1: */
	panic(`/usr/include/machine/byte_swap.h:68:2: assembler statements not supported`)
	return x
}

//      $NetBSD: bswap.h,v 1.19 2015/03/12 15:28:16 christos Exp $

// Written by Manuel Bouyer. Public domain

//	$NetBSD: stdint.h,v 1.8 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 2001, 2004 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: int_types.h,v 1.7 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	from: @(#)types.h	7.5 (Berkeley) 3/9/91

type intptr_t = int64 /* stdint.h:79:20 */

type uintptr_t = uint64 /* stdint.h:84:21 */

//	$NetBSD: int_mwgwtypes.h,v 1.8 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 2001 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: common_int_mwgwtypes.h,v 1.1 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Joerg Sonnenberger.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// 7.18.1 Integer types

// 7.18.1.2 Minimum-width integer types

type int_least8_t = int8     /* common_int_mwgwtypes.h:45:32 */
type uint_least8_t = uint8   /* common_int_mwgwtypes.h:46:32 */
type int_least16_t = int16   /* common_int_mwgwtypes.h:47:32 */
type uint_least16_t = uint16 /* common_int_mwgwtypes.h:48:32 */
type int_least32_t = int32   /* common_int_mwgwtypes.h:49:32 */
type uint_least32_t = uint32 /* common_int_mwgwtypes.h:50:32 */
type int_least64_t = int64   /* common_int_mwgwtypes.h:51:32 */
type uint_least64_t = uint64 /* common_int_mwgwtypes.h:52:32 */

// 7.18.1.3 Fastest minimum-width integer types
type int_fast8_t = int32    /* common_int_mwgwtypes.h:55:32 */
type uint_fast8_t = uint32  /* common_int_mwgwtypes.h:56:32 */
type int_fast16_t = int32   /* common_int_mwgwtypes.h:57:32 */
type uint_fast16_t = uint32 /* common_int_mwgwtypes.h:58:32 */
type int_fast32_t = int32   /* common_int_mwgwtypes.h:59:32 */
type uint_fast32_t = uint32 /* common_int_mwgwtypes.h:60:32 */
type int_fast64_t = int64   /* common_int_mwgwtypes.h:61:32 */
type uint_fast64_t = uint64 /* common_int_mwgwtypes.h:62:32 */

// 7.18.1.5 Greatest-width integer types

type intmax_t = int64   /* common_int_mwgwtypes.h:66:33 */
type uintmax_t = uint64 /* common_int_mwgwtypes.h:67:32 */

type u_char = uint8   /* types.h:101:23 */
type u_short = uint16 /* types.h:102:24 */
type u_int = uint32   /* types.h:103:22 */
type u_long = uint64  /* types.h:104:23 */

type unchar = uint8  /* types.h:106:23 */ // Sys V compatibility
type ushort = uint16 /* types.h:107:24 */ // Sys V compatibility
type uint = uint32   /* types.h:108:22 */ // Sys V compatibility
type ulong = uint64  /* types.h:109:23 */ // Sys V compatibility

type u_quad_t = uint64_t /* types.h:112:18 */ // quads
type quad_t = int64_t    /* types.h:113:18 */
type qaddr_t = uintptr   /* types.h:114:16 */

// The types longlong_t and u_longlong_t exist for use with the
// Sun-derived XDR routines involving these types, and their usage
// in other contexts is discouraged.  Further note that these types
// may not be equivalent to "long long" and "unsigned long long",
// they are only guaranteed to be signed and unsigned 64-bit types
// respectively.  Portable programs that need 64-bit types should use
// the C99 types int64_t and uint64_t instead.

type longlong_t = int64_t    /* types.h:126:18 */ // for XDR
type u_longlong_t = uint64_t /* types.h:127:18 */ // for XDR

type blkcnt_t = int64_t  /* types.h:129:18 */ // fs block count
type blksize_t = int32_t /* types.h:130:18 */ // fs optimal block size

type fsblkcnt_t = uint64 /* types.h:133:22 */ // fs block count (statvfs)

type fsfilcnt_t = uint64 /* types.h:138:22 */ // fs file count

// We don't and shouldn't use caddr_t in the kernel anymore
type caddr_t = uintptr /* types.h:145:19 */ // core address

type daddr_t = int64_t /* types.h:154:18 */ // disk address

type dev_t = uint64_t   /* types.h:157:18 */ // device number
type fixpt_t = uint32_t /* types.h:158:18 */ // fixed point number

type gid_t = uint32 /* types.h:161:18 */ // group id

type id_t = uint32_t  /* types.h:165:18 */ // group id, process id or user id
type ino_t = uint64_t /* types.h:166:18 */ // inode number
type key_t = int64    /* types.h:167:15 */ // IPC key (for Sys V IPC)

type mode_t = uint32 /* types.h:170:18 */ // permissions

type nlink_t = uint32_t /* types.h:174:18 */ // link count

type off_t = int64 /* types.h:177:18 */ // file offset

type pid_t = int32     /* types.h:182:18 */ // process id
type lwpid_t = int32_t /* types.h:185:18 */ // LWP id
type rlim_t = uint64_t /* types.h:186:18 */ // resource limit
type segsz_t = int32_t /* types.h:187:18 */ // segment size
type swblk_t = int32_t /* types.h:188:18 */ // swap offset

type uid_t = uint32 /* types.h:191:18 */ // user id

type mqd_t = int32 /* types.h:195:14 */

type cpuid_t = uint64 /* types.h:197:23 */

type psetid_t = int32 /* types.h:199:14 */

type clock_t = uint32 /* types.h:268:24 */

type ssize_t = int64 /* types.h:284:24 */

type time_t = int64 /* types.h:289:23 */

type clockid_t = int32 /* types.h:294:26 */

type timer_t = int32 /* types.h:299:24 */

type suseconds_t = int32 /* types.h:304:27 */

type useconds_t = uint32 /* types.h:309:26 */

// 32 = 2 ^ 5

// Select uses bit fields of file descriptors.  These macros manipulate
// such bit fields.  Note: FD_SETSIZE may be defined by the user.

type fd_set1 = struct{ fds_bits [8]uint32 } /* fd_set.h:66:9 */

// 32 = 2 ^ 5

// Select uses bit fields of file descriptors.  These macros manipulate
// such bit fields.  Note: FD_SETSIZE may be defined by the user.

type fd_set = fd_set1 /* fd_set.h:68:3 */

// Expose our internals if we are not required to hide them.

type kauth_cred_t = uintptr /* types.h:318:27 */

type pri_t = int32 /* types.h:320:13 */

//	$NetBSD: pthread_types.h,v 1.23 2017/09/09 23:21:45 kamil Exp $

// -
// Copyright (c) 2001, 2008 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Nathan J. Williams.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// We use the "pthread_spin_t" name internally; "pthread_spinlock_t" is the
// POSIX spinlock object.
//
// C++ expects to be using PTHREAD_FOO_INITIALIZER as a member initializer.
// This does not work for volatile types.  Since C++ does not touch the guts
// of those types, we do not include volatile in the C++ definitions.
type pthread_spin_t = uint8 /* pthread_types.h:43:29 */

// Copied from PTQ_HEAD in pthread_queue.h

type pthread_queue_struct_t = struct {
	ptqh_first uintptr
	ptqh_last  uintptr
} /* pthread_types.h:61:1 */

type pthread_queue_t = pthread_queue_struct_t /* pthread_types.h:62:39 */
type __pthread_attr_st = struct {
	pta_magic   uint32
	pta_flags   int32
	pta_private uintptr
} /* pthread_types.h:65:1 */

type __pthread_mutex_st = struct {
	ptm_magic      uint32
	ptm_errorcheck uint8
	ptm_pad1       [3]uint8_t
	__8            struct{ ptm_ceiling uint8 }
	ptm_pad2       [3]uint8_t
	_              [4]byte
	ptm_owner      pthread_t
	ptm_waiters    uintptr
	ptm_recursed   uint32
	_              [4]byte
	ptm_spare2     uintptr
} /* pthread_types.h:66:1 */

type __pthread_mutexattr_st = struct {
	ptma_magic   uint32
	_            [4]byte
	ptma_private uintptr
} /* pthread_types.h:67:1 */

type __pthread_cond_st = struct {
	ptc_magic   uint32
	ptc_lock    uint8
	_           [3]byte
	ptc_waiters pthread_queue_t
	ptc_mutex   uintptr
	ptc_private uintptr
} /* pthread_types.h:68:1 */

type __pthread_condattr_st = struct {
	ptca_magic   uint32
	_            [4]byte
	ptca_private uintptr
} /* pthread_types.h:69:1 */

type __pthread_rwlock_st = struct {
	ptr_magic     uint32
	ptr_interlock uint8
	_             [3]byte
	ptr_rblocked  pthread_queue_t
	ptr_wblocked  pthread_queue_t
	ptr_nreaders  uint32
	_             [4]byte
	ptr_owner     pthread_t
	ptr_private   uintptr
} /* pthread_types.h:71:1 */

type __pthread_rwlockattr_st = struct {
	ptra_magic   uint32
	_            [4]byte
	ptra_private uintptr
} /* pthread_types.h:72:1 */

type __pthread_barrier_st = struct {
	ptb_magic      uint32
	ptb_lock       pthread_spin_t
	_              [3]byte
	ptb_waiters    pthread_queue_t
	ptb_initcount  uint32
	ptb_curcount   uint32
	ptb_generation uint32
	_              [4]byte
	ptb_private    uintptr
} /* pthread_types.h:73:1 */

type __pthread_barrierattr_st = struct {
	ptba_magic   uint32
	_            [4]byte
	ptba_private uintptr
} /* pthread_types.h:74:1 */

type pthread_t = uintptr                          /* pthread_types.h:76:29 */
type pthread_attr_t = __pthread_attr_st           /* pthread_types.h:77:34 */
type pthread_mutex_t = __pthread_mutex_st         /* pthread_types.h:78:35 */
type pthread_mutexattr_t = __pthread_mutexattr_st /* pthread_types.h:79:39 */
type pthread_cond_t = __pthread_cond_st           /* pthread_types.h:80:34 */
type pthread_condattr_t = __pthread_condattr_st   /* pthread_types.h:81:38 */
type __pthread_once_st = struct {
	pto_mutex pthread_mutex_t
	pto_done  int32
	_         [4]byte
} /* pthread_types.h:82:9 */

type pthread_once_t = __pthread_once_st /* pthread_types.h:82:34 */
type __pthread_spinlock_st = struct {
	pts_magic uint32
	pts_spin  uint8
	_         [3]byte
	pts_flags int32
} /* pthread_types.h:83:9 */

type pthread_spinlock_t = __pthread_spinlock_st       /* pthread_types.h:83:38 */
type pthread_rwlock_t = __pthread_rwlock_st           /* pthread_types.h:84:36 */
type pthread_rwlockattr_t = __pthread_rwlockattr_st   /* pthread_types.h:85:40 */
type pthread_barrier_t = __pthread_barrier_st         /* pthread_types.h:86:37 */
type pthread_barrierattr_t = __pthread_barrierattr_st /* pthread_types.h:87:41 */
type pthread_key_t = int32                            /* pthread_types.h:88:13 */

//	$NetBSD: stdarg.h,v 1.4.24.1 2020/04/02 19:17:04 martin Exp $

// -
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdarg.h	8.1 (Berkeley) 6/10/93

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

type va_list = uintptr /* stdarg.h:53:19 */ // getsubopt(3) external variable

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	_         [4]byte
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	_         [4]byte
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	_         [4]byte
	adler     uLong
	reserved  uLong
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	_         [4]byte
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  int64
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

//	$NetBSD: stdio.h,v 1.97.18.1 2020/03/30 18:54:56 martin Exp $

// -
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Chris Torek.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdio.h	8.5 (Berkeley) 4/29/95

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: null.h,v 1.9 2010/07/06 11:56:20 kleink Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, December 22, 1999.
// Public domain.

// This is fairly grotesque, but pure ANSI code must not inspect the
// innards of an fpos_t anyway.  The library internally uses off_t,
// which we assume is exactly as big as eight chars.
type __sfpos = struct {
	_pos        int64
	_mbstate_in struct {
		__mbstateL int64
		_          [120]byte
	}
	_mbstate_out struct {
		__mbstateL int64
		_          [120]byte
	}
} /* stdio.h:67:9 */

//	$NetBSD: stdio.h,v 1.97.18.1 2020/03/30 18:54:56 martin Exp $

// -
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Chris Torek.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdio.h	8.5 (Berkeley) 4/29/95

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: null.h,v 1.9 2010/07/06 11:56:20 kleink Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, December 22, 1999.
// Public domain.

// This is fairly grotesque, but pure ANSI code must not inspect the
// innards of an fpos_t anyway.  The library internally uses off_t,
// which we assume is exactly as big as eight chars.
type fpos_t = __sfpos /* stdio.h:70:3 */

// NB: to fit things in six character monocase externals, the stdio
// code uses the prefix `__s' for stdio objects, typically followed
// by a three-character attempt at a mnemonic.

// stdio buffers
type __sbuf = struct {
	_base uintptr
	_size int32
	_     [4]byte
} /* stdio.h:81:1 */

// stdio state variables.
//
// The following always hold:
//
//	if (_flags&(__SLBF|__SWR)) == (__SLBF|__SWR),
//		_lbfsize is -_bf._size, else _lbfsize is 0
//	if _flags&__SRD, _w is 0
//	if _flags&__SWR, _r is 0
//
// This ensures that the getc and putc macros (or inline functions) never
// try to write or read from a file that is in `read' or `write' mode.
// (Moreover, they can, and do, automatically switch from read mode to
// write mode, and back, on "r+" and "w+" files.)
//
// _lbfsize is used only to make the inline line-buffered output stream
// code as compact as possible.
//
// _ub, _up, and _ur are used when ungetc() pushes back more characters
// than fit in the current _bf, or when ungetc() pushes back a character
// that does not match the previous one in _bf.  When this happens,
// _ub._base becomes non-nil (i.e., a stream has ungetc() data iff
// _ub._base!=NULL) and _up and _ur save the current values of _p and _r.
//
// NB: see WARNING above before changing the layout of this structure!
type __sFILE = struct {
	_p     uintptr
	_r     int32
	_w     int32
	_flags uint16
	_file  int16
	_      [4]byte
	_bf    struct {
		_base uintptr
		_size int32
		_     [4]byte
	}
	_lbfsize int32
	_        [4]byte
	_cookie  uintptr
	_close   uintptr
	_read    uintptr
	_seek    uintptr
	_write   uintptr
	_ext     struct {
		_base uintptr
		_size int32
		_     [4]byte
	}
	_up        uintptr
	_ur        int32
	_ubuf      [3]uint8
	_nbuf      [1]uint8
	_flush     uintptr
	_lb_unused [8]int8
	_blksize   int32
	_          [4]byte
	_offset    int64
} /* stdio.h:112:9 */

// stdio state variables.
//
// The following always hold:
//
//	if (_flags&(__SLBF|__SWR)) == (__SLBF|__SWR),
//		_lbfsize is -_bf._size, else _lbfsize is 0
//	if _flags&__SRD, _w is 0
//	if _flags&__SWR, _r is 0
//
// This ensures that the getc and putc macros (or inline functions) never
// try to write or read from a file that is in `read' or `write' mode.
// (Moreover, they can, and do, automatically switch from read mode to
// write mode, and back, on "r+" and "w+" files.)
//
// _lbfsize is used only to make the inline line-buffered output stream
// code as compact as possible.
//
// _ub, _up, and _ur are used when ungetc() pushes back more characters
// than fit in the current _bf, or when ungetc() pushes back a character
// that does not match the previous one in _bf.  When this happens,
// _ub._base becomes non-nil (i.e., a stream has ungetc() data iff
// _ub._base!=NULL) and _up and _ur save the current values of _p and _r.
//
// NB: see WARNING above before changing the layout of this structure!
type FILE = __sFILE /* stdio.h:146:3 */

type locale_t = uintptr /* stdio.h:543:25 */

//	$NetBSD: stdlib.h,v 1.121 2019/01/05 09:16:46 maya Exp $

// -
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdlib.h	8.5 (Berkeley) 5/19/95

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

//	$NetBSD: ansi.h,v 1.11 2019/05/07 03:49:26 kamil Exp $

//	$NetBSD: common_ansi.h,v 1.1 2014/08/19 07:27:31 matt Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Matt Thomas of 3am Software Foundry.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:59:3 */

type ldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:64:3 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:74:3 */

type qdiv_t = struct {
	quot quad_t
	rem  quad_t
} /* stdlib.h:81:3 */

var hello = *(*[14]int8)(unsafe.Pointer(ts /* "hello, hello!" */)) /* example.c:29:21 */
// "hello world" would be more standard, but the repeated "hello"
// stresses the compression code better, sorry...

var dictionary = *(*[6]int8)(unsafe.Pointer(ts + 14 /* "hello" */)) /* example.c:34:19 */
var dictId uLong                                                    /* example.c:35:14: */

var zalloc alloc_func = uintptr(0) /* example.c:77:19 */
var zfree free_func = uintptr(0)   /* example.c:78:18 */

// ===========================================================================
// Test compress() and uncompress()
func test_compress(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:88:6: */
	bp := tls.Alloc(56)
	defer tls.Free(56)
	*(*uLong)(unsafe.Pointer(bp + 40)) = comprLen
	*(*uLong)(unsafe.Pointer(bp + 48)) = uncomprLen

	var err int32
	var len uLong = (libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello))) + uint64(1))

	err = z.Xcompress(tls, compr, bp+40 /* &comprLen */, uintptr(uintptr(unsafe.Pointer(&hello))), len)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+34 /* "compress" */, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	err = z.Xuncompress(tls, uncompr, bp+48 /* &uncomprLen */, compr, *(*uLong)(unsafe.Pointer(bp + 40 /* comprLen */)))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+51 /* "uncompress" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+62 /* "bad uncompress\n" */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+78 /* "uncompress(): %s..." */, libc.VaList(bp+32, uncompr))
	}
}

// ===========================================================================
// Test read/write of .gz files
func test_gzio(tls *libc.TLS, fname uintptr, uncompr uintptr, uncomprLen uLong) { /* example.c:114:6: */
	bp := tls.Alloc(84)
	defer tls.Free(84)

	// var err int32 at bp+80, 4

	var len int32 = (int32(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + 1)
	var file gzFile
	var pos int64

	file = z.Xgzopen(tls, fname, ts+96 /* "wb" */)
	if file == (uintptr(0)) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+99 /* "gzopen error\n" */, 0)
		libc.Xexit(tls, 1)
	}
	z.Xgzputc(tls, file, 'h')
	if z.Xgzputs(tls, file, ts+113 /* "ello" */) != 4 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+118 /* "gzputs err: %s\n" */, libc.VaList(bp, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if z.Xgzprintf(tls, file, ts+134 /* ", %s!" */, libc.VaList(bp+8, ts+14 /* "hello" */)) != 8 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+140 /* "gzprintf err: %s..." */, libc.VaList(bp+16, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	z.Xgzseek(tls, file, 1, 1) // add one zero byte
	z.Xgzclose(tls, file)

	file = z.Xgzopen(tls, fname, ts+158 /* "rb" */)
	if file == (uintptr(0)) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+99 /* "gzopen error\n" */, 0)
		libc.Xexit(tls, 1)
	}
	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	if z.Xgzread(tls, file, uncompr, uint32(uncomprLen)) != len {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+161 /* "gzread err: %s\n" */, libc.VaList(bp+24, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+177 /* "bad gzread: %s\n" */, libc.VaList(bp+32, uncompr))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+193 /* "gzread(): %s\n" */, libc.VaList(bp+40, uncompr))
	}

	pos = z.Xgzseek(tls, file, -8, 1)
	if (pos != int64(6)) || (z.Xgztell(tls, file) != pos) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+207, /* "gzseek error, po..." */
			libc.VaList(bp+48, pos, z.Xgztell(tls, file)))
		libc.Xexit(tls, 1)
	}

	if (func() int32 {
		if (*gzFile_s)(unsafe.Pointer(file)).have != 0 {
			return int32(func() uint8 {
				(*gzFile_s)(unsafe.Pointer(file)).have--
				(*gzFile_s)(unsafe.Pointer(file)).pos++
				return *(*uint8)(unsafe.Pointer(libc.PostIncUintptr(&((*gzFile_s)(unsafe.Pointer(file)).next), 1)))
			}())
		}
		return z.Xgzgetc(tls, file)
	}()) != ' ' {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+242 /* "gzgetc error\n" */, 0)
		libc.Xexit(tls, 1)
	}

	if z.Xgzungetc(tls, ' ', file) != ' ' {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+256 /* "gzungetc error\n" */, 0)
		libc.Xexit(tls, 1)
	}

	z.Xgzgets(tls, file, uncompr, int32(uncomprLen))
	if libc.Xstrlen(tls, uncompr) != uint64(7) { // " hello!"
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+272 /* "gzgets err after..." */, libc.VaList(bp+64, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, (uintptr(unsafe.Pointer(&hello))+uintptr(6))) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+301 /* "bad gzgets after..." */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+326 /* "gzgets() after g..." */, libc.VaList(bp+72, uncompr))
	}

	z.Xgzclose(tls, file)
}

// ===========================================================================
// Test deflate() with small buffers
func test_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:200:6: */
	bp := tls.Alloc(176)
	defer tls.Free(176)

	// var c_stream z_stream at bp+64, 112
	// compression stream
	var err int32
	var len uLong = (libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello))) + uint64(1))

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64 /* &c_stream */, -1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr

	for ((*z_stream)(unsafe.Pointer(bp+64 /* &c_stream */)).total_in != len) && ((*z_stream)(unsafe.Pointer(bp+64 /* &c_stream */)).total_out < comprLen) {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = libc.AssignPtrUint32(bp+64 /* &c_stream */ +32 /* &.avail_out */, uInt(1)) // force small buffers
		err = z.Xdeflate(tls, bp+64 /* &c_stream */, 0)
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	// Finish the stream, still forcing small buffers:
	for {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(1)
		err = z.Xdeflate(tls, bp+64 /* &c_stream */, 4)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XdeflateEnd(tls, bp+64 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with small buffers
func test_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:238:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(0)
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	for ((*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out < uncomprLen) && ((*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_in < comprLen) {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = libc.AssignPtrUint32(bp+56 /* &d_stream */ +32 /* &.avail_out */, uInt(1)) // force small buffers
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+403 /* "inflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+422 /* "bad inflate\n" */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+435 /* "inflate(): %s\n" */, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Test deflate() with large buffers and dynamic change of compression level
func test_large_deflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:279:6: */
	bp := tls.Alloc(192)
	defer tls.Free(192)

	// var c_stream z_stream at bp+80, 112
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+80 /* &c_stream */, 1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_out = uInt(comprLen)

	// At this point, uncompr is still mostly zeroes, so it should compress
	// very well:
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+80 /* &c_stream */)).avail_in != uInt(0) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+450 /* "deflate not gree..." */, 0)
		libc.Xexit(tls, 1)
	}

	// Feed in already compressed data and switch to no compression:
	z.XdeflateParams(tls, bp+80 /* &c_stream */, 0, 0)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = (uInt(comprLen) / uInt(2))
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	// Switch back to compressing mode:
	z.XdeflateParams(tls, bp+80 /* &c_stream */, 9, 1)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 4)
	if err != 1 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+470 /* "deflate should r..." */, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+80 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+64, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with large buffers
func test_large_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:334:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	for {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr // discard the output
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+506 /* "large inflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out != ((uint64(2) * uncomprLen) + (comprLen / uint64(2))) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+520 /* "bad large inflat..." */, libc.VaList(bp+48, (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+544 /* "large_inflate():..." */, 0)
	}
}

// ===========================================================================
// Test deflate() with full flush
func test_flush(tls *libc.TLS, compr uintptr, comprLen uintptr) { /* example.c:375:6: */
	bp := tls.Alloc(176)
	defer tls.Free(176)

	// var c_stream z_stream at bp+64, 112
	// compression stream
	var err int32
	var len uInt = (uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1))

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64 /* &c_stream */, -1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = uInt(3)
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(*(*uLong)(unsafe.Pointer(comprLen)))
	err = z.Xdeflate(tls, bp+64 /* &c_stream */, 3)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*Byte)(unsafe.Pointer(compr + 3))++ // force an error in first compressed block
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = (len - uInt(3))

	err = z.Xdeflate(tls, bp+64 /* &c_stream */, 4)
	if err != 1 {
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	err = z.XdeflateEnd(tls, bp+64 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*uLong)(unsafe.Pointer(comprLen)) = (*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).total_out
}

// ===========================================================================
// Test inflateSync()
func test_sync(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:413:6: */
	bp := tls.Alloc(184)
	defer tls.Free(184)

	var err int32
	// var d_stream z_stream at bp+72, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(2) // just read the zlib header

	err = z.XinflateInit_(tls, bp+72 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_out = uInt(uncomprLen)

	err = z.Xinflate(tls, bp+72 /* &d_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+403 /* "inflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = (uInt(comprLen) - uInt(2)) // read all compressed data
	err = z.XinflateSync(tls, bp+72 /* &d_stream */)                                           /* but skip the damaged part */
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+565 /* "inflateSync" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xinflate(tls, bp+72 /* &d_stream */, 4)
	if err != (-3) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+577 /* "inflate should r..." */, 0)
		// Because of incorrect adler32
		libc.Xexit(tls, 1)
	}
	err = z.XinflateEnd(tls, bp+72 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xprintf(tls, ts+611 /* "after inflateSyn..." */, libc.VaList(bp+64, uncompr))
}

// ===========================================================================
// Test deflate() with preset dictionary
func test_dict_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:457:6: */
	bp := tls.Alloc(160)
	defer tls.Free(160)

	// var c_stream z_stream at bp+48, 112
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+48 /* &c_stream */, 9, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.XdeflateSetDictionary(tls, bp+48, /* &c_stream */
		uintptr(uintptr(unsafe.Pointer(&dictionary))), uint32(int32(unsafe.Sizeof(dictionary))))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+639 /* "deflateSetDictio..." */, err))
			libc.Xexit(tls, 1)
		}
	}

	dictId = (*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).adler
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_out = uInt(comprLen)

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_in = (uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1))

	err = z.Xdeflate(tls, bp+48 /* &c_stream */, 4)
	if err != 1 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+470 /* "deflate should r..." */, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+48 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with a preset dictionary
func test_dict_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:494:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)

	for {
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		if err == 2 {
			if (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).adler != dictId {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+660 /* "unexpected dicti..." */, 0)
				libc.Xexit(tls, 1)
			}
			err = z.XinflateSetDictionary(tls, bp+56 /* &d_stream */, uintptr(uintptr(unsafe.Pointer(&dictionary))),
				uint32(int32(unsafe.Sizeof(dictionary))))
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+682 /* "inflate with dic..." */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+700 /* "bad inflate with..." */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+723 /* "inflate with dic..." */, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Usage:  example [output.gz  [input.gz]]

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* example.c:545:5: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var compr uintptr
	var uncompr uintptr
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = (uint64(10000) * uint64(unsafe.Sizeof(int32(0)))) // don't overflow on MSDOS
	var uncomprLen uLong = *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */))

	if int32(*(*int8)(unsafe.Pointer(z.XzlibVersion(tls)))) != int32(*(*int8)(unsafe.Pointer(myVersion))) {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+752 /* "incompatible zli..." */, 0)
		libc.Xexit(tls, 1)

	} else if libc.Xstrcmp(tls, z.XzlibVersion(tls), ts+353 /* "1.2.11" */) != 0 {
		libc.Xfprintf(tls, (uintptr(unsafe.Pointer(&libc.X__sF)) + 2*152), ts+779 /* "warning: differe..." */, 0)
	}

	libc.Xprintf(tls, ts+812, /* "zlib version %s ..." */
		libc.VaList(bp, ts+353 /* "1.2.11" */, 0x12b0, z.XzlibCompileFlags(tls)))

	compr = libc.Xcalloc(tls, uint64(uInt(*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))), uint64(1))
	uncompr = libc.Xcalloc(tls, uint64(uInt(uncomprLen)), uint64(1))
	// compr and uncompr are cleared to avoid reading uninitialized
	// data and to ensure that uncompr compresses well.
	if (compr == uintptr(0)) || (uncompr == uintptr(0)) {
		libc.Xprintf(tls, ts+861 /* "out of memory\n" */, 0)
		libc.Xexit(tls, 1)
	}

	test_compress(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_gzio(tls, func() uintptr {
		if argc > 1 {
			return *(*uintptr)(unsafe.Pointer(argv + 1*8))
		}
		return ts + 876 /* "foo.gz" */
	}(),
		uncompr, uncomprLen)

	test_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_large_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	test_large_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_flush(tls, compr, bp+24 /* &comprLen */)
	test_sync(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uncomprLen

	test_dict_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_dict_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	libc.Xfree(tls, compr)
	libc.Xfree(tls, uncompr)

	return 0
}

var myVersion uintptr = ts + 353 /* "1.2.11" */ /* example.c:552:22 */

var ts1 = "hello, hello!\x00hello\x00%s error: %d\n\x00compress\x00garbage\x00uncompress\x00bad uncompress\n\x00uncompress(): %s\n\x00wb\x00gzopen error\n\x00ello\x00gzputs err: %s\n\x00, %s!\x00gzprintf err: %s\n\x00rb\x00gzread err: %s\n\x00bad gzread: %s\n\x00gzread(): %s\n\x00gzseek error, pos=%ld, gztell=%ld\n\x00gzgetc error\n\x00gzungetc error\n\x00gzgets err after gzseek: %s\n\x00bad gzgets after gzseek\n\x00gzgets() after gzseek: %s\n\x001.2.11\x00deflateInit\x00deflate\x00deflateEnd\x00inflateInit\x00inflate\x00inflateEnd\x00bad inflate\n\x00inflate(): %s\n\x00deflate not greedy\n\x00deflate should report Z_STREAM_END\n\x00large inflate\x00bad large inflate: %ld\n\x00large_inflate(): OK\n\x00inflateSync\x00inflate should report DATA_ERROR\n\x00after inflateSync(): hel%s\n\x00deflateSetDictionary\x00unexpected dictionary\x00inflate with dict\x00bad inflate with dict\n\x00inflate with dictionary: %s\n\x00incompatible zlib version\n\x00warning: different zlib version\n\x00zlib version %s = 0x%04x, compile flags = 0x%lx\n\x00out of memory\n\x00foo.gz\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
