/*
Copyright 2022 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "knative.dev/serving/pkg/apis/serving/v1beta1"
)

// FakeDomainMappings implements DomainMappingInterface
type FakeDomainMappings struct {
	Fake *FakeServingV1beta1
	ns   string
}

var domainmappingsResource = v1beta1.SchemeGroupVersion.WithResource("domainmappings")

var domainmappingsKind = v1beta1.SchemeGroupVersion.WithKind("DomainMapping")

// Get takes name of the domainMapping, and returns the corresponding domainMapping object, and an error if there is any.
func (c *FakeDomainMappings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.DomainMapping, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(domainmappingsResource, c.ns, name), &v1beta1.DomainMapping{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DomainMapping), err
}

// List takes label and field selectors, and returns the list of DomainMappings that match those selectors.
func (c *FakeDomainMappings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.DomainMappingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(domainmappingsResource, domainmappingsKind, c.ns, opts), &v1beta1.DomainMappingList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.DomainMappingList{ListMeta: obj.(*v1beta1.DomainMappingList).ListMeta}
	for _, item := range obj.(*v1beta1.DomainMappingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested domainMappings.
func (c *FakeDomainMappings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(domainmappingsResource, c.ns, opts))

}

// Create takes the representation of a domainMapping and creates it.  Returns the server's representation of the domainMapping, and an error, if there is any.
func (c *FakeDomainMappings) Create(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.CreateOptions) (result *v1beta1.DomainMapping, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(domainmappingsResource, c.ns, domainMapping), &v1beta1.DomainMapping{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DomainMapping), err
}

// Update takes the representation of a domainMapping and updates it. Returns the server's representation of the domainMapping, and an error, if there is any.
func (c *FakeDomainMappings) Update(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (result *v1beta1.DomainMapping, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(domainmappingsResource, c.ns, domainMapping), &v1beta1.DomainMapping{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DomainMapping), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDomainMappings) UpdateStatus(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (*v1beta1.DomainMapping, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(domainmappingsResource, "status", c.ns, domainMapping), &v1beta1.DomainMapping{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DomainMapping), err
}

// Delete takes name of the domainMapping and deletes it. Returns an error if one occurs.
func (c *FakeDomainMappings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(domainmappingsResource, c.ns, name, opts), &v1beta1.DomainMapping{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDomainMappings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(domainmappingsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.DomainMappingList{})
	return err
}

// Patch applies the patch and returns the patched domainMapping.
func (c *FakeDomainMappings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DomainMapping, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(domainmappingsResource, c.ns, name, pt, data, subresources...), &v1beta1.DomainMapping{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DomainMapping), err
}
